<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\Coupon;
use App\Models\Site;
use Illuminate\Support\Facades\Auth;

class CouponController extends Controller
{
	public function list($id=null, Request $request)
	{
		$site_id=base64_decode($id);
        $result = Coupon::where('site_id', $site_id)->orderBy('created_at', 'desc')->get();
        $site = Site::where('id', $site_id)->first();
        return view('admin.coupon.list', ['result' => $result, 'request' => $request, 'site_id' => $site_id, 'site' => $site]);
    }

    public function add($id=null, Request $request)
    {
    	$site_id = base64_decode($id);
        $obj = new Coupon;

        if($request->isMethod('POST')){

            $request->validate([
                'coupon_code'=>'required',
                'discount_type'=>'required',
                'related_to'=>'required',
                'amount'=>'required',
                'start_date'=>'required',
                'end_date'=>'required',
                'minimum_cart_amount'=>'required'
            ]);

            if($coupon = $obj->create([
                    'site_id' => $site_id,
                    'coupon_code' => $request->coupon_code,
                    'type' => $request->discount_type,
                    'related_to' => $request->related_to,
                    'amount' => $request->amount,
                    'start_date' => $request->start_date,
                    'end_date' => $request->end_date,
                    'minimum_cart_amount' => $request->minimum_cart_amount,
                    'created_by' => Auth::guard('AdminLogin')->user()->id
                ]))
            {
                $request->session()->flash('alert-success', 'Coupon successfully added.');
                return redirect()->route('admin.coupon.list', ['id' => base64_encode($site_id)]);
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }

        }

        return view('admin.coupon.add', ['request' => $request, 'site_id' => $site_id ]);
    }

    public function edit($id = null, Request $request){

        $id = base64_decode($id);
		$dataDetails  = Coupon::where('id',$id)->first();

		$siteId = $dataDetails->site_id;

        if($request->isMethod('POST')){

            $request->validate([
                'coupon_code'=>'required',
                'discount_type'=>'required',
                'related_to'=>'required',
                'amount'=>'required',
                'start_date'=>'required',
                'end_date'=>'required',
                'minimum_cart_amount'=>'required'
            ]);

                $obj = Coupon::find($id);
                $obj->coupon_code =  $request->coupon_code;
                $obj->type =  $request->discount_type;
                $obj->related_to =  $request->related_to;
                $obj->amount =  $request->amount;
                $obj->start_date =  $request->start_date;
                $obj->end_date =  $request->end_date;
                $obj->minimum_cart_amount =  $request->minimum_cart_amount;
                $obj->update();

             if($obj){
                $request->session()->flash('alert-success', 'Coupon successfully updated.');
                return redirect()->route('admin.coupon.list', ['id' => base64_encode($siteId)]);
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
        }

        return view('admin.coupon.edit', ['dataDetails' => $dataDetails, 'request' => $request, 'siteId' => $siteId]);
    }

    public function delete($id = null, Request $request)
    {
        if($id == null){
        	return redirect()->back();
            // return redirect()->route('admin.testimonial.list', ['id' => 1]);
        }
        $id = base64_decode($id);

        //@unlink(public_path() . '/uploaded/event_images/' . $event_details->eimg);

        if( Coupon::where(['id' => $id])->delete()){
            $request->session()->flash('alert-success', 'Coupon deleted successfully.');
            return redirect()->back();
        }else{
            $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
            return redirect()->back();
        }
    }

    public function status(Request $request)
    {
        if($request->id == null || $request->status == null){
            // return redirect()->route('admin.category.list');
        }
        $id = base64_decode($request->id);
        switch($request->status){
            case 'N':
                $block = 'Y';
                $blockText = 'Block';
                break;
            case 'Y':
                $block = 'N';
                $blockText = 'Unblock';
                break;
            default:
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back();
        }

        if(Coupon::where(['id' => $id])->update(['is_block' => $block])){
            $prompt = array('status' => 1, 'id' => $id, 'event' => $blockText);
            echo json_encode($prompt);
        }else{
            $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
            return redirect()->back();
        }
    }
}