<?php

return [

    /*
    |--------------------------------------------------------------------------
    | PDF Storage Paths
    |--------------------------------------------------------------------------
    |
    | These paths are used by DomPDF to locate fonts and store cached data.
    |
    */
    'show_warnings' => false,
    'orientation' => 'portrait',
    'defines' => [
        'font_dir' => storage_path('fonts/'),   // Path to your fonts directory
        'font_cache' => storage_path('fonts/'), // Path to your font cache
        'temp_dir' => storage_path('app'),      // Temporary directory for DomPDF
        'chroot' => base_path(),                // Restrict DomPDF to project root
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Font
    |--------------------------------------------------------------------------
    |
    | This will be used when no font is specified in the view.
    |
    */
    'default_font' => 'noto_sans_devanagari',

    /*
    |--------------------------------------------------------------------------
    | Fonts
    |--------------------------------------------------------------------------
    |
    | Register custom fonts (Hindi + English). Make sure you place the fonts
    | in the "storage/fonts" folder.
    |
    */
    'fonts' => [
        'noto_sans_devanagari' => [
            'normal' => storage_path('fonts/NotoSansDevanagari-Regular.ttf'),
            'bold' => storage_path('fonts/NotoSansDevanagari-Bold.ttf'),
            'italic' => storage_path('fonts/NotoSansDevanagari-Regular.ttf'),
            'bold_italic' => storage_path('fonts/NotoSansDevanagari-Bold.ttf'),
        ],
        'sans-serif' => [
            'normal' => storage_path('fonts/NotoSansDevanagari-Regular.ttf'),
            'bold' => storage_path('fonts/NotoSansDevanagari-Bold.ttf'),
            'italic' => storage_path('fonts/NotoSansDevanagari-Regular.ttf'),
            'bold_italic' => storage_path('fonts/NotoSansDevanagari-Bold.ttf'),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Options
    |--------------------------------------------------------------------------
    |
    | Additional DomPDF options.
    |
    */
    'dpi' => 96,
    'default_paper_size' => 'a4',
    'enable_php' => false,
    'enable_remote' => true,
    'enable_html5_parser' => true,
    'isRemoteEnabled' => true,
    'isHtml5ParserEnabled' => true,
];
