@extends('layouts.admin.app')
@section('content')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/DataTables/datatables.min.js') }}"></script>
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/extra-libs/multicheck/multicheck.css') }}">
    <link href="{{ asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet"> -->

    <main id="main" class="main">

        @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M')
	        <div class="page-breadcrumb">
                <div class="row">
                    <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                        <h4 class="page-title">Addon List</h4>
                        <div class="ml-auto text-right">
                            <a href="{{route('admin.addon.addon_add')}}" class="btn btn-success">ADD Addon</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                                    @if(Session::has('alert-' . $msg))
                                        <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                                    @endif
                                @endforeach
                                <h5 class="card-title">Addon List</h5>
                                @if($result->count() != 0)
                                    <div class="table-responsive" style="font-size: 13px;">
                                        <table id="zero_config" class="table table-striped table-bordered">
                                            <thead>
                                                <tr>
                                                    <th style="width: 3%"><b>No.</b></th>
                                                    <th style="width: 8%"><b>Image</b></th>
                                                    <th style="width: 25%"><b>Title</b></th>
                                                    <th style="width: 8%"><b>{!! CustomPaginator::sort('fnid', 'ID/SKU', ['direction' => true]) !!}</b></th>
                                                    <th style="width: 9%"><b>Price</b></th>
                                                    <th style="width: 9%"><b>{!! CustomPaginator::sort('is_block', 'Status', ['direction' => true]) !!}</b></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $i=1; @endphp
                                                @foreach($result as $key => $products)
                                                    <tr>
                                                        <td>{{ $i + $key }}</td>
                                                        <td>
                                                            @php 
                                                                $imagename = App\Http\Helper1::get_image($products->id);
                                                            @endphp

                                                            @if(isset($imagename) && $imagename->name != null )
                                                                <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/{{$imagename->name}}" style="width:90px; height: auto;"  >
                                                            @else
                                                                <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/no_image.jpg" style="width:90px; height: auto;"  >
                                                            @endif
                                                            <span style="color:#485256; font-size:9px; font-weight: 600">{{$products->old_id}}</span>
                                                        </td>
                                                        <td>
                                                            {{$products->product_name}}
                                                            <hr>
                                                            <br>
                                                                <b>Delivery Type : </b>
                                                                @if($products->delivery_type == 'C')
                                                                    Courier
                                                                @else
                                                                    Hand Delivery
                                                                @endif
                                                        </td>
                                                        <td>
                                                            {{$products->id}} / <span style="color:#2962ff; font-weight: 600"> {{$products->fnid}}</span>
                                                            @if(!empty($products->sku))
                                                                <span class="badge bg-secondary">{{$products->sku}}</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <b>&#8377; {{$products->price}}</b>
                                                            @if($products->actual_price > 0)
                                                                <span style="text-decoration:line-through;"> {{$products->actual_price}}</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <a href="{{ route('admin.addon.addon_edit', base64_encode($products->id).'?redirect='.urlencode($request->fullUrl())) }}">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <div class="card">No Data Found...</div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif    
    </main><!-- End #main -->

    <script>

        /****************************************
         *       Basic Table                   *
         ****************************************/

        // $('#zero_config').DataTable({
        //     "order": [[1, "asc"]] 
        // });

        document.addEventListener("DOMContentLoaded", function () {
            const table = document.querySelector("#zero_config");
            const dataTable = new simpleDatatables.DataTable(table, {
                sortable: true,
                fixedHeight: true,
                perPage: 50, // Show 50 records per page
                columns: [
                    { select: 5, sort: "desc" } // Sort by the 6th column (index 5) descending
                ]
            });
        });

        // $(function(){
        //     setTimeout(function(){ $('.alert').hide(); }, 3000);
        //     var status, id;
        //     $('#zero_config').on('change', '.blockstatus', function() {
        //     //$('.blockstatus').change(function(){
        //         if(this.checked){
        //             status = 'Y';
        //         }else{
        //             status = 'N'
        //         }
        //         id = $(this).attr('data-id');
        //         var ajaxurl = ""; 
        //         $.ajax({
        //             type : 'POST',
        //             url : ajaxurl,
        //             data : { 'id' : id, 'status' : status },
        //             headers: {
        //                     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        //             },
        //             success : function(response){
        //                 response = JSON.parse(response);
        //                 if(response.status == 1){
        //                     $('#status-info-'+response.id).html(response.event).fadeIn(100).delay(1000).fadeOut();
        //                 }
        //             },
        //             error : function(){
        //                 $('.selected_records_data').html('<span class="error-msg text-danger">There was an unexpected error!! Please try again later.</span>');
        //             }
        //         });
        //     });
        // })

    </script>

@endsection

