@extends('layouts.admin.app')

@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>

<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">

<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>



<main id="main" class="main">

    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M')

        <div class="page-breadcrumb">

            <div class="row">

                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">

                    <h4 class="page-title">Addon Mapping</h4>

                    <div class="ml-auto text-right">

                        <a href="{{ route('admin.addon.addon_sub_group') }}" class="btn btn-outline-info">Back</a>

                    </div>

                </div>

            </div>

        </div>



        <div class="container-fluid">

            <!-- ============================================================== -->

            <!-- Start Page Content -->

            <!-- ============================================================== -->

            <div class="row">

                <div class="col-12">

                    <div class="card">

                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)

                            @if(Session::has('alert-' . $msg))

                                <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>

                            @endif

                        @endforeach

                        <form action="{{ route('admin.addon.addon_sub_group_product_edit', base64_encode($dataDetails->id).'?redirect='.urlencode($request->fullUrl())) }}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">

                            @csrf

                            <div class="card-body">

                                <h4 class="card-title">Addon Mapping Add</h4>

                                {{--<input type="hidden" name="addon_group_id" value="<?php echo $addon_group_id; ?>">--}}

                                <div class="form-group m-t-20">

                                    <label>Addon Group<span>*</span></label>

                                    <select id="addon_group_id" name="addon_group_id" type="text" class="form-control" aria-required="true" aria-invalid="false" disabled>

                                        <option value="">Select Addon Group</option>

                                        @foreach ($addon_groups as $list)

                                            @if ($dataDetails->addon_group_id == $list->id)

                                            <option selected value="{{ $list->id }}">

                                            @else

                                                <option value="{{ $list->id }}">

                                            @endif

                                            {{ $list->title }}</option>

                                        @endforeach

                                    </select>

                                </div>

                                <div class="form-group m-t-20">

                                    <label>Addon Sub Group<span>*</span></label>

                                    <input type="text" class="form-control" id="name" name="name" value="{{$dataDetails->name}}" placeholder="Enter Addon Sub Group Name" disabled>

                                </div>

                                

                                <div class="form-group m-t-20" class="selectpicker">

                                    <input type="hidden" id="ad_grp_id" name="ad_grp_id" value="{{$dataDetails->addon_group_id}}">

                                    <input type="hidden" id="ad_sub_grp_id" name="ad_sub_grp_id" value="{{$dataDetails->id}}">



                                    <label>Addon Product<span>*</span></label>

                                    <select class="form-control selectpicker2" name="product_id[]" multiple="multiple" id="product_id" data-live-search="true" data-live-search-placeholder="Search" data-actions-box="true" style="width:100%; height: 36px;" required>

                                        @foreach($addonProduct as $list)

                                            <option value="{{$list->id}}">{{$list->product_name}} [{{$list->delivery_type}}] ( {{$list->fnid}}/{{$list->old_id}} )</option>

                                        @endforeach 

                                    </select>

                                    {{-- <select class="form-control selectpicker2" name="product_id[]" multiple="multiple" data-live-search="true" data-live-search-placeholder="Search" data-actions-box="true" id="pro_id" style="width:100%; height: 36px;" required> --}}

                            </select>

                                </div>

                                {{-- <div class="form-group m-t-20">

                                    <label>Sl. No</label>

                                    <input type="text" class="form-control" id="sl_no" name="sl_no" value="10" placeholder="Enter Sl No">

                                </div> --}}

                                

                            </div>

                            <div class="border-top">

                                <div class="card-body">

                                    <input class="btn btn-primary" type="submit" value="Submit">

                                </div>

                            </div>

                        </form>

                    </div>

                </div>

            </div>

        </div>

    @endif 

</main>   



<script type="text/javascript">

    $.validator.setDefaults({

            submitHandler: function(form) {

                form.submit();

            }

    });



    // $(function() {

    //     // validate the comment form when it is submitted

    //     $("#formadd").validate({

    //         ignore: [],

    //         errorPlacement: function(label, element) {

    //             label.addClass('mt-2 text-danger');

    //             label.insertAfter(element);

    //         },



    //         highlight: function(element, errorClass) {

    //             $(element).parents('.form-group').addClass('has-danger')

    //             $(element).addClass('form-control-danger')

    //         }



    //       });



    // });



    @php 

        $addon_selected = implode(',', $addon_selected);

    @endphp



    $(function(){



        $('.selectpicker2').selectpicker();



        $('#product_id').selectpicker('val', [<?php echo $addon_selected; ?>]);



        $('.selectpicker2').selectpicker('refresh');

    })





    // $(document).ready(function(){

    //     @php 

    //         $addon_selected = implode(',', $addon_selected);

    //     @endphp



    //     $.ajaxSetup({

    //           headers: {

    //               'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

    //           }

    //       });

    //     $.ajax({

    //       type : "POST",

    //       url : "{{route('admin.addon.getaddon')}}",

    //       data : { id : 99 },

    //       success : function(response){

    //         console.log(response)

    //         response = JSON.parse(response);

    //         if(response.status == "success"){

    //           $('#pro_id').html(response.data);

    //           $('#pro_id').selectpicker('val', [<?php echo $addon_selected; ?>]);



              

    //           $('.selectpicker2').selectpicker('refresh');

    //         }

    //       },

    //       error : function(){



    //       }

    //     });

    // })







    // CKEDITOR.replace("cbcontenttop");

    // CKEDITOR.replace("cbcontentbottom");



    // $('#title').on('blur', function(){

    //     var title = $.trim($(this).val());

    //     if(title != ''){

    //         //if($.trim($('#slug').val()) == ''){

    //             $('#slug').val(title.replace(/ /g,"-").toLowerCase());

    //             $('#slug-error').hide();

    //         //}

    //     }

    // });



    // $('.ctype').click(function(){

    //     if(this.value == 'P'){

    //         $('.price-range').show();

    //         $('#from_price').attr('required', true);

    //         $('#to_price').attr('required', true);

    //         $('#equation').attr('required', true);

    //     }else{

    //         $('.price-range').hide();

    //         $('#from_price').removeattr('required', true);

    //         $('#to_price').removeattr('required', true);

    //         $('#equation').removeattr('required', true);

    //     }

    // });



</script>    



@endsection



