@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Agents</h4>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <div class="card-body">

                            <h4 class="card-title">Select an Agent</h4>

                            <div class="row mb-3">
                              <label class="col-sm-2 col-form-label">Choose Agent</label>
                              <div class="col-sm-10">
                                <select id="agent_id" name="agent_id" type="text" class="form-control selectpicker"
                                    aria-required="true" aria-invalid="false" data-live-search="true" data-live-search-placeholder="Search" data-actions-box="true" required>
                                    <option value="">Select Agent</option>
                                    @foreach ($result as $list)
                                        <option value="{{ encrypt($list->id) }}">{{ $list->name }}</option>
                                    @endforeach
                                </select>
                              </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
</main>


<!-- <script type="text/javascript">

    $(document).ready(function () {
        $('#agent_id').on('change', function () {
            var agentId = $(this).val();
            if (agentId) {
                $.ajax({
                    url: "{{ url('/admin/agent/list') }}/" + agentId,
                    type: 'GET',
                    success: function (response) {
                        $('#agent-details').html(response);
                        // alert(response);
                    },
                    error: function () {
                        $('#agent-details').html('<p style="color:red;">Error fetching data</p>');
                    }
                });
            } else {
                $('#agent-details').html('');
            }
        });
    });

</script> -->   

<script type="text/javascript">

    $(document).ready(function () {
        $('.selectpicker').selectpicker(); 
    });



    $(document).ready(function () {

        $('#agent_id').on('change', function () {
            var agentId = $(this).val();
            if (agentId) {
                // Replace with your desired base URL
                let url = "{{ url('/admin/agent/agent-product-list') }}/" + agentId;
                window.location.href = url; // Redirect to the link
            } else {
                alert("No agent found");
            }
        });
    });

</script>

@endsection

