@extends('layouts.admin.app')
@section('content')

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Edit Blog</h4>
                    <div class="ml-auto text-right">
                        <a href="{{url('admin/blog/list/')}}/{{base64_encode($siteId)}}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
		    <div class="row">
		        <div class="col-12">
		            <div class="card">
		                @foreach (['danger', 'warning', 'success', 'info'] as $msg)
		                    @if(Session::has('alert-' . $msg))
		                        <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
		                    @endif
		                @endforeach
		                <form action="{{route('admin.blog.edit', base64_encode($dataDetails->id))}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
		                    @csrf
		                    <div class="card-body">
		                        <h4 class="card-title">Edit Blog</h4>
		                        
		                        <input type="hidden" name="formid" value="<?php echo $dataDetails->id; ?>">
		                        <input type="hidden" name="site_id" value="<?php echo $dataDetails->site_id; ?>">
		                        <input type="hidden" name="old_blog_image" value="{{ $dataDetails->blog_img }}">

		                        <div class="form-group m-t-20">
                                    <label>Blog Slug<span>*</span></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="blog_slug" name="blog_slug" value="{{$dataDetails->slug}}" placeholder="Enter Blog Slug" required>
                                    </div>
                                </div>
		                        <div class="form-group m-t-20">
                                    <label>Blog Image<span></span></label>
                                    <input type="file" class="form-control" id="blog_image" name="blog_image" value="{{$dataDetails->blog_img}}" placeholder="Enter Category Image">
                                    @if ($errors->has('blog_image'))
                                        <span class="text-danger">{{ $errors->first('blog_image') }}</span>
                                    @endif
                                </div>
                                @if($dataDetails->blog_img != null )
                                	<img src="{{ asset('upload/blog_images/' . $dataDetails->blog_img) }}" style="width:200px; height: 50px;"  >
                                @endif
                                <div class="form-group m-t-20">
                                    <label>Blog Post Date</label>
                                    <input type="datetime-local" class="form-control" id="blog_date" name="blog_date" value="{{$dataDetails->post_date}}" placeholder="Enter Blog Date" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Blog Heading</label>
                                    <textarea class="form-control" rows="5" id="blog_heading" name="blog_heading" placeholder="Enter Blog Heading" required>{{$dataDetails->blog_heading}}</textarea>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Blog Content</label>
                                    <textarea class="form-control" rows="5" id="blog_content" name="blog_content" placeholder="Enter Blog Content" required>{{$dataDetails->blog_content}}</textarea>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Meta Title</label>
                                    <input type="text" class="form-control" id="blogmeta_title" name="blogmeta_title" value="{{$dataDetails->meta_title}}" placeholder="Enter Meta Title" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Meta Description</label>
                                    <textarea class="form-control" rows="5" id="blogmeta_description" name="blogmeta_description" placeholder="Enter Meta Description" required>{{$dataDetails->meta_description}}</textarea>
                                </div>
		                        
		                    </div>
		                    <div class="border-top">
		                        <div class="card-body">
		                            <input class="btn btn-primary" type="submit" value="UPDATE">
		                        </div>
		                    </div>
		                </form>
		            </div>
		        </div>
		    </div>
		</div>
    @endif
</main> 

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>   

<script type="text/javascript">

	$(document).ready(function () {
        setTimeout(function () {
            $('.cke_notifications_area').attr("style", "display: none !important");
        }, 1000); // 60000ms = 1 minute
    });

    $.validator.setDefaults({
	    submitHandler: function(form) {
	        form.submit();
	    }
    });

    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }
          });
    });

    CKEDITOR.replace("blog_content");

</script>     

@endsection