@extends('layouts.admin.app')
@section('content')

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.5/xlsx.full.min.js"></script>  

<main id="main" class="main">

    @if(Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">CATEGORY</h4>
                    <div class="ml-auto text-right">
                        <a href="{{ route('admin.product.list') }}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <br>
                            <h4>Import the Bulkcategory File</h4>
                            @if(session('message'))
                                <h4>{{ session('message') }}</h4>
                            @endif
                        </div>
                        <div class="card-body">
                            <form action="" method="post">
                                @csrf
                                <label>Upload Excel File</label>
                                <input type="file" class="form-control" name="bulk_upload" id="bulk_upload" required>
                                <div id="upload_table"></div>
                                <br>
                                <div id="button"></div>
                                <input type="hidden" class="form-control" name="all" id="all"/>
                            </form>
                        </div>
                        <div class="card-body">
                            <div>
                                <span class="badge bg-primary">The Following Field Values will be uploaded</span>
                            </div>
                            <table id="product_table" style="width:100%; text-align: center;" border="1">
                                <tr>
                                    <td><b>Name</b></td>
                                    <td><b>Slug</b></td>
                                    <td><b>Image</b></td>
                                    <td><b>Image Alt</b></td>
                                    <td><b>Page Head</b></td>
                                    <td><b>Banner Heading</b></td>
                                    <td><b>Content Top</b></td>
                                    <td><b>Content Bottom</b></td>
                                    <td><b>Tag Line</b></td>
                                    <td><b>Tophead</b></td>
                                    <td><b>Sort</b></td>
                                    <td><b>Meta Title</b></td>
                                    <td><b>Meta Keyword</b></td>
                                    <td><b>Meta Description</b></td>                   
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif    
</main>

<!-- <script type="text/javascript">
    $(document).ready(function(){
        $('#btnValidar').click(function(e) {
            e.preventDefault();
            var file = $('#excel_file')[0].files[0];  // Get the file input
            if (!file) {
                alert("Please select a file.");
                return;
            }
            var reader = new FileReader();
            reader.onload = function(event) {
                var data = event.target.result;
                var workbook = XLSX.read(data, {type: 'binary'});
                // Assuming the Excel file contains the data in the first sheet
                var firstSheet = workbook.Sheets[workbook.SheetNames[0]];
                var jsonData = XLSX.utils.sheet_to_json(firstSheet);
                // Preview parsed data (optional)
                console.log(jsonData);
                // Send the data to the backend
                $.ajax({
                    url: "{{ route('admin.product.bulkproductupload') }}",
                    method: 'POST',
                    data: {
                        _token: "{{ csrf_token() }}",  // CSRF token for Laravel
                        products: JSON.stringify(jsonData)
                    },
                    success: function(response) {
                        console.log(response);
                        alert('Data uploaded successfully!');
                    },
                    error: function(error) {
                        console.log(error);
                        alert("An error occurred.");
                    }
                });
            };
            reader.readAsBinaryString(file);  // Read the file as a binary string
        });
    });
</script> -->

<script>
    $(document).ready(function(){
        $('#bulk_upload').change(function(evt){
          $('#button').empty();

          $('#button').append(`
          <button class="btn btn-primary" type="submit" id="">Import</button> 
          `);
            var files = evt.target.files;
            var xl2json = new ExcelToJSON();
            xl2json.parseExcel(files[0]);
            $('#all').empty();
            $('#upload_table').empty();
        });


      // $(document).on('click', '#btn_upload', function(event) {
      // var value = event.detail; 
      // console.log(event);
      // });

        var getting_value = function(value){
            $(document).trigger('customEvent', value); 
        };

       var ExcelToJSON = function() {
       this.productList = [];

       this.parseExcel = function(file) {
        var reader = new FileReader();

        var self = this; 

        reader.onload = function(e) {
          var data = e.target.result;
          var workbook = XLSX.read(data, { type: 'binary' });
          workbook.SheetNames.forEach(function(sheetName) {
            var XL_row_object = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[sheetName]);
            self.productList = JSON.parse(JSON.stringify(XL_row_object)); 
            var tableHtml = `
              <table class="table table-striped table-dark" id="excel_table">
                <thead>
                  <tr>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Image</th>
                    <th>Image Alt</th>
                    <th>Page Head</th>
                    <th>Banner Heading</th>
                    <th>Content Top</th>
                    <th>Content Bottom</th>
                    <th>Tag Line</th>
                    <th>Tophead</th>
                    <th>Sort</th>
                    <th>Meta Title</th>
                    <th>Meta Keyword</th>
                    <th>Meta Description</th>
                  </tr>
                </thead>
                <tbody>
            `;
            var i = 0;
            $.each(self.productList, function(index, item) {
              var columns = Object.values(item);
              i++;
              tableHtml += `
                <tr>
                  <td>${columns[0]}</td>
                  <td>${columns[1]}</td>
                  <td>${columns[2]}</td>
                  <td>${columns[3]}</td>
                  <td>${columns[4]}</td>
                  <td>${columns[5]}</td>
                  <td>${columns[6]}</td>
                  <td>${columns[7]}</td>
                  <td>${columns[8]}</td>
                  <td>${columns[9]}</td>
                  <td>${columns[10]}</td>
                  <td>${columns[11]}</td>
                  <td>${columns[12]}</td>
                  <td>${columns[13]}</td>
                </tr>
              `;
            });

            tableHtml += `
                </tbody>
              </table>
            `;

            $('#upload_table').html(tableHtml);
            var value = self.productList;
            getting_value(value);
            $('#all').val(JSON.stringify(self.productList));

          });
        };

        reader.onerror = function(ex) {
          console.log(ex);
        };

        reader.readAsBinaryString(file);
      };
        };

    var excelToJson = new ExcelToJSON();

  });
</script>

@endsection

