@extends('layouts.admin.app')

@section('content')


    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/DataTables/datatables.min.js') }}"></script>
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/extra-libs/multicheck/multicheck.css') }}">
    <link href="{{ asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet"> -->



    <main id="main" class="main">

        @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M')

	        <div class="page-breadcrumb">

                <div class="row">

                    <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">

                        <h4 class="page-title">Category</h4>

                        <div class="ml-auto text-right">

                            <a href="" class="btn btn-info" title="Bulk Upload Category"><i class="fas fa-upload"></i></a>

                            <a href="" class="btn btn-secondary" title="Bulk Update Category"><i class="fas fa-edit"></i></a>

                            <a href="{{url('admin/category/list_banners_add/')}}/{{encrypt($category_id)}}" class="btn btn-success">ADD Banner</a>

                        </div>

                    </div>

                </div>

            </div>

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="card">

                            <div class="card-body">

                                @foreach (['danger', 'warning', 'success', 'info'] as $msg)

                                    @if(Session::has('alert-' . $msg))

                                        <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>

                                    @endif

                                @endforeach

                                <h5 class="card-title">Category</h5>

                                @if(count($list_banners) > 0)

                                    <div class="table-responsive">

                                        <table id="zero_config" class="table table-striped table-bordered">

                                            <thead>

                                                <tr>

                                                    <th style="width: 5%"><b>No.</b></th>

                                                    {{--<th style="width: 20%"><b>Banner</b></th>--}}

                                                    <th style="width: 20%"><b>Site</b></th>

                                                    <th style="width: 15%"><b>Created Date</b></th>

                                                    <th style="width: 6%"><b>Status</b></th>

                                                    <th style="width: 9%">Action</th>

                                                </tr>

                                            </thead>

                                            <tbody>

                                                @php $i=1; @endphp

                                                @foreach($list_banners as $key => $data)

                                                <tr>

                                                    <td>{{ $i + $key }}</td>

                                                    {{--<td>

                                                        @if($data->image != null )

                                                        <a href="{{ asset('upload/category_banners/' . $data->image) }}" target="blank">

                                                            <img style="width: 300px; height: auto; border-radius: 1%;"

                                                            src="{{ asset('upload/category_banners/' . $data->image) }}"

                                                            alt="">

                                                        </a>    

                                                        @endif

                                                    </td>--}}

                                                    <td>{{$data->site_name}}</td>

                                                    <td>{{date('d-m-Y', strtotime($data->created_at))}}</td>

                                                    <td>

                                                        <label class="switch">

                                                            <input type="checkbox" class="blockstatus" name="stat" id="stat" data-id="{{ base64_encode($data->id) }}" @if($data->is_block == 'N') checked @endif>

                                                            <span class="slider roundsemi"></span>

                                                        </label>

                                                        <label id="status-info-{{ $data->id }}" class="status-stat"></label>

                                                    </td>

                                                    <td >

                                                        <a href="{{url('admin/category/list_banners_edit/')}}/{{encrypt($data->id)}}">

                                                            <i class="fas fa-edit"></i>

                                                        </a>

                                                        {{--<a onclick="return confirm('Are you sure you want to delete the Category?')" href="">

                                                            <i class="fas fa-trash-alt"></i>

                                                        </a>

                                                        <a href="" target="_blank">

                                                            <i class="fas fa-eye"></i>

                                                        </a>--}}

                                                    </td>

                                                </tr>

                                                @endforeach

                                            </tfoot>

                                        </table>

                                    </div>

                                @else

                                    <div class="card">No Data Found...</div>

                                @endif

                                <input type="hidden" name="category_id" value="<?php echo $category_id; ?>">

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        @endif    

    </main><!-- End #main -->

    <script>

        /****************************************

         *       Basic Table                   *

         ****************************************/

        // $('#zero_config').DataTable({

        //     "order": [[5, "desc"]] 

        // });

        document.addEventListener("DOMContentLoaded", function () {
            const table = document.querySelector("#zero_config");
            const dataTable = new simpleDatatables.DataTable(table, {
                sortable: true,
                fixedHeight: true,
                columns: [
                    { select: 5, sort: "desc" } // Sort by the 6th column (index 5) descending
                ]
            });
        });


        $(function(){

            setTimeout(function(){ $('.alert').hide(); }, 3000);

            var status, id;

            $('#zero_config').on('change', '.blockstatus', function() {

            //$('.blockstatus').change(function(){

                if(this.checked){

                    status = 'Y';

                }else{

                    status = 'N'

                }

                id = $(this).attr('data-id');

                var ajaxurl = "{{ route('admin.category.catbanstatus') }}"; 

                $.ajax({

                    type : 'POST',

                    url : ajaxurl,

                    data : { 'id' : id, 'status' : status },

                    headers: {

                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

                    },

                    success : function(response){

                        response = JSON.parse(response);

                        if(response.status == 1){

                            $('#status-info-'+response.id).html(response.event).fadeIn(100).delay(1000).fadeOut();

                        }

                    },

                    error : function(){

                        $('.selected_records_data').html('<span class="error-msg text-danger">There was an unexpected error!! Please try again later.</span>');

                    }

                });

            });

        })



        

    </script>

@endsection

