@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>


<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">CATEGORY BANNER</h4>
                    <div class="ml-auto text-right">
                        <a href="{{ route('admin.category.list') }}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                            @endif
                        @endforeach
                        <form action="{{url('admin/category/list_banners_add/')}}/{{encrypt($category_id)}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">Category Banner Add</h4>
                                <input type="hidden" name="category_id" value="<?php echo $category_id; ?>">
                                <div class="form-group m-t-20">
                                    <label>Site<span>*</span></label>
                                    <select id="site_id" name="site_id" type="text" class="form-control"
                                        aria-required="true" aria-invalid="false" required>
                                        <option value="">Select Site</option>
                                        @foreach ($sites as $list)
                                            <option value="{{ $list->id }}">
                                            {{ $list->site_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                {{--<div class="form-group m-t-20">
                                    <label>Category Image<span>*</span></label>
                                    <input type="file" class="form-control" id="image" name="image" value="" placeholder="Enter Category Image" required>
                                    <p>Please upload minimum 1530px X 270px image only.</p>
                                </div>--}}
                                <div class="form-group m-t-20">
                                    <label>Banner Alt Msg</label>
                                    <input type="text" class="form-control" id="cbhead" name="cbhead" placeholder="Enter Banner Alt Msg" >
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Banner Heading</label>*</span></label>
                                    <input type="text" class="form-control" id="cbannerhead" name="cbannerhead" placeholder="Enter Banner Heading" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Content Top</label>
                                    <textarea class="form-control" rows="5" id="cbcontenttop" name="cbcontenttop" placeholder="Enter Content Top" ></textarea>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Content Bottom</label>
                                    <textarea class="form-control" rows="5" id="cbcontentbottom" name="cbcontentbottom" placeholder="Enter Content Bottom" ></textarea>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Meta Title</label>
                                    <input type="text" class="form-control" id="cbmeta_title" name="cbmeta_title" placeholder="Enter Meta Title" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Meta Description</label>
                                    <textarea class="form-control" rows="5" id="cbmeta_description" name="cbmeta_description" placeholder="Enter Meta Description" required></textarea>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Tagline</label>
                                    <input type="text" class="form-control" id="cbtagline" name="cbtagline" placeholder="Enter Tagline" >
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Top Head</label>
                                    <input type="text" class="form-control" id="cbtophead" name="cbtophead" placeholder="Enter Tophead" >
                                </div>
                            </div>

                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="CREATE">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif 
</main>   

<script type="text/javascript">

    $.validator.setDefaults({
        submitHandler: function(form) {
            form.submit();
        }
    });

    $(document).ready(function () {
        setTimeout(function () {
            $('.cke_notifications_area').attr("style", "display: none !important");
        }, 1000); // 60000ms = 1 minute
    });

    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },

            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }

          });
    });

    CKEDITOR.replace("cbcontenttop");
    CKEDITOR.replace("cbcontentbottom");

    $('#title').on('blur', function(){
        var title = $.trim($(this).val());
        if(title != ''){
            //if($.trim($('#slug').val()) == ''){
                $('#slug').val(title.replace(/ /g,"-").toLowerCase());
                $('#slug-error').hide();
            //}
        }

    });

    $('.ctype').click(function(){

        if(this.value == 'P'){

            $('.price-range').show();
            $('#from_price').attr('required', true);
            $('#to_price').attr('required', true);
            $('#equation').attr('required', true);
        }else{
            $('.price-range').hide();
            $('#from_price').removeattr('required', true);
            $('#to_price').removeattr('required', true);
            $('#equation').removeattr('required', true);
        }
    });

</script>    

@endsection

