@extends('layouts.admin.app')

@section('content')

    <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/DataTables/datatables.min.js') }}"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>

    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/extra-libs/multicheck/multicheck.css') }}">
    <link href="{{ asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet"> -->

    <main id="main" class="main">
        @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M')
	        <div class="page-breadcrumb">
			    <div class="row">
			        <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
			        	<h4 class="page-title">HomeFeatureManagement</h4>
			            <div class="ml-auto text-right">
			                <a href="{{url('admin/homefeaturemanagement/add/')}}/{{base64_encode($site_id)}}" class="btn btn-success">ADD HomeFeatureManagement</a>
			            </div>
			        </div>
			    </div>
			</div>
            <!-- modal head -->
            <head>
                <style>
                    #sortable { list-style-type: none; margin: 0; padding: 0; width: 80%; height: auto; }
                    #sortable li { margin: 0 3px 3px 3px; padding: 0.4em; padding-left: 1.5em; font-size: 1.4em; height: auto; }
                    #sortable li span { position: absolute; margin-left: -1.3em; }
                </style>
            </head>
            <!-- modal head close -->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                                    @if(Session::has('alert-' . $msg))
                                        <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                                    @endif
                                @endforeach
                                <h5 class="card-title">HomeFeatureManagement</h5>
                                @if(count($result) > 0)
                                    <div class="table-responsive">
                                        <table id="zero_config" class="table table-striped table-bordered">
                                            <thead>
                                                <tr>
                                                    <th style="width: 5%"><b>No.</b></th>
                                                    <th style="width: 25%"><b>Title</b></th>
                                                    <th style="width: 35%"><b>Site</b></th>
                                                    <th style="width: 35%"><b>Category</b></th>
                                                    <th style="width: 20%"><b>Created Date</b></th>
                                                    <th style="width: 6%"><b>Status</b></th>
                                                    <th style="width: 9%">Action</th>
                                                    <th style="width: 9%">Sort</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $i=1; @endphp
                                                @foreach($result as $key => $data)
                                                <tr>
                                                    <td>{{ $i + $key }}</td>
                                                    <td>{{$data->title}}</td>
                                                    <td>
                                                        @foreach($site as $sites)
                                                            @if($sites->id == $data->site_id)
                                                                {{$sites->site_name}}
                                                            @endif
                                                       @endforeach
                                                    </td>
                                                    <td>
                                                       @foreach($category as $cat)
                                                            @if($cat->id == $data->category_id)
                                                                {{$cat->name}}
                                                            @endif
                                                       @endforeach
                                                    </td>
                                                    <td>{{date('d-m-Y', strtotime($data->created_at))}}</td>
                                                    <td>
                                                        <label class="switch">
                                                            <input type="checkbox" class="blockstatus" name="stat" id="stat" data-id="{{ base64_encode($data->id) }}" @if($data->is_block == 'N') checked @endif>
                                                            <span class="slider roundsemi"></span>
                                                        </label>
                                                        <label id="status-info-{{ $data->id }}" class="status-stat"></label>
                                                    </td>
                                                    <td>
                                                        <a href="{{ route('admin.homefeaturemanagement.edit', base64_encode($data->id).'?redirect='.urlencode($request->fullUrl())) }}">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                    </td>
                                                    <td><button data-toggle="modal" data-target="#homefeatureproduct" data-homeid="{{$data->category_id}}" data-siteid="{{$data->site_id}}" class="btn btn-primary home">Sort</button></td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <div class="card">No Data Found...</div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif    
        
    </main><!-- End #main -->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script> -->
    <!-- <script src="{{ asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js') }}"></script> -->
    <!-- <script src="{{ asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js') }}"></script> -->
    <!-- <script src="{{ asset('admin/assets/extra-libs/DataTables/datatables.min.js') }}"></script> -->
    <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>

    <!-- <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/extra-libs/multicheck/multicheck.css') }}"> -->
    <!-- <link href="{{ asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet"> -->

    <script>

        /****************************************
         *       Basic Table                   *
         ****************************************/
        // $('#zero_config').DataTable({
        //     "order": [[5, "desc"]] 
        // });

        document.addEventListener("DOMContentLoaded", function () {
            const table = document.querySelector("#zero_config");
            const dataTable = new simpleDatatables.DataTable(table, {
                sortable: true,
                fixedHeight: true,
                columns: [
                    { select: 5, sort: "desc" } // Sort by the 6th column (index 5) descending
                ]
            });
        });
        
        $(function(){
            setTimeout(function(){ $('.alert').hide(); }, 3000);
            var status, id;
            $('.blockstatus').change(function(){
                if(this.checked){
                    status = 'Y';
                }else{
                    status = 'N'
                }
                id = $(this).attr('data-id');
                var ajaxurl = "{{route('admin.homefeaturemanagement.status')}}";     
                //alert(ajaxurl);
                $.ajax({
                    type : 'POST',
                    url : ajaxurl,
                    data : { 'id' : id, 'status' : status },
                    headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success : function(response){
                        response = JSON.parse(response);
                        //alert('status-info-'+id);
                        if(response.status == 1){
                            $('#status-info-'+response.id).html(response.event).fadeIn(100).delay(1000).fadeOut();;
                        }
                    },
                    error : function(){
                        $('.selected_records_data').html('<span class="error-msg text-danger">There was an unexpected error!! Please try again later.</span>');
                    }
                });
            });
        })

       
        //ajax call thats occcur to show multiple product list in the modal

        $(document).ready(function(){
            $('.home').click(function (e){
                e.preventDefault();
                var home_id = $(this).attr('data-homeid');
                var site_id = $(this).attr('data-siteid');
                
                $.ajax({
                    type : 'POST',
                    url : "{{ route('admin.homefeaturemanagement.dragproduct') }}",
                    data : {
                        'category_id' : home_id,
                        'site_id' : site_id
                     },
                    headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success : function(response){
                        $('#sortable').html(response);
                        $('#homefeatureproduct').modal('show');
                    }
                });
            });
        });

        //sortable method called and ajax is called for update the sort field in tha database
       
        $( "#sortable" ).sortable({
            stop: function(event, ui) {
                var $data = $.map($(this).find('li'), function(e) {
                    return {id : $(e).data('id'), position : $(e).index(), catid : $(e).data('catid'), siteid : $(e).data('siteid')};
                });
                console.log($data);
                
                $.ajax({
                    type : 'POST',
                    url : "{{ route('admin.homefeaturemanagement.sorthomepageproduct') }}",
                    data : { data : JSON.stringify($data) },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success : function(response){
                        response = JSON.parse(response);
                        if(response.status == 'success'){
                            alert(response.msg);
                        }
                        
                    },
                    error : function(){

                    }
                });
                
                
            }
        });

        $(function () {
			$(".btn-default, .close").click(function () {
				$("#homefeatureproduct").modal("hide");
			});
		});

    </script>

@endsection

<!-- Modal -->
<div class="modal fade" id="homefeatureproduct" role="dialog">
    <div class="modal-dialog">
    <script>
    </script>
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <!-- <h4 class="modal-title">Modal Header</h4> -->
        </div>

        <div class="modal-body">
            <ul id="sortable">
                
            </ul>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
      
    </div>

</div>
