@extends('layouts.admin.app')

@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>

<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'M' )
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Occasion</h4>
                    <div class="ml-auto text-right">
                        <a href="{{ route('admin.occasion_list') }}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <!-- ============================================================== -->
            <!-- Start Page Content -->
            <!-- ============================================================== -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                            @if(Session::has('alert-' . $msg))
                                <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
                            @endif
                        @endforeach
                        <form action="{{route('admin.occasion_list_add')}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <h4 class="card-title">Occasion Add</h4>

                                <div class="form-group m-t-20">
                                    <label>Occasion Name<span>*</span></label>
                                    <input type="text" class="form-control" id="occ_name" name="occ_name" placeholder="Enter Occasion Name" required>
                                </div>
                                <div class="form-group m-t-20">
                                    <label>Occasion Date<span>*</span></label>
                                    <input type="text" class="form-control" id="occ_date" name="occ_date" placeholder="Enter Occasion Date" required>
                                </div>

                                <div class="form-group m-t-20">
                                    <label>Occasion Link</label>
                                    <input type="text" class="form-control" id="occ_link" name="occ_link" placeholder="Enter Occasion Link" >
                                </div>
                                
                                <div class="col-md-6">
                                    <label>Occasion Heading Status : </label><br>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="occ_heading_status" value="Y">
                                        <label class="form-check-label" for="">Yes</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="occ_heading_status" value="N" required>
                                        <label class="form-check-label" for="">No </label>
                                    </div>
                                </div>
                            </div>
                            <div class="border-top">
                                <div class="card-body">
                                    <input class="btn btn-primary" type="submit" value="CREATE">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif 
</main>   

<script type="text/javascript">
    
    $.validator.setDefaults({
            submitHandler: function(form) {
                form.submit();
            }
    });
  
</script>    

@endsection
