@extends('layouts.admin.app')
@section('content')

    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script> --}}

    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">

    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>


    <main id="main" class="main">

        @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA' || Session::get('permissions.user_type') == 'E' || Session::get('permissions.user_type') == 'OP' || Session::get('permissions.user_type') == 'M')

            <div class="container-fluid">

                <!-- ============================================================== -->

                <!-- Start Page Content -->

                <!-- ============================================================== -->

                <div class="row">

                    <div class="col-12">

                        <div class="card">

                            @foreach (['danger', 'warning', 'success', 'info'] as $msg)

                                @if(Session::has('alert-' . $msg))

                                    <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>

                                @endif

                            @endforeach

                            <form action="{{url('admin/product/product-edit/')}}/{{ encrypt($productdetails->id)}}" method="POST" class="form-horizontal" id="formadd" enctype="multipart/form-data">

                                @csrf

                                <div class="card-body">

                                    <h4 class="card-title" style="display: inline-block;padding: 0 10px 0 0;">Edit Product</h4>

                                    <div class="row g-3">

                                        <input type="hidden" name="formid" value="<?php echo $productdetails->id; ?>">

                                        <div class="col-md-4">
                                            <label>FNID</label><span>*</span>
                                            <input type="text" class="form-control" id="fnid" name="fnid" placeholder="Enter FIND" value="{{$productdetails->fnid}}" required>
                                        </div>

                                        <div class="col-md-4">
                                            <label>SKU</label>
                                            <input type="text" class="form-control" id="sku" name="sku" placeholder="Enter SKU" value="{{$productdetails->sku}}">
                                        </div>

                                        <div class="col-md-4">
                                            <label>OLD ID</label><span>*</span>
                                            <input type="text" class="form-control" id="old_id" name="old_id" placeholder="Enter OLD ID" value="{{$productdetails->old_id}}" readonly>
                                        </div>
                                    
                                        <div class="form-group m-t-20">

                                            <label>Category<span style="color:red;">*</span></label>

                                            <select class="form-control selectpicker2" name="categories_id[]" multiple="multiple" data-live-search="true" data-live-search-placeholder="Search" data-actions-box="true" id="cat_id" >

                                            </select>

                                        </div>

                                        <div class="form-group m-t-20">

                                            <label>Product Title</label><span>*</span>

                                            <input type="text" class="form-control" id="product_title" name="product_title" placeholder="Enter Product Title" value="{{$productdetails->product_name}}" required>

                                        </div>

                                        <div class="form-group m-t-20">

                                            <label>Product Description</label><span>*</span>

                                            <textarea class="form-control" rows="5" id="product_description" name="product_description"  placeholder="Enter Product Description" required>{{$productdetails->description}}</textarea>

                                        </div>

                                        <div class="form-group m-t-20">

                                            <label>Content</label>

                                            <textarea class="form-control" rows="5" id="content" name="content" placeholder="Enter Content">{{$productdetails->content}}</textarea>

                                        </div>

                                        <div class="form-group m-t-20">

                                            <label>Shipping</label>

                                            <textarea class="form-control" rows="5" id="shipping" name="shipping" placeholder="Enter Shipping">{{$productdetails->delivery_info}}</textarea>

                                        </div>

                                        <div class="form-group m-t-20">

                                            <label>Has Attribute?</label><br>

                                            <span><input type="radio" name="has_attribute" class="pattribute" value="Y" @if($productdetails->has_attribute=="Y") checked @endif>Yes</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                                            <span><input type="radio" name="has_attribute" class="pattribute" value="N" @if($productdetails->has_attribute=="N") checked @endif>No</span>

                                        </div>

                                        

                                        <input type="hidden" name="attribute_title" id="attribute_title" value="{{$productdetails->has_attribute}}">



                                        <div class="form-group m-t-20 has_attribute_show" id="formfield" style="display:none">

                                            <label>Create Attribute</label><span>*</span>

                                                @php 

                                                    $index = 0; 

                                                @endphp

                                                @if(count($attributedetails)>0)

                                                    @foreach($attributedetails as $attributedetails)

                                                        <div class="row g-3">

                                                            {{--<input type="text" name="attr_title[{{$index}}]" id="attr_title{{$index}}" placeholder="Enter Attribute Title" value="{{$attributedetails->title}}">&nbsp;&nbsp;&nbsp;

                                                            <input type="text" name="attr_desc[{{$index}}]" id="attr_desc{{$index}}" placeholder="Enter Attribute Description" value="{{$attributedetails->description}}">

                                                            <input type="text" name="attr_cont[{{$index}}]" id="attr_cont{{$index}}" placeholder="Enter Attribute Content" value="{{$attributedetails->content}}">--}}

                                                            <div class="col-md-6">
                                                                <input type="hidden" name="attr_id[]" id="attr_id{{$index}}" value="{{$attributedetails->id}}">
                                                                
                                                                <textarea class="form-control" rows="1" id="attr_cont{{$index}}" name="attr_cont[{{$index}}]"  placeholder="Enter Attribute Content" >{{$attributedetails->content}}</textarea>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <input type="number" min=0 name="attr_price[{{$index}}]" id="attr_price{{$index}}" placeholder="Enter Price" class="form-control" value="{{$attributedetails->price}}">
                                                            </div>
                                                            <div class="col-md-2">
                                                                <input type="number" min=0 name="attr_actual_price[{{$index}}]" id="attr_actual_price{{$index}}" placeholder="Enter MRP" class="form-control" value="{{$attributedetails->actual_price}}">
                                                            </div>
                                                            {{--<div class="col-md-1">
                                                                <span class="col-sm-2"><a class="deleteRow delete1" id="attr_delete{{$attributedetails->id}}" data-aid="{{$attributedetails->id}}" href="javascript: void(0);"><i class="fas fa-trash-alt ibtnDel"></i></a></span>
                                                            </div>--}}

                                                            <div class="col-md-1">
                                                                <label class="switch">
                                                                    <input type="checkbox" class="blockstatus" name="stat" id="attr_delete{{$attributedetails->id}}" data-id="{{ base64_encode($attributedetails->id) }}" @if($attributedetails->is_block == 'N') checked @endif>
                                                                    <span class="slider roundsemi"></span>
                                                                </label>
                                                                <label id="status-info-{{ $attributedetails->id }}" class="status-stat"></label>
                                                            </div>

                                                            @php

                                                                $index++;

                                                            @endphp

                                                        </div><br>

                                                    @endforeach

                                                @else

                                                    <div>

                                                        {{--<input type="text" name="attr_title[{{$index}}]" id="attr_title{{$index}}" placeholder="Enter Attribute Title">&nbsp;&nbsp;&nbsp;

                                                        <input type="text" name="attr_desc[{{$index}}]" id="attr_desc{{$index}}" placeholder="Enter Attribute Description">
                                                        <input type="text" name="attr_cont[{{$index}}]" id="attr_cont{{$index}}" placeholder="Enter Attribute Content">--}}
                                                        <textarea class="form-control" rows="4" id="attr_cont{{$index}}" name="attr_cont[{{$index}}]" placeholder="Enter Attribute Content"></textarea><br>
                                                        <input type="number" min=0 name="attr_price[{{$index}}]" id="attr_price{{$index}}" placeholder="Enter Price">

                                                        <input type="number" min=0 name="attr_actual_price[{{$index}}]" id="attr_actual_price{{$index}}" placeholder="Enter MRP">

                                                        @php

                                                            $index++;

                                                        @endphp

                                                    </div><br>

                                                @endif

                                                <div class="addField"></div><br>

                                                <input type="button" class="btn btn-info" id="addrow" value="Add More Attribute" />

                                        </div>

                                        

                                        <div class="col-md-6 no_attribute_show">
                                            <label>Product Price</label><span>*</span>
                                            <input type="text" class="form-control" id="product_price" name="product_price" placeholder="Enter Product Price" value="{{$productdetails->price}}">
                                        </div>

                                        <div class="col-md-6 actual_price">
                                            <label>MRP</label>
                                            <input type="number" class="form-control" id="product_actual_price" name="product_actual_price" min=0 @if(!$productdetails->actual_price) value="0" @else value="{{$productdetails->actual_price}}" @endif>
                                            <span>Note: You can leave it blank if product price and actual price is same</span>
                                        </div>

                                        <div class="col-md-6">
                                            <label>Delivery Type : </label><br>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="delivery_type" value="H" {{ $productdetails->delivery_type == 'H' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="">Hand Delivery</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="delivery_type" value="C" {{ $productdetails->delivery_type == 'C' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="">Courier </label>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <label>Delivery Delay Days</label><span>*</span>
                                            <input type="text" class="form-control" id="delivery_delay_days" name="delivery_delay_days" placeholder="0" value="{{$productdetails->delivery_delay_days}}" required>
                                        </div>

                                        <div class="form-group m-t-20">

                                            <label>Alt Keyword</label><span>*</span>

                                            <input type="text" class="form-control" id="alt_keyword" name="alt_keyword" placeholder="Enter Alt Keyword" value="{{$productdetails->alt_key}}" required>

                                        </div>

                                        <div class="form-group m-t-20">

                                            <label>Meta Title</label><span>*</span>

                                            <input type="text" class="form-control" id="meta_title" name="meta_title" placeholder="Enter Meta Title" value="{{$productdetails->meta_title}}" required>

                                        </div>

                                        <div class="form-group m-t-20">

                                            <label>Meta Description</label><span>*</span>

                                            <textarea class="form-control" rows="5" id="meta_description" name="meta_description" placeholder="Enter Meta Description" required>{{$productdetails->meta_description}}</textarea>

                                        </div>

                                        {{--<div class="col-md-4">
                                            <label>Specification</label>
                                            <input type="text" class="form-control" id="specification" name="specification" placeholder="Enter Specification" value="{{$productdetails->specification}}">
                                        </div>

                                        <div class="col-md-4">
                                            <label>Product Segregation</label>
                                            <input type="text" class="form-control" id="segregation" name="segregation" placeholder="Enter Product Segregation" value="{{$productdetails->segregation}}">
                                        </div>--}}

                                        <div class="col-md-4">
                                            <label>Specification<span>*</span></label>
                                            <select id="specification" name="specification" type="text" class="form-control"
                                                aria-required="true" aria-invalid="false" >
                                                <option value="">Select Specification</option>
                                                @foreach ($specifications as $list)
                                                    @if ($productdetails->specification == $list->specification_name)
                                                    <option selected value="{{ $list->specification_name }}">
                                                    @else
                                                        <option value="{{ $list->specification_name }}">
                                                    @endif
                                                    {{ $list->specification_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-4">
                                            <label>Product Segregation<span>*</span></label>
                                            <select id="segregation" name="segregation" type="text" class="form-control"
                                                aria-required="true" aria-invalid="false" >
                                                <option value="">Select Segregation</option>
                                                @foreach ($segregations as $list)
                                                    @if ($productdetails->segregation == $list->segregation_name)
                                                    <option selected value="{{ $list->segregation_name }}">
                                                    @else
                                                        <option value="{{ $list->segregation_name }}">
                                                    @endif
                                                    {{ $list->segregation_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-4">
                                            <label>Vendor Name<span>*</span></label>
                                            <select id="vendor_id" name="vendor_name" type="text" class="form-control"
                                                aria-required="true" aria-invalid="false" >
                                                <option value="">Select Vendor Name</option>
                                                @foreach ($vendor_details as $list)
                                                    @if ($productdetails->vendor_name == $list->vendor_code)
                                                    <option selected value="{{ $list->vendor_code }}">
                                                    @else
                                                        <option value="{{ $list->vendor_code }}">
                                                    @endif
                                                    {{ $list->vendor_name }}-({{ $list->vendor_code }})</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        @if($productPersonalize)
                                            <div class="col-md-6">
                                                <label>Personalize Product(No of Images)</label>
                                                <input type="text" class="form-control" id="personalize_images" name="personalize_images" value="{{$productPersonalize->no_of_image}}" placeholder="Enter Personalize Product(No of Images)">
                                            </div>
                                         
                                            <div class="col-md-6">
                                                <label>Personalize Text Message : </label><br>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="personalize_text" value="Y" {{ $productPersonalize->text_msg == 'Y' ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="">Yes</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="personalize_text" value="N" {{ $productPersonalize->text_msg == 'N' ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="">No</label>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="form-group m-t-20">

                                            <label>Search Tag</label>

                                            <input type="text" class="form-control" id="search_tag" name="search_tag" placeholder="Enter Search Tag" @if($productdetails->search_tag) value="{{$productdetails->search_tag}}"@endif>

                                        </div>

                                        <div class="form-group m-t-20">
                                            <label>Extra Field</label>
                                            <input type="text" class="form-control" id="extra_field" name="extra_field" placeholder="Enter Extra Value" value="{{$productdetails->extra_field}}">
                                        </div>

                                    </div>   

                                </div>

                                <div class="border-top">

                                    <div class="card-body">

                                        <input class="btn btn-primary" type="submit" value="Update">

                                    </div>

                                </div>

                                

                            </form>

                        </div>

                    </div>

                </div>

            </div>

        @endif        

    </main><!-- End #main -->



    <script type="text/javascript">

        

        $(document).ready(function () {
            setTimeout(function () {
                $('.cke_notifications_area').attr("style", "display: none !important");
            }, 2000); // 60000ms = 1 minute
        });

        $(document).ready(function(){

            $('.selectpicker2').selectpicker();



            $.validator.setDefaults({

                    submitHandler: function(form) {

                        form.submit();

                    }

            });

            $(function() {

                // validate the comment form when it is submitted

                $("#formadd").validate({

                    ignore: [],

                    errorPlacement: function(label, element) {

                        label.addClass('mt-2 text-danger');

                        label.insertAfter(element);

                    },

                    highlight: function(element, errorClass) {

                        $(element).parents('.form-group').addClass('has-danger')

                        $(element).addClass('form-control-danger')

                    }

                  });

            });



            CKEDITOR.replace("product_description");

            CKEDITOR.replace("content");

            CKEDITOR.replace("shipping");





            $('#title').on('blur', function(){

                var title = $.trim($(this).val());

                if(title != ''){

                    //if($.trim($('#slug').val()) == ''){

                        $('#slug').val(title.replace(/ /g,"-").toLowerCase());

                        $('#slug-error').hide();

                    //}

                }

            });

               

            $('.pattribute').click(function(){

                if(this.value == 'Y'){

                    $('.has_attribute_show').slideDown();

                    $('.no_attribute_show').slideUp();

                    $('.actual_price').slideUp();

                    $('.product_actual_price').hide();

                    $("input[id*=attr_price]").attr("required",true);

                    $("input[id*=attr_cont]").attr("required",true);

                    $("input[id*=product_price]").attr("required",false);

                }else{

                    $("input[id*=product_price]").attr("required",true);

                    $("input[id*=attr_price]").attr("required",false);

                    $("input[id*=attr_cont]").attr("required",false);

                    $('.has_attribute_show').slideUp();

                    $('.no_attribute_show').slideDown();

                    $('.product_actual_price').show();

                    $('.actual_price').slideDown();



                }

            });

            

            if($('#attribute_title').val()=="Y"){

                    $('.has_attribute_show').slideDown();

                    $('.no_attribute_show').slideUp();

                    $('.actual_price').slideUp();

                    $("input[id*=attr_price]").attr("required",true);

                    // $("input[id*=attr_title]").attr("required",false);

                    // $("input[id*=attr_desc]").attr("required",false);
                    $("input[id*=attr_cont]").attr("required",false);

                    $("input[id*=product_price]").attr("required",false);

                }else{

                    $("input[id*=product_price]").attr("required",true);

                    $("input[id*=attr_price]").attr("required",false);

                    $("input[id*=attr_cont]").attr("required",false);

                    $('.has_attribute_show').slideUp();

                    $('.no_attribute_show').slideDown();

                    $('.actual_price').slideDown();



                }



          

            $(function(){

                $('select').selectpicker();

            })

        });



        $(document).ready(function(){

            var counter = {{$index-1}};

            $("#addrow").on("click", function () {



                if(counter < 9){

                    counter++;

                    var cols = '';

                    var newRow = $('<div class="row" style="margin-top: 5px;">');



                    
                    
                    cols += '<div class="col-sm-6"><input class="form-control" name="attr_id[]" type="hidden" ><textarea required class="form-control" rows="1" placeholder="Enter Attribute Content" id="attr_cont'+counter+'" name="attr_cont['+counter+']" type="text"></textarea></div><br>';

                    cols += '<div class="col-sm-2"><input required class="form-control" placeholder="Enter Price" id="attr_price'+counter+'" name="attr_price['+counter+']" type="number" min=0></div>';

                    cols += '<div class="col-sm-2"><input required class="form-control" placeholder="Enter MRP" id="attr_actual_price'+counter+'" name="attr_actual_price['+counter+']" type="number" min=0></div>';

                    cols += '<div class="col-sm-2"><a class="deleteRow" href="javascript: void(0);"><i class="fas fa-trash-alt ibtnDel"></i></a></div>';



                    newRow.append(cols);

                    $(".addField").append(newRow);

                }else{

                    alert("You can't add more than 8 attributes.");

                }



            });



            $(".row").on("click", ".ibtnDel", function (event) {

                $(this).closest(".row").remove();

                counter--;

            });

            

        });



        

         

        $(document).ready(function(){

            @php 

                $category_selected = implode(',',$category_selected);

            @endphp



            $.ajaxSetup({

                  headers: {

                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

                  }

              });

            $.ajax({

              type : "POST",

              url : "{{route('admin.product.getcategory')}}",

              data : { id : 99 },

              success : function(response){

                console.log(response)

                response = JSON.parse(response);

                if(response.status == "success"){

                  $('#cat_id').html(response.data);

                  $('#cat_id').selectpicker('val', [<?php echo $category_selected; ?>]);



                  

                  $('.selectpicker2').selectpicker('refresh');

                }

              },

              error : function(){



              }

            });

        });

        // $(function(){
        //     $(document).on("click", ".delete1", function () {
        //         var id = $(this).attr("data-aid"); 
        //         // alert(id);
        //         var deleteUrl = "{{ url('/admin/product/product_attr_delete') }}";
        //         if (confirm("Are you sure delete this product attribute?")) {
        //             $.ajax({
        //                 type: 'GET',
        //                 url: deleteUrl + '/' + id,
                        
        //                 success: function(result){
        //                     if (result.success) {
        //                         alert(result.message);
        //                         location.reload();
        //                     } else {
        //                         alert('Error: ' + response.message);
        //                     }
        //                 },
        //                 error: function(error){
        //                     console.log(error.status);
        //                     // console.log(errorThrown);
        //                 }
        //             });
        //         }else{
        //             location.reload();
        //         }
        //     });
        // });

        $(function(){
            setTimeout(function(){ $('.alert').hide(); }, 3000);
            var status, id;
            $('.blockstatus').on('change', function() {
                if(this.checked){
                    status = 'Y';
                }else{
                    status = 'N'
                }
                id = $(this).attr('data-id');
                var ajaxurl = "{{ route('admin.product.attribute_status') }}";  
                $.ajax({
                    type : 'POST',
                    url : ajaxurl,
                    data : { 'id' : id, 'status' : status },
                    headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success : function(response){
                        response = JSON.parse(response);
                        if(response.status == 1){
                            $('#status-info-'+response.id).html(response.event).fadeIn(100).delay(1000).fadeOut();
                        }
                    },
                    error : function(){
                        $('.selected_records_data').html('<span class="error-msg text-danger">There was an unexpected error!! Please try again later.</span>');
                    }
                });
            });
        })

</script> 



@endsection