<?php $__env->startSection('content'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    <?php if($agent): ?>
          
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <div class="card-body">

                            

                            <div class="row mb-3">
                              <label class="col-sm-2 col-form-label"><b>Choose Agent</b></label>
                              <div class="col-sm-10">
                                <select id="agent_id" name="agent_id" type="text" class="form-control"
                                    aria-required="true" aria-invalid="false" required>
                                    <option value="">Select Agent</option>
                                    <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($agent_id == $list->id): ?>
                                            <option selected value="<?php echo e(encrypt($list->id)); ?>">
                                        <?php else: ?>
                                            <option value="<?php echo e(encrypt($list->id)); ?>">
                                        <?php endif; ?>        
                                            <?php echo e($list->name); ?></option>    
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                              </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Agent :: <?php echo e(ucwords($agent->name)); ?></h4>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(Session::has('alert-' . $msg)): ?>
                                    <div class="alert alert-<?php echo e($msg); ?> alert-dismissible fade show" role="alert">
                                        <?php echo e(Session::get('alert-' . $msg)); ?>

                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                            <div class="col-12 d-flex no-block align-items-center justify-content-between mb-2">
                                <h5>Agent Delivery Charges</h5>
                            </div>
                            
                            <?php if(count($agent_delivery_charge)>0): ?>
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Standard Delivery Charge</th>
                                                <th>Midnight Delivery Charge</th>
                                                <th>Express Delivery Charge</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $agent_delivery_charge; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>Rs. <?php echo e($data->s_delivery); ?></td>
                                                <td>Rs. <?php echo e($data->m_delivery); ?></td>
                                                <td>Rs. <?php echo e($data->e_delivery); ?></td>
                                                <td>
                                                    <a href ="<?php echo e(url('admin/agent/delivery-charge-edit')); ?>/<?php echo e(encrypt($data->id)); ?>"><i class="fas fa-edit"></i></a>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="card p-3">No Agent's Delivery Charges Found...</div>
                            <?php endif; ?>

                            
                            <div class="col-12 d-flex no-block align-items-center justify-content-between mb-2">
                                <h5 class="page-title">
                                    Agent Product List
                                </h5>
                                <div class="ml-auto text-right">
                                    <button id="btn_exportExcel" class="btn btn-primary">Import in Excel</button>
                                    <a href="<?php echo e(url('/admin/agent/agent-product-add')); ?>/<?php echo e(encrypt($agent_id)); ?>" class="btn btn-success">Add Product</a>
                                </div>
                            </div>
                            <?php if(count($result) > 0): ?>
                                <div class="table-responsive">
                                    <table id="zero_config" class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>No.</th>
                                                <th>fnid</th>
                                                <th>item</th>
                                                <th>Price</th>
                                                <th>Personalized</th>
                                                <th>Created Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($index + 1); ?></td>
                                                <td><?php echo e($data->fnid); ?></td>
                                                <td><?php echo e($data->item); ?></td>
                                                <td><?php echo e($data->price); ?></td>
                                                <td><?php echo e($data->is_personalized); ?></td>
                                                <td><?php echo e(date('d-m-Y', strtotime($data->created_at))); ?></td>
                                                <td>
                                                    <a href="<?php echo e(url('admin/agent/agent-product-edit')); ?>/<?php echo e(encrypt($data->id)); ?>"><i class="fas fa-edit"></i></a>
                                                    <a onclick="return confirm('Are you sure you want to delete the Product?')" href="<?php echo e(route('admin.agent.agentProductDelete', base64_encode($data->id))); ?>"><i class="fas fa-trash-alt"></i>    
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="card p-3">No Data Found...</div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        No Data Found...
    <?php endif; ?>    
            
</main><!-- End #main -->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <script>

        document.addEventListener("DOMContentLoaded", function () {
            const table = document.querySelector("#zero_config");
            const dataTable = new simpleDatatables.DataTable(table, {
                sortable: true,
                fixedHeight: true,
                columns: [
                    { select: 5, type: "date", sort: "desc" } // Sort by the 6th column (index 5) descending
                ]
            });
        });


        $(document).ready(function () {
            $('#agent_id').on('change', function () {
                var agentId = $(this).val();
                if (agentId) {
                    // Replace with your desired base URL
                    let url = "<?php echo e(url('/admin/agent/agent-product-list')); ?>/" + agentId;
                    window.location.href = url; // Redirect to the link
                } else {
                    alert("No agent found");
                }
            });

            $('#btn_exportExcel').click(function() {
                var agent_id = $('#agent_id').val(); 
                if (agent_id) {
                    // Replace with your desired base URL
                    let url = "<?php echo e(url('/admin/agent/agent-product-list/import-excel')); ?>/" + agent_id;
                    window.location.href = url; // Redirect to the link
                } else {
                    alert("No agent found");
                }
            });

        });

    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/agent/agent_product_list.blade.php ENDPATH**/ ?>