<?php $__env->startSection('content'); ?>

    

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('admin/assets/extra-libs/multicheck/multicheck.css')); ?>">
    <link href="<?php echo e(asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css')); ?>" rel="stylesheet">

    <main id="main" class="main">
        <?php if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA' || Session::get('permissions.user_type') == 'E' || Session::get('permissions.user_type') == 'OP' || Session::get('permissions.user_type') == 'M'): ?>
	        <div class="page-breadcrumb">
			    <div class="row">
			        <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                        <?php if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA' || Session::get('permissions.user_type') == 'M'): ?>
			        	<h4 class="page-title">
			                <a href="<?php echo e(route('admin.product.bulkproductedit')); ?>"><i class="fas fa-shekel-sign fawsm"></i></a>
			                Product
			            </h4>
			            <div class="ml-auto text-right">
                            <div id="export-status"></div>
                            <button id="start-export" class="btn btn-warning" ><i class="fas fa-file-excel"></i></button>
			            	
                            
                            
			                <a href="<?php echo e(route('admin.product.product-add')); ?>" class="btn btn-success">ADD Product</a>
			            </div>
                        <?php endif; ?>
			        </div>
			    </div>
			</div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(Session::has('alert-' . $msg)): ?>
                                        <h4 class="font-weight-light alert alert-<?php echo e($msg); ?>"><?php echo e(Session::get('alert-' . $msg)); ?></h4>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="product-search">
                                    <div class="prod-search-title">
                                        <h5 class="card-title">
                                            Product List
                                        </h5>
                                    </div>
                                    <div class="prod-search-body">
                                        <form action="<?php echo e(route('admin.product.list')); ?>" id="search-form" method="post">
                                            <?php echo csrf_field(); ?>
                                            <select class="form-control" id="category_ids" name="category_id">
                                                <option value="">Choose Category</option>
                                                <?php foreach ($category_data as $key => $category) { ?>
                                                    <option value="<?php echo $key; ?>" <?php if($request->category_id == $key){?> selected <?php } ?>><?php echo $category; ?></option>
                                                <?php } ?>
                                            </select>
                                            <input class="form-control" id="search-field" name="search" value="<?php echo e($search); ?>" placeholder="Search By ID / FNID / Product Title / SKU"/>
                                            <button class="btn btn-primary" type="submit" ><i class="fa fa-search"></i></button>
                                        </form>                     
                                    </div>
                                </div>
                                <div class="table-responsive" style="font-size: 13px;">
                                    <table id="zero_config" class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 3%"><b>No.</b></th>
                                                <th style="width: 8%"><b>Image</b></th>
                                                <th style="width: 25%"><b>Title</b></th>
                                                <th style="width: 8%"><b><?php echo CustomPaginator::sort('id', 'ID/SKU', ['direction' => true]); ?></b></th>
                                                <th style="width: 38%"><b>Category</b></th>
                                                <th style="width: 9%"><b>Price</b></th>
                                                <th style="width: 9%"><b><?php echo CustomPaginator::sort('is_block', 'Status', ['direction' => true]); ?></b></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i = ($result->currentPage() - 1) * $result->perPage() + 1; ?>
                                            <?php if($result->count() == 0): ?>
                                                <tr>
                                                    <td colspan="10">No records found!</td>
                                                </tr>
                                            <?php endif; ?>
                                            <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $products): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($i + $key); ?></td>
                                                    <td>
                                                        <?php 
                                                            $imagename = App\Http\Helper1::get_image($products->id);
                                                        ?>

                                                        <?php if(isset($imagename) && $imagename->name != null ): ?>
                                                            <img src="https://www.chennaionlineflorists.com/uploaded/product/<?php echo e($imagename->name); ?>" style="width:90px; height: auto;"  >
                                                            
                                                        <?php else: ?>
                                                            <img src="https://www.chennaionlineflorists.com//uploaded/no_image.jpg" style="width:90px; height: auto;"  >
                                                        <?php endif; ?>
                                                        <span style="color:#485256; font-size:9px; font-weight: 600"><?php echo e($products->old_id); ?></span>
                                                    </td>
                                                    <td>
                                                        <?php echo e($products->product_name); ?>

                                                        <hr>
                                                        <b>Delay Days : </b><?php echo e($products->delivery_delay_days); ?> days
                                                        <br>
                                                            <b>Delivery Type : </b>
                                                            <?php if($products->delivery_type == 'C'): ?>
                                                                Courier
                                                            <?php else: ?>
                                                                Hand Delivery
                                                            <?php endif; ?>
                                                        <br>
                                                            <b>Product Type : </b> <?php echo e($products->specification); ?> ( <?php echo e(ucwords($products->segregation)); ?> )

                                                            <?php 
                                                                //echo $products->vendor_name;
                                                                $vendorDtl = App\Http\Helper1::get_vendorDtl($products->vendor_name);
                                                                //dd($vendorDtl);
                                                            ?>
                                                            <?php if(!empty($products->vendor_name)): ?>
                                                            <?php if($vendorDtl->vendor_name != 'Normal'): ?>
                                                            <br>
                                                                <b>Vendor Type : </b> <?php echo e($vendorDtl->vendor_name); ?>

                                                            <?php endif; ?>   
                                                            <?php endif; ?>  

                                                    </td>
                                                    <td>
                                                        <?php echo e($products->id); ?> / <span style="color:#2962ff; font-weight: 600"> <?php echo e($products->fnid); ?></span>
                                                        <?php if(!empty($products->sku)): ?>
                                                            <span class="badge bg-secondary"><?php echo e($products->sku); ?></span>
                                                        <?php endif; ?>
                                                        <?php
                                                            $reviewDtl = App\Http\Helper1::get_reviewDtlsbyProduct($products->id);
                                                        
                                                            if(count($reviewDtl) > 0){
                                                                $ratingSum = $avgRating = 0;
                                                                foreach($reviewDtl as $review){
                                                                    $ratingSum = $ratingSum + $review->rating;
                                                                }
                                                                $avgRating = round($ratingSum/count($reviewDtl), 1);
                                                                ?>
                                                                <hr>
                                                                <?php echo e($avgRating); ?> <i class="fas fa-star"></i> <br> <?php echo e(count($reviewDtl)); ?> Reviews
                                                        <?php
                                                            }
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <?php
                                                            $getCategories = App\Http\Helper1::product_relatated_category_list($products->id);
                                                        ?>
                                                        <div>
                                                            <p class="categories-texts">
                                                            <?php $__currentLoopData = $getCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php echo $cat . ' | '; ?>

                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </p>
                                                            <div class="more">More</div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <?php if($products->has_attribute == "Y"): ?>
                                                            <?php if(count($products->product_attribute) > 0): ?>
                                                                <?php $__currentLoopData = $products->product_attribute; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    
                                                                    <b>&#8377; <?php echo e($attribute->price); ?></b> 

                                                                    <?php if($attribute->actual_price > 0): ?>
                                                                        <span style="text-decoration:line-through;"> <?php echo e($attribute->actual_price); ?></span>
                                                                    <?php endif; ?>  

                                                                    <br> 
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>

                                                        <?php else: ?>
                                                            <b>&#8377; <?php echo e($products->price); ?></b>
                                                            <?php if($products->actual_price > 0): ?>
                                                                <span style="text-decoration:line-through;"> <?php echo e($products->actual_price); ?></span>
                                                            <?php endif; ?>

                                                        <?php endif; ?>
                                                        
                                                    </td>
                                                    <td>
                                                        <span class="created-dt"><?php echo e(date('jS M y', strtotime($products->created_at))); ?></span>
                                                        <br>
                                                        <a href="<?php echo e(url('admin/product/status/')); ?>/<?php echo e(encrypt($products->id)); ?>">
                                                            <i class="fas fa-info-circle" style="font-size:18px"></i>
                                                        </a>
                                                        &nbsp;
                                                        <a href="<?php echo e(url('admin/product/product-edit/')); ?>/<?php echo e(encrypt($products->id)); ?>">
                                                            <i class="fas fa-edit" style="font-size:18px"></i>
                                                        </a>
                                                        <hr style="margin: 0.3em;">
                                                        <?php
                                                            $getProductStatus = App\Http\Helper1::get_productStatus($products->id);
                                                        ?>
                                                        <?php echo $getProductStatus; ?>

                                                        
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div style="font-size: 15px; text-align: left; display: inline;">
                                    Showing <?php echo e($result->firstItem()); ?> to <?php echo e($result->lastItem()); ?> of <?php echo e($result->total()); ?> entries
                                </div>
                                <div class="text-center-pagination pagination" style="float:right;">
                                    <?php echo $result->withQueryString()->links('pagination::bootstrap-4'); ?>

                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>    
        
    </main><!-- End #main -->

    <style type="text/css">
        .product-search{display: flex;justify-content: space-between; align-items: center; margin-bottom: 20px;}
        .prod-search-title{width: 30%;}
        .prod-search-body{width: 80%;}
        .prod-search-body form{display: flex;justify-content: end;gap: 3px;}
        .prod-search-body form select, .prod-search-body form input{width: 32%;}
        .fawsm{color: #3e5569;}
        .created-dt{font-size: 12px; font-weight: 700; color: #838383;}
        .switch{margin-top: 7px}
        .status-stat{display: inline;}
        .categories-texts{margin-bottom:0 !important}
        .more{padding:5px;text-align: right;color: blue;font-size: 12px;text-transform: lowercase;cursor: pointer}
        .show{height:auto !important;overflow:auto!important;}
        .lessheight{height:120px;overflow:hidden}
    </style>
            
    
    <script>
        /****************************************
         *       Basic Table                   *
         ****************************************/
        // $('#zero_config').DataTable({
        //     "order": [[7, "desc"]] 
        // });
        $(document).ready(function(){
            $(function() {
                $('form').each(function() {
                    $(this).find('input').keypress(function(e) {
                        // Enter pressed?
                        if(e.which == 10 || e.which == 13) {
                            this.form.submit();
                        }
                    });

                    $(this).find('input[type=submit]').hide();
                });
            });




            let currentPage = 1;
            let totalPages = 1;

            $('#start-export').on('click', function () {
                $('#export-status').text('Exporting... Please wait...');

                // Start with page 1 to get totalPages
                $.get('<?php echo e(url("/admin/product/export-chunk")); ?>', { page: 1 }, function (data) {
                    if (data.success) {
                        totalPages = data.total_pages;
                        currentPage = 2; // already did page 1
                        processNextChunk();
                    } else {
                        $('#export-status').text('Failed to start export.');
                    }
                });
            });

            function processNextChunk() {
                if (currentPage > totalPages) {
                    $('#export-status').text('Merging files and preparing download...');
                    window.location.href = '<?php echo e(url("/admin/product/download-final-excel")); ?>';
                    return;
                }

                $.get('<?php echo e(url("/admin/product/export-chunk")); ?>', { page: currentPage }, function (data) {
                    if (data.success) {
                        $('#export-status').text(`Processed page ${currentPage} of ${totalPages}`);
                        currentPage++;
                        processNextChunk();
                    } else {
                        $('#export-status').text(`Error on page ${currentPage}`);
                    }
                });
            }
        });

        
        // $(document).ready(function(){
        //     $(".more").click(function(){
        //       $('.parent-text').toggleClass('show')
        //     });
        // });
        $(document).ready(function(){
            $('.categories-texts').each(function() {
                if ($(this).height() > 120) {
                    $(this).siblings().show()
                    $(this).addClass("lessheight")
                }
                else {
                    $(this).siblings().hide()
                }
            })
            $(".more").click(function(e){
                $(e.target).siblings().toggleClass("lessheight")
                $(this).text(function(i, text){
                    return text === "Less" ? "More" : "Less";
                })
            });
        });
        
    </script> 


<script>

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/product/list.blade.php ENDPATH**/ ?>