<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\CmsPages;
use App\Models\CmsPagesSitewise;
use Illuminate\Support\Facades\Auth;

class CmsController extends Controller

{

	public function list(Request $request)

	{



        $result=CmsPages::get();

        // dd($result);

        return view('admin.cms.list', ['result' => $result, 'request' => $request]);

	}

	public function add(Request $request){



        $obj = new CmsPages;



        if($request->isMethod('POST')){

           

            $request->validate([

                'title'=>'required',

                'content'=>'required',

                'meta_title'=>'required',

                'meta_description'=>'required'

            ]);



            if($cms = $obj->create([

                    'title' => $request->title, 

                    'content' => $request->content, 

                    'slug' => $request->slug,

                    'meta_title' => $request->meta_title, 

                    'meta_description' => $request->meta_description,

                    'created_by' => Auth::guard('AdminLogin')->user()->id

                ]))

            {

                $request->session()->flash('alert-success', 'CMS successfully added.');

                return redirect()->route('admin.cms.list');

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }

            

        }



        return view('admin.cms.add', ['request' => $request]);

    }

    public function edit($id = null, Request $request){



        $id = base64_decode($id);

		$dataDetails  = CmsPages::where('id',$id)->first();



        $obj = new CmsPages;



        if($request->isMethod('POST')){

            

            $request->validate([

                'title'=>'required',

                'content'=>'required',

                'meta_title'=>'required',

                'meta_description'=>'required'

            ]);

            

            $update_arr['title'] = $request->title;

            $update_arr['content'] = $request->content;

            $update_arr['slug'] = $request->slug;

            $update_arr['meta_title'] = $request->meta_title;

            $update_arr['meta_description'] = $request->meta_description;



            if(CmsPages::where(['id' => $request->formid])->update($update_arr)){

                   

                $request->session()->flash('alert-success', 'CMS successfully updated.');

                return redirect()->route('admin.cms.list');

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }

        }



        return view('admin.cms.edit', ['dataDetails' => $dataDetails, 'request' => $request]);

    }

    public function status(Request $request)

    {

        if($request->id == null || $request->status == null){

            return redirect()->route('admin.cms.list');

        }

        $id = base64_decode($request->id);

        switch($request->status){

            case 'N':

                $block = 'Y';

                $blockText = 'Block';

                break;

            case 'Y':

                $block = 'N';

                $blockText = 'Unblock';

                break;

            default:

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back();

        }

        if(CmsPages::where(['id' => $id])->update(['is_block' => $block])){

            $prompt = array('status' => 1, 'id' => $id, 'event' => $blockText);

            echo json_encode($prompt);

        }else{

            $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

            return redirect()->back();

        }

    }

    public function list_cms($id = null, Request $request){

        $id = base64_decode($id);

        // dd($id);

        if ($id>0){

            $list_cms = DB:: table('sites')

                            ->join('cms_pages_sitewise','sites.id','=','cms_pages_sitewise.site_id')

                            ->where(['cms_pages_sitewise.cms_id'=>$id])

                            ->get();

            // dd($list_banners);

        }

        return view('admin.cms.list_cms', ['cms_id' => $id, 'list_cms' => $list_cms, 'request' => $request]);
    }

    public function list_cms_add($id = null, Request $request)
    {

        $cms_id = base64_decode($id);

        $sites = DB::table('sites')->get();

        $obj = new CmsPagesSitewise;

        if($request->isMethod('POST')){

            $site_id=$request->site_id;

            // dd($site_id);

            $data  = DB::table('cms_pages_sitewise')
                    ->where(['cms_id'=>$cms_id])
                    ->where(['site_id'=>$site_id])
                    ->first();

            // dd($data);

            if($data){        
                $site_cms_id = $data->id;
                // dd($cat_ban_id);
            }else{
                $site_cms_id = 0;
            }  

            $request->validate([

                'title'=>'required',
                'meta_title'=>'required',
                'meta_description'=>'required',
            ]);

            if($site_cms_id!=null){

                $update_arr['title'] = $request->title;
                $update_arr['slug'] = $request->slug;
                $update_arr['content'] = $request->content;
                $update_arr['meta_title'] = $request->meta_title;
                $update_arr['meta_description'] = $request->meta_description;
                
                CmsPagesSitewise::where(['id' => $site_cms_id])->update($update_arr);

                $request->session()->flash('alert-success', 'Site wise cms successfully updated.');

                return redirect()->route('admin.cms.list');

            }else{

            if($cms_pages_sitewise = $obj->create([

                'cms_id' => $request->cms_id,
                'site_id' => $request->site_id,
                'title' => $request->title, 
                'slug' => $request->slug,
                'content' => $request->content,
                'meta_title' => $request->meta_title, 
                'meta_description' => $request->meta_description,
                'created_by' => Auth::guard('AdminLogin')->user()->id

            ]))

            {
                $request->session()->flash('alert-success', 'Site wise cms successfully added.');

                return redirect()->route('admin.cms.list');

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }

        }

        }
        return view('admin.cms.list_cms_add', ['cms_id' => $cms_id, 'sites' => $sites, 'request' => $request]);

    }

    public function list_cms_edit($id = null, Request $request){

        $id = base64_decode($id);

        $dataDetails  = CmsPagesSitewise::where('id',$id)->first();

        $site=DB::table('sites')->where(['id' => $dataDetails->site_id])->first();

        // dd($site);

        // dd($dataDetails);

        if($request->isMethod('POST')){

            $request->validate([
                'title'=>'required',
                'meta_title'=>'required',
                'meta_description'=>'required',
            ]);

            $formid=$request->formid;


                $update_arr['title'] = $request->title;
                $update_arr['slug'] = $request->slug;
                $update_arr['content'] = $request->content;
                $update_arr['meta_title'] = $request->meta_title;
                $update_arr['meta_description'] = $request->meta_description;

            

            if(CmsPagesSitewise::where(['id' => $request->formid])->update($update_arr)){

                $request->session()->flash('alert-success', 'Site wise cms successfully updated.');

                // return redirect()->route('admin.category.list');

                return redirect()->back();

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }

        }

         return view('admin.cms.list_cms_edit', ['dataDetails' => $dataDetails, 'request' => $request, 'site' => $site]);

    }

    public function site_cms_status(Request $request)

    {

        if($request->id == null || $request->status == null){

            return redirect()->route('admin.cms.list');

        }

        $id = base64_decode($request->id);

        switch($request->status){

            case 'N':

                $block = 'Y';

                $blockText = 'Block';

                break;

            case 'Y':

                $block = 'N';

                $blockText = 'Unblock';

                break;

            default:

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back();

        }

        if(CmsPagesSitewise::where(['id' => $id])->update(['is_block' => $block])){

            $prompt = array('status' => 1, 'id' => $id, 'event' => $blockText);

            echo json_encode($prompt);

        }else{

            $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

            return redirect()->back();

        }

    }

}