<?php
namespace App\Http;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Str;
use App\Models\GBGHomePageProduct;
use App\Models\GBGProduct;
use App\Models\GBGProductImage;
use App\Models\GBGCategory;
use Symfony\Component\HttpFoundation\StreamedResponse;

class pagginationHelper{
    public static function get_categorywiseproduct($catid = 0){
        $result = GBGHomePageProduct::where(['cat_id' => $catid])->get();
        return $result;
    }
    public static function get_categorywiseproductname($pid = 0){
        $result = GBGProduct::where(['id' => $pid])->get();
        return $result;
    }
    public static function get_imagename($pid = 0){
        $result = GBGProductImage::where(['product_id' => $pid])->first();
        return $result;
    }
    public static function get_categoryname($cid = 0){
        $result = GBGCategory::where(['id' => $cid])->get();
        return $result;
    }

    public static function get_site_info($site = null){
        $result = DB::table('sites')->where(['site_name' => $site])->first();
        return $result;
    }

    public static function product_relatated_category_list($productid = 0, $site = null){
        $result = [];
        $getCategoryId = DB::connection('mysql'.$site)->table('product_categories')->where('product_id', $productid)->pluck('category_id');
        if(isset($getCategoryId) && count($getCategoryId) > 0){
            $result = DB::connection('mysql'.$site)->table('categories')->whereIn('id', $getCategoryId)->pluck('name');
        }
        return $result;
    }

    public static function agent_item($productid = 0, $site = null){
        $result = '';
        $getDetails = DB::connection('mysql'.$site)->table('agent_product_details')->where('product_id', $productid)->first();

        if($getDetails){
            $result = $getDetails->item_detail;
        }
        
        
        return $result;
    }

    public static function get_image($id = 0, $site = null){
        $result = DB::connection('mysql'.$site)->table('product_images')
                            ->where(['product_id' => $id, 'default_image' => 'Y'])->first();
        return $result;
    }

    public static function get_reviewDtlsbyProduct($id = 0, $site = null){
        $result = DB::connection('mysql'.$site)->table('product_rating')
                                        ->where(['product_id' => $id])->get();
        return $result;
    }

    public static function get_message_details($id = null, $site = null){
        $result = DB::connection('mysql'.$site)->table('order_messages')->where(['order_id' => $id])->first();
        return $result;
    }

    public static function get_coupon_details($id = null, $site = null){
        $result = DB::connection('mysql'.$site)->table('applied_coupons')->where(['order_id' => $id])->first();
        return $result;
    }

    public static function get_assign_order_details($order_id = null, $site = null){
        $result = [];
        if( $order_id != null ) {
            $result = DB::connection('mysql'.$site)->table('assign_order_details')->where('order_id',$order_id)->first();
        }
        return $result;
    }
    
    public static function get_assign_agent_name($id = null, $site = null){
        $assignAgent = '';
        if( $id != null ) {
            $assignAgent = DB::connection('mysql'.$site)->table('assign_agent_list')->where('id',$id)->first();
        }
        return $assignAgent;
    }

    public static function get_item_detail($id = null, $addon_id = null, $site = null){
        $result = '';
        if($id != 0){
            $result = DB::connection('mysql'.$site)->table('agent_product_details')->where(['product_id'=>$id])->first();
        }else{
            $result = DB::connection('mysql'.$site)->table('agent_product_details')->where(['product_id'=>$addon_id])->first();
        }
        return $result;
    }

    public static function get_agent_link($id = null, $addon_id = null, $site = null){
        $result = '';
        
        $result = DB::connection('mysql'.$site)->table('products')->where(['id'=>$id])->first();
        
        return $result;
    }

    public static function reportOrderDtl($id = null, $site = null){
        

        $dd = $di = '';

        $orderDtl = DB::connection('mysql'.$site)->table('order_details')->where(['order_id'=>$id])->get();

        $result = [];
        $result['deliveryDate'] = '';
        $result['deliveryItem'] = '';

        foreach($orderDtl as $order){
            if($result['deliveryDate'] != ''){ $dd = '<br>'; } else { $dd = ''; }
            if($result['deliveryItem'] != ''){ $di = '<br>'; } else { $di = ''; }
            $result['deliveryDate'] = $result['deliveryDate'] . $dd . date('jS M,Y' , strtotime($order->delivery_date));

            if( $order->product_id == 0 && $order->order_details_id_giftaddon > 0 ){
                $result['deliveryItem'] = $result['deliveryItem'] . $di . self::get_productName($order->gift_addon_id, $site) . '<em>'.$order->qty.'</em>';
            }else{
                $result['deliveryItem'] = $result['deliveryItem'] . $di . self::get_productName($order->product_id, $site) . '<em>'.$order->qty.'</em>';
            }
            
        }

        //dd($result);
        return $result;
    }

    public static function get_productName($id = null, $site = null){
        $result = DB::connection('mysql'.$site)->table('products')->where(['id'=>$id])->first();
        return $result->product_name;
    }

    public static function get_imagelink($id = null, $site = null){
        $imgDtl = DB::connection('mysql'.$site)->table('product_images')->where(['id'=>$id, 'default_image' => 'Y'])->first();

        $siteDtl = DB::table('site_details')->where(['site_sort_name'=>$site])->first();

        $result = $siteDtl->site_link.'uploaded/product/'.$imgDtl->name;
        return $result;
    }

    public static function get_order_messages($id = null, $site = null){
        $result = DB::connection('mysql'.$site)->table('order_messages')->where(['order_id'=>$id])->first();
        return $result;
    }

    public static function conversionCount($site, $id){
        $result = [];
        $result = DB::connection('mysql')->table('contact_conversations')->where(['contact_id'=>$id])->get();
        return $result;
    }
    public static function bulkconversionCount($site, $id){
        $result = [];
        $result = DB::connection('mysql'.$site)->table('bulk_conversations')->where(['bulk_id'=>$id])->get();
        return $result;
    }

    public static function adminName($id){
        $result = DB::table('admins')->where(['id'=>$id])->first();
        if($result){
            return $result->name;
        }else{
            return "Admin";
        }
        
    }


    //METHODS Created FOR REPORT MANAGEMENT

    public static function get_report_productname($pid = null ,$sitename = null){

        $sitename = str::lower($sitename);
        $connection_name = 'mysql'.$sitename;
        if(DB::connection($connection_name)->table('products')->where('products.id','=',$pid)->exists()){
            $product_name = DB::connection($connection_name)->table('products')->where('products.id','=',$pid)->get(['products.product_name']);
        }
        return $product_name;
    }

    public static function get_report_orderno($pdate = null ,$sitename = null){

        $connection_name = 'mysql'.$sitename;
        $orderno = DB::connection($connection_name)->table('orders')->where('purchase_date','LIKE', "%".$pdate."%")->where('payment_status','=','C')->get(['orders.*']);
        $day = Carbon::parse($pdate)->format('D');
        return ([$orderno,$day]);
    }

    public static function get_report_previous_orderno($pdate = null ,$sitename = null){

        $connection_name = 'mysql'.$sitename;
        $orderno = DB::connection($connection_name)->table('orders')->where('purchase_date','LIKE', "%".$pdate."%")->where('payment_status','=','C')->get(['orders.*']);
        $day = Carbon::parse($pdate)->format('D');
        return ([$orderno,$day]);
    }

    public static function get_report_orderdetails($oid = null ,$sitename = null){

        $connection_name = 'mysql'.$sitename;
        $orderdetails = [];
        $j = 0;
        $orderdetails = DB::connection($connection_name)->table('order_details')->where('order_id','=',$oid)->get(['order_details.product_id','order_details.qty','order_details.delivery_date','order_details.original_price','order_details.delivery_country_id','order_details.delivery_city_id','order_details.delivery_date','order_details.ship_price']);
        $assignorderdetails = DB::connection($connection_name)->table('assign_order_details')->where('order_id','=',$oid)->get(['assign_order_details.placement_price','assign_order_details.placed_to']);
        return ($orderdetails);
    }

    public static function get_report_productdetails($oid = null ,$sitename = null){

        $connection_name = 'mysql'.$sitename;
        $product = [];
        $j = 0;
        $orderdetails = DB::connection($connection_name)->table('order_details')->where('order_id','=',$oid)->get(['order_details.product_id','order_details.qty','order_details.delivery_date']);
        foreach($orderdetails as $od){
            $product[$j][0] = DB::connection($connection_name)->table('products')->where('products.id','=',$od->product_id)->get(['products.product_name','products.id']);
            $product[$j][1] = $od->qty;
                $j++;
        }

        return ($product);
    }

    public static function get_report_assignorderdetails($oid = null ,$sitename = null){

        $connection_name = 'mysql'.$sitename;
        $assignorderdetails = [];
        $agent_name = [];

        if(DB::connection($connection_name)->table('assign_order_details')->where(['assign_order_details.order_id' => $oid])->exists()){

            $assignorderdetails = DB::connection($connection_name)->table('assign_order_details')->where('order_id','=',$oid)->get(['assign_order_details.order_id','assign_order_details.placement_price','assign_order_details.partial_refund_price','assign_order_details.placed_to','assign_order_details.cancel_agent_refund']);
            $agent_name =  DB::connection($connection_name)->table('assign_agent_list')->where('assign_agent_list.id','=',$assignorderdetails[0]->placed_to)->get(['assign_agent_list.agent_name']);
            return ([$assignorderdetails,$agent_name]);
        }
        else{

            return ($assignorderdetails);

        }

    }

    public static function get_report_userdetails($uid = null ,$sitename = null){

        $cost = 0;
        $avg_value = 0;
        $user_details = [];
        $order_value = [];
        $sitename = str::lower($sitename);
        $connection_name = 'mysql'.$sitename;
        if(DB::connection($connection_name)->table('users')->where('users.id','=',$uid)->exists()){
            $user_details = DB::connection($connection_name)->table('users')->where('users.id','=',$uid)->get(['users.*']);
            $order_value =  DB::connection($connection_name)->table('orders')->where('orders.user_id','=',$uid)->get(['orders.final_ordered_amount']);

            foreach($order_value as $ov){
                $cost = $cost + $ov->final_ordered_amount;
            }
            $avg_value = ($cost/sizeof($order_value));
            $user_details['avg_value'] = $avg_value;

        }

        return $user_details;
    }

    public static function get_report_delivery_date($oid = null ,$sitename = null){

        $connection_name = 'mysql'.$sitename;
        $j = 0;
        $delivery_date = DB::connection($connection_name)->table('order_details')->where('order_id','=',$oid)->select(['order_details.delivery_date','order_details.order_id'])->first();
        return ($delivery_date);
    }

    public static function get_report_user_name($uid = null ,$sitename = null){

        $connection_name = 'mysql'.$sitename;
        $user_name = [];
        if(DB::connection($connection_name)->table('users')->where('users.id','=',$uid)->exists()){
            $user_name = DB::connection($connection_name)->table('users')->where('users.id','=',$uid)->select(['users.name','users.email'])->get();
        }

        return ($user_name);
    }

    public static function get_report_countrydetails($cid = null ,$sitename = null){

        $connection_name = 'mysql'.$sitename;
        $countrydetails = DB::connection($connection_name)->table('countries')->where('id','=',$cid)->get(['countries.name']);
        return ($countrydetails);
    }

    public static function get_report_citydetails($cid = null ,$sitename = null){

        $connection_name = 'mysql'.$sitename;
        $citydetails = DB::connection($connection_name)->table('cities')->where('id','=',$cid)->get(['cities.name']);
        return ($citydetails);
    }

    public static function get_report_agent_payment_report($pid = null ,$connection_name = null){

        $agent_name = DB::connection($connection_name)->table('assign_agent_list')->where('assign_agent_list.id','=',$pid)->get(['assign_agent_list.agent_name']);
        return ($agent_name);
    }
    public static function get_report_placementprice($pto = null ,$total = null, $final_orderd_id = [], $connection_name = null){


        $temp =[];
        $price = [];
        $result = [];
        $price_value = 0;
        $k = 0;
        $zero = 0;

        $temp = DB::connection($connection_name)->table('assign_order_details')->where('assign_order_details.placed_to','=',$pto)->get(['assign_order_details.placement_price','assign_order_details.order_id','assign_order_details.placed_to']);

        for($j = 0; $j < sizeof($temp); $j++){
            if(in_array($temp[$j]->order_id,$final_orderd_id)){
                if($temp[$j]->placement_price == 0){
                    $zero = $zero + 1;
                }
                else{
                    $price_value = $price_value + $temp[$j]->placement_price;
                    $price[$k++] = $temp[$j]->placement_price;
                }

            }
        }
        $result[0] = $zero + sizeof($price);
        $result[1] = $price_value;
        $result[2] = sizeof($price);
        $result[3] = $zero;

        return ($result);
    }

    public static function getFileExtensionFromBase64($base64String) {
        // Split the string to get the data and the mime type
        $data = explode(';', $base64String);

        // Check if the data contains the MIME type
        if (count($data) > 1 && strpos($data[0], 'data:') === 0) {
            $mimeType = str_replace('data:', '', $data[0]);
        } else {
            return false; // Invalid base64 string
        }

        // Map MIME type to file extension
        $extensions = [
            'image/jpg' => 'jpg',
            'image/jpeg' => 'jpg',
            'image/jfif' => 'jpg',
            'image/png' => 'png',
            //'image/gif' => 'gif',
            'image/webp' => 'webp',
            'application/pdf' => 'pdf',
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' => 'xlsx',
            'application/vnd.ms-excel' => 'xls',
            // Add other MIME types and their corresponding extensions here
        ];

        // Return the file extension based on the MIME type
        return $extensions[$mimeType] ?? false;
    }

    

    
}



