@extends('layouts.admin.app')
@section('content')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<main id="main" class="main">
   <div class="page-breadcrumb">
      <div class="row">
         <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
            <h4 class="page-title">Agents List</h4>
            <div class="ml-auto text-right">
               <a href="{{route('admin.agent.add')}}" class="btn btn-success">Add Agent</a>
            </div>
         </div>
      </div>
   </div>
   <div class="container-fluid">
      <div class="row">
         <div class="col-12">
            <div class="card">
               @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                  @if(Session::has('alert-' . $msg))
                  <div class="alert alert-{{ $msg }} alert-dismissible fade show" role="alert">
                     {{ Session::get('alert-' . $msg) }}
                     <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                  </div>
                  @endif
               @endforeach
               <div class="card-body">
                  <h5 class="card-title">List of Agents</h5>
                  @if(count($agents) > 0)
                  <div class="table-responsive">
                     <table id="zero_config" class="table table-striped table-bordered">
                        <thead>
                           <tr>
                              <th scope="col">Sl No.</th>
                              <th scope="col">Name</th>
                              <th scope="col">Email</th>
                              <th scope="col">Created At</th>
                              {{-- <th scope="col">Updated At</th> --}}
                              <th scope="col">Action</th>
                           </tr>
                        </thead>
                        <tbody>
                           @php $i=1; @endphp
                           @foreach($agents as $key => $agent)
                           <tr>
                              <td>{{$i+$key}}</td>
                              <td>{{ucwords($agent->name)}}</td>
                              <td>{{$agent->email}}</td>
                              <td>{{$agent->created_at}}</td>
                              {{-- <td>{{$agent->updated_at}}</td> --}}
                              <td><a href="{{url('/admin/agent/edit')}}/{{encrypt($agent->id)}}"><i class="fas fa-edit"></i></a>
                              </td>
                           </tr>
                           @endforeach
                        </tbody>
                     </table>
                  </div>
                  @else
                     <div class="card">No Data Found...</div>
                  @endif
               </div>
            </div>
         </div>
      </div>
   </div>
</main>
<!-- End #main -->
<script>

   document.addEventListener("DOMContentLoaded", function () {
       const table = document.querySelector("#zero_config");
       const dataTable = new simpleDatatables.DataTable(table, {
           sortable: true,
           fixedHeight: true,
           columns: [
               { select: 0, sort: "asc" } // Sort by the 6th column (index 5) descending
           ]
       });
   });
   
</script>
@endsection