@extends('layouts.admin.app')

@section('content')

    <main id="main" class="main">
        @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')
            <div class="pagetitle">
              <h1>Dashboard</h1>
              <!-- <nav>
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                  <li class="breadcrumb-item">Tables</li>
                  <li class="breadcrumb-item active">General</li>
                </ol>
              </nav> -->
            </div><!-- End Page Title -->
          <section class="section dashboard">
            <div class="row">
              <div class="col-lg-12">
                <div class="row">
                  
                  <!-- This Month Orders Card -->
                  <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card info-card sales-card">
                      <a href="{{ url('/admin/order')}}">
                        <div class="card-body">
                          <h5 class="card-title">This Month Orders <span>| {{ date('M, y') }}</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-file-chart-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>{{ count($monthAllorder) }}</h6>
                              <span class="text-success small pt-1 fw-bold">Order Amount ₹{{ $monthTotalOrderAmt }}</span>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>

                  <!-- Orders Today Card -->
                  <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card info-card revenue-card">
                      <a href="{{ url('/admin/order')}}">
                        <div class="card-body">
                          <h5 class="card-title">Orders <span>| Today</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-edit-box-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>{{ count($todayAllorder) }}</h6>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>

                  <!-- Pending Orders Card -->
                  <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card info-card customers-card">
                      <a href="{{ url('/admin/order')}}">
                        <div class="card-body">
                          <h5 class="card-title">Pending <span>| Orders</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-draft-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>{{ count($pendingAllorder) }}</h6>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>

                  <!-- Cancel Orders Card -->
                  <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card info-card customers-card">
                      <a href="{{ url('/admin/order')}}">
                        <div class="card-body">
                          <h5 class="card-title">Cancel Orders <span>| {{ date('M, y') }}</span></h5>
                          <div class="d-flex align-items-center">
                            <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                              <i class="ri-delete-bin-5-fill"></i>
                            </div>
                            <div class="ps-3">
                              <h6>{{ count($monthCancelorder) }}</h6>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>

                </div> <!-- End inner row -->
              </div> <!-- End col-lg-12 -->
            </div> <!-- End outer row -->
          </section>
            <div class="pagetitle">
              <h1>City Wise Report</h1>
            </div><!-- End Page Title -->
            <section class="section dashboard">
            <div class="row">
              <div class="col-lg-12">
                <div class="row">
                  @forelse($tableItems as $tableItem)
                    <div class="col-lg-3 col-md-6 mb-4">
                      <div class="card info-card sales-card shadow-sm">
                        <div class="card-body">
                          <h5 class="card-title">
                            Site Name | {{ $tableItem['sitename'] }} <span class="text-primary"></span>
                          </h5>
                          <div class="d-flex align-items-start">
                            {{-- <div class="card-icon rounded-circle d-flex align-items-center justify-content-center bg-light text-dark me-3">
                              <i class="ri-file-chart-fill fs-4"></i>
                            </div> --}}
                            <div class="ps-1">
                              <p class="mb-2 fw-bold text-dark">Today Orders: <span class="text-success">{{ $tableItem['todayOrders'] }}</span></p>
                              <p class="mb-2 text-muted small">Order Amount: ₹{{ $tableItem['todayAmt'] }}</p>

                              <p class="mb-2 fw-bold text-dark">This Month Orders: <span class="text-success">{{ $tableItem['ThisMonthOrders'] }}</span></p>
                              <p class="mb-2 text-muted small">Order Amount: ₹{{ $tableItem['ThisMonthAmt'] }}</p>

                              <p class="mb-2 fw-bold text-dark">Pending Orders: <span class="text-warning">{{ $tableItem['PendingOrders'] }}</span></p>
                              <p class="mb-2 fw-bold text-dark">Cancel Orders: <span class="text-danger">{{ $tableItem['CancelOrder'] }}</span></p>

                              <a href="{{ route('admin.order.SiteNamewiseList', encrypt($tableItem['sitename'])) }}" class="btn btn-sm btn-outline-primary mt-2">View Orders</a>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  @empty
                  @endforelse

                </div> 
              </div> 
            </div>
          </section>
            
        @endif    
        
    </main>
            

    

@endsection
