@extends('layouts.admin.app')

@section('content')

<main id="main" class="main">
   <div class="container">
         <div class="card" style="width: 100%;">          
            <div class="card-body">
            <h5 class="card-title">AGENT NAME :{{$agents->name}} </h5> 
                <h5 class="card-title">PRODUCT DETAILS </h5> 
                    @if($agent_assinged->status=='P')
                        <div class="alert alert-danger" role="alert" style="width: 20%;text-align:center;">PENDING</div>
                        @elseif($agent_assinged->status=='PC')
                        <div class="alert alert-secondary" role="alert" style="width: 20%;text-align:center;">PROGRESS</div>
                        @elseif($agent_assinged->status=='CL')
                        <div class="alert alert-info" role="alert" style="width: 20%;text-align:center;">CANCEL</div>
                        @elseif($agent_assinged->status=='H')
                        <div class="alert alert-dark" role="alert" style="width: 20%;text-align:center;">HOLD</div>
                        @elseif($agent_assinged->status=='D')
                        <div class="alert alert-success" role="alert" style="width: 20%;text-align:center;">DELIVERED</div>
                        @elseif($agent_assinged->status=='S')
                        <div class="alert alert-success" role="alert" style="width: 20%;text-align:center;">Shipped</div>
                    @endif
                <h6 class="card-subtitle mb-2 text-body-secondary">ORDER NO : {{$agent_assinged->agent_order_id}}</h6>
                    <div style="text-align:right">
                           
                    </div>
                <p class="card-text"><b>Products</b></p>
                <ol>
                    @foreach($agent_product_list as $product)
                        @if($product->agent_id == $agentId)
                                <li>{{$product->item}}</li>
                        @endif
                    @endforeach
                </ol>
                <p><b>Delivery Address :</b> {{$orders->delivery_address}}</p>
                <p><b>Customer Contact :</b> {{$orders->billing_mobile}}</p>
                @php $price=0; @endphp
                <form action="{{url('/admin/order/dashboard')}}/{{$agent_assinged->agent_order_id}}/{{$agentId}}" method="post">
                    @csrf
                    <table class="table">
                        <thead>
                            <tr>
                                <th></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td  colspan="2">
                                <b>Total Price:</b>
                                    {{ $agent_assinged->totalPrice }}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <b>Extra</b>
                                    <input class="form-control" name="extra" id="extra" placeholder="Ask For Extra Charge" value="{{$agent_assinged->extra}}"/>
                                </td>
                                <td>
                                    <b>Delivery Charge</b> <input class="form-control" id="deliveryCharge" name="deliveryCharge" value="{{$agent_assinged->Deliver_charge}}"/>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                <b>Enter The Reason</b>
                                    <textarea name="reason" rows="4" cols="50" id="reason" placeholder="Reason" class="form-control">{{$agent_assinged->reason}}
                                    </textarea>
                                </td>
                            </tr>
                            <tr>
                                @if($agent_assinged->status == 'PC' || $agent_assinged->track_no != "")
                                    <td colspan="2"><input class="form-control" name="track_no" value="{{$agent_assinged->track_no}}" style="width:100%;" placeholder="Enter Tracking Number" ></td>
                                @endif
                            </tr>
                            <tr>
                                <td colspan="2" style="text-align: center!important;display:flex;margin-left: 81%;">
                                @if($agent_assinged->status == "P")
                                    <input type="radio" id="accept" name="status" value="PC">
                                    <label for="accept">Accept</label><br>
                                    <input type="radio" id="hold" name="status" value="H">
                                    <label for="hold">Hold</label><br>
                                    <input type="radio" id="reject" name="status" value="CL">
                                    <label for="reject">Reject</label>
                                @elseif($agent_assinged->status == "PC")
                                    <input type="radio" id="accept" name="status" value="S">
                                    <label for="accept">Shipped</label><br>
                                    <input type="radio" id="hold" name="status" value="H">
                                    <label for="hold">Hold</label><br>
                                    <input type="radio" id="reject" name="status" value="CL">
                                    <label for="reject">Reject</label>
                                @elseif($agent_assinged->status == "S")
                                    <input type="radio" id="accept" name="status" value="D">
                                    <label for="accept">Delivered</label><br>
                                    <input type="radio" id="hold" name="status" value="H">
                                    <label for="hold">Hold</label><br>
                                @elseif($agent_assinged->status == "CL")

                                @elseif($agent_assinged->status == "H")
                                    <input type="radio" id="accept" name="status" value="PC">
                                    <label for="accept">Accept</label><br>
                                    <input type="radio" id="reject" name="status" value="CL">
                                    <label for="reject">Reject</label>
                                    @elseif($agent_assinged->status == "H")

                                @endif
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    @error('status')
                                    <label  class="alert alert-danger" role="alert">{{ $message }}</label>
                                    @enderror
                                    @error('track_no')
                                    <label class="alert alert-danger" role="alert">{{ $message }}</label>
                                    @enderror
                                    @error('reason')
                                    <label class="alert alert-danger" role="alert">{{ $message }}</label>
                                    @enderror
                                </td>
                            </tr>
                            <tr>
                            @if($agent_assinged->status == 'CL' || $agent_assinged->status == 'D')
                            @else
                            <td colspan="2" style="text-align:center">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </td>
                            @endif
                            </tr>
                        </tbody>
                    </table>
                </form>
            </div>
        </div>
   </div>
</main>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

<script>
    $(document).ready(function(){
       $('.btn_submit').click(function(){
            var orderId = @json($agent_assinged->agent_order_id);
            var extra = $('#extra').val();
            var deliVery = $('#deliveryCharge').val();
            var reason = $('#reason').val();
            var status = $(this).attr('ds-value');
            console.log(status);
            $.ajax({
                url:"{{url('/agent/updateStatus')}}",
                type:'GET',
                data:{
                    orderId:orderId,
                    extra:extra,
                    deliVery:deliVery,
                    reason:reason,
                    status:status,
                },
                success:function(response){
                    console.log(response);
                },
                error:function(error){
                    console.log(error);
                },
            });
       });
    });
</script>

@endsection