@extends('layouts.admin.app')

@section('content')

<main id="main" class="main">
    @if(Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')

        <div class="container-fluid">
            
            <div class="row">
                <div class="col-12">

                    <h4 class="card-title" style="display: inline-block;padding: 0 10px 0 0;">Product Status</h4>
                    <div class="d-flex justify-content-end mb-3">
                        <a href="{{ route('admin.product.list') }}" class="btn btn-outline-info">Back</a>
                    </div>

                    <div class="card">

                        

                        <form action="{{ route('admin.product.status-update') }}" method="post" class="status-form">
                            @csrf

                            @php
                                $statuses = [
                                    'AOF' => $aof,
                                    'BOF' => $bof,
                                    'COF' => $cof,
                                    'DOF' => $dof,
                                    'HOF' => $hof,
                                    'KOF' => $kof,
                                    'MOF' => $mof,
                                    'POF' => $pof,
                                ];
                            @endphp

                            @foreach ($statuses as $label => $status)
                                <fieldset class="row mb-4">
                                    <legend class="col-form-label col-sm-2 pt-0 fw-bold">{{ $label }} </legend>
                                    <div class="col-sm-10">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="{{ strtolower($label) }}" id="{{ strtolower($label) }}0" value="N" {{ $status == 'N' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="{{ strtolower($label) }}0">Show</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="{{ strtolower($label) }}" id="{{ strtolower($label) }}1" value="Y" {{ $status == 'Y' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="{{ strtolower($label) }}1">Block</label>
                                        </div>
                                    </div>
                                </fieldset>
                            @endforeach

                            <div class="text-center">
                                <button type="submit" class="btn btn-lg btn-info">Submit</button>
                                <input type="hidden" name="id" value="{{ $id }}" />
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>


        
        {{-- <div style="font-size:25px; text-align:center; text-decoration: underline;">Product Status Block or Not</div> --}}
        
    @endif
</main>

<style>
    .status-form {
        /*max-width: 800px;
        margin: 0 auto;*/
        padding: 20px;
        background: #f9f9f9;
        border: 1px solid #ddd;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }

    .status-form fieldset {
        padding: 10px;
        border: 1px solid #e3e3e3;
        border-radius: 5px;
        background: #fff;
    }

    .status-form legend {
        font-size: 1.1rem;
        color: #333;
    }

    .form-check-input {
        margin-right: 5px;
    }

    .btn-info {
        background-color: #17a2b8;
        border-color: #17a2b8;
    }

    .btn-info:hover {
        background-color: #138496;
        border-color: #117a8b;
    }

    .text-center {
        margin-top: 20px;
    }
</style>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>

@endsection
