@extends('layouts.agent.app')

@section('content')

<main id="main" class="main">
    <div class="container">
        <form action="{{url('/agent/assignorder/list/search')}}/{{encrypt($user->id)}}" method="post">
            @csrf
            <table class="table" styla="margin-top:10%;">
                <thead>
                    <tr>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Select the Status</th>
                        <th></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><input type="date" name="fromDate" id="FromDate" class="form-control" required /></td>
                        <td><input type="date" name="toDate" id="toDate" class="form-control" required/></td>
                        <td>
                            <select name="status" id="status" class="form-control" required>
                                <option value="" selected>SELECT STATUS</option>
                                <option value="P">PENDING</option>
                                <option value="PC">PROCESSED</option>
                                <option value="S">SHIPPED</option>
                                <option value="D">DELIVERED</option>
                                <option value="H">HOLD</option>
                                <option value="CL">CANCELED</option>
                            </select>
                        </td>
                        <td><button class="btn btn-primary" type="submit">Search</button></td>
                        <td><a href="{{url('/agent/assignorder/generateReport')}}" class="btn btn-primary" >Generate Report</a></td>
                    </tr>
                </tbody>
            </table>
        </form>

        <div class="col-4 ms-auto text-end" style="display:flex; align-items: center;">
            <form method="GET" action="{{ route('agent.assignorder.list') }}" style="width:100%" >
                <div class="input-group">
                  <input type="text" name="search" id="search-field" class="form-control" value="{{$search}}" placeholder="Search by Order ID" autocomplete="off">
                  <button type="submit" class="input-group-text"><i class="bx bx-search-alt"></i></button>
                </div>
            </form>
        </div><br>

        @if(count($result) > 0)
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th scope="col" style="width:5%">#</th>
                        <th scope="col" style="width:14%">Assign Order Id</th>
                        {{--<th scope="col" style="width:15%">{!! CustomPaginator::sort('agent_id', 'Agent Name') !!}</th>--}}
                        <th scope="col" style="width:22%">Products</th>
                        <th scope="col" style="width:11%">{!! CustomPaginator::sort('delivery_date', 'Delivery Date') !!}</th>
                        <th scope="col" style="width:12%">{!! CustomPaginator::sort('status', 'Delivery Status') !!}</th>
                        <th scope="col" style="width:14%">{!! CustomPaginator::sort('created_at', 'Agent Placed Date') !!}</th>
                        <th scope="col" style="width:4%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @php $i = ($result->currentPage() - 1) * $result->perPage() + 1; @endphp
                    @foreach($result as $key => $order)
                    
                    <tr>
                        <td scope="row">{{ $i + $key }}</td>
                        <td>
                            {{ $order->agent_order_id }}<br>
                        </td>
                        {{--<td>
                            @php
                                $agentDtl = App\Http\Helper1::getAgentDtl($order->agent_id); 
                            @endphp
                            {{ ucwords($agentDtl->name) }}
                        </td>--}}
                        <td>
                            @php
                                $agentProductDtl = App\Http\Helper1::getAgentPlaceProductDtl($order->id); 
                            @endphp
                            @foreach($agentProductDtl as $product)
                                {{ucwords($product->item)}}<span style="color:grey">({{$product->qty}})</span> 
                                @if(!$loop->last), @endif
                            @endforeach
                        </td>
                        <td>{{ date("d/m/Y" , strtotime($order->delivery_date)) }}</td>
                        <td>
                            <h5>
                                @if($order->status == 'P')
                                    <span class="badge bg-danger">Pending</span>
                                @elseif($order->status == 'PC')
                                    <span class="badge bg-info">Accepted</span>
                                @elseif($order->status == 'H')
                                    <span class="badge bg-warning">Hold</span>
                                @elseif($order->status == 'CL')
                                    <span class="badge bg-dark">Cancel</span>
                                @elseif($order->status == 'D')
                                    <span class="badge bg-success">Delivered</span>
                                @elseif($order->status == 'S')
                                    <span class="badge bg-primary">Shipped</span>
                                @endif
                            </h5>
                        </td>
                        <td>{{ date("d/m/Y H:m" , strtotime($order->created_at)) }}</td>
                        <td>
                            <div class="row">
                                <div class="col">
                                    <a href="{{url('/agent/assignorder/assign-order-view')}}/{{encrypt($order->agent_order_id)}}/{{encrypt($order->agent_id)}}"><i class="ri-file-edit-fill adminedit"></i></a>
                                </div>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div>
                <table  class="table">
                    @if ($result->hasPages())
                    <tr>
                        <td style="width:auto; text-align:center; border:none;" >
                            <nav role="navigation" aria-label="Pagination Navigation" class="flex justify-between">
                            <span>
                                @if ($result->onFirstPage())
                                    <span></span>
                                @else
                                    <a href="{{ $result->previousPageUrl() }}" class="btn btn-secondary btn-sm" rel="prev"><i class="bx bxs-chevron-left"></i></a>
                                @endif
                            </span>
                                @foreach(range(1, $result->lastPage()) as $i)
                                    @if($i >= $result->currentPage() - 2 && $i <= $result->currentPage() + 2)
                                        @if ($i == $result->currentPage())
                                        <a href="" class="btn btn-secondary btn-sm" style="background: white;color: black;">{{ $i }}</a>
                                        @else
                                        <a href="{{ $result->url($i) }}" class="btn btn-secondary btn-sm">{{ $i }}</a>
                                        @endif
                                    @endif
                                @endforeach
                            <span>
                                @if ($result->hasMorePages())
                                     <a href="{{ $result->nextPageUrl() }}" rel="next" class="btn btn-secondary btn-sm" ><i class="bx bxs-chevron-right"></i></a>
                                @else
                                    <span></span>
                                @endif
                                </span>
                            </nav>
                        </td>
                    </tr>
                    @endif   
                </table>
            </div>

        @else
            <div class="card" style="padding: 10px 12px;">No Data Found...</div>
        @endif
    </div>
</main>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

<script>

    $(document).ready(function(){
        $("#myInput").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $("#myTable tr").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });
    
</script>

@endsection