<?php $__env->startSection('content'); ?>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.5/xlsx.full.min.js"></script>  

<main id="main" class="main">

    <?php if(Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA'): ?>
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">CITY</h4>
                    <div class="ml-auto text-right">
                        <a href="<?php echo e(url('admin/city/list/')); ?>/1" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <br>
                            <h4>Import the Bulkcity File</h4>
                            <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(Session::has('alert-' . $msg)): ?>
                                    <h4 class="font-weight-light alert alert-<?php echo e($msg); ?>"><?php echo e(Session::get('alert-' . $msg)); ?></h4>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="card-body">
                            <form action="" method="post">
                                <?php echo csrf_field(); ?>
                                <label>Upload Excel File</label>
                                <input type="file" class="form-control" name="bulk_upload" id="bulk_upload" required>
                                <div id="upload_table"></div>
                                <br>
                                <div id="button"></div>
                                <input type="hidden" class="form-control" name="all" id="all"/>
                            </form>
                        </div>
                        <div class="card-body">
                            <div>
                                <span class="badge bg-primary">The Following Field Values will be uploaded</span>
                            </div>
                            <table id="product_table" style="width:100%; text-align: center;" border="1">
                                <tr>
                                    <td><b>Country Id</b></td>
                                    <td><b>Name</b></td>
                                    <td><b>Slug</b></td>
                                    <td><b>Banner Heading</b></td>
                                    <td><b>Content Top</b></td>
                                    <td><b>Content Bottom</b></td>
                                    <td><b>Meta Title</b></td>
                                    <td><b>Meta Description</b></td>
                                    <td><b>Meta Keyword</b></td>
                                    <td><b>Tag Line</b></td>
                                    <td><b>Tophead</b></td>
                                    <td><b>Sort Order</b></td>
                                    <td><b>Delivery Delay Days</b></td>
                                    <td><b>Metro City</b></td>
                                    <td><b>State</b></td>
                                    <td><b>Area Type</b></td>
                                    <td><b>Site Id</b></td>                   
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>    
</main>

<script>
    $(document).ready(function(){
        $('#bulk_upload').change(function(evt){
          $('#button').empty();

          $('#button').append(`
          <button class="btn btn-primary" type="submit" id="">Import</button> 
          `);
            var files = evt.target.files;
            var xl2json = new ExcelToJSON();
            xl2json.parseExcel(files[0]);
            $('#all').empty();
            $('#upload_table').empty();
        });


      // $(document).on('click', '#btn_upload', function(event) {
      // var value = event.detail; 
      // console.log(event);
      // });

        var getting_value = function(value){
            $(document).trigger('customEvent', value); 
        };

       var ExcelToJSON = function() {
       this.productList = [];

       this.parseExcel = function(file) {
        var reader = new FileReader();

        var self = this; 

        reader.onload = function(e) {
          var data = e.target.result;
          var workbook = XLSX.read(data, { type: 'binary' });
          workbook.SheetNames.forEach(function(sheetName) {
            var XL_row_object = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[sheetName]);
            self.productList = JSON.parse(JSON.stringify(XL_row_object)); 
            var tableHtml = `
              <table class="table table-striped table-dark" id="excel_table">
                <thead>
                  <tr>
                    <th>Country Id</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Banner Heading</th>
                    <th>Content Top</th>
                    <th>Content Bottom</th>
                    <th>Meta Title</th>
                    <th>Meta Description</th>
                    <th>Meta Keyword</th>
                    <th>Tag Line</th>
                    <th>Tophead</th>
                    <th>Sort Order</th>
                    <th>Delivery Delay Days</th>
                    <th>Metro City</th>
                    <th>State</b></th>
                    <th>Area Type</th>                  
                    <th>Site Id</th>
                  </tr>
                </thead>
                <tbody>
            `;
            var i = 0;
            $.each(self.productList, function(index, item) {
              var columns = Object.values(item);
              i++;
              tableHtml += `
                <tr>
                  <td>${columns[0]}</td>
                  <td>${columns[1]}</td>
                  <td>${columns[2]}</td>
                  <td>${columns[3]}</td>
                  <td>${columns[4]}</td>
                  <td>${columns[5]}</td>
                  <td>${columns[6]}</td>
                  <td>${columns[7]}</td>
                  <td>${columns[8]}</td>
                  <td>${columns[9]}</td>
                  <td>${columns[10]}</td>
                  <td>${columns[11]}</td>
                  <td>${columns[12]}</td>
                  <td>${columns[13]}</td>
                  <td>${columns[14]}</td>
                  <td>${columns[15]}</td>
                  <td>${columns[16]}</td>
                </tr>
              `;
            });

            tableHtml += `
                </tbody>
              </table>
            `;

            $('#upload_table').html(tableHtml);
            var value = self.productList;
            getting_value(value);
            $('#all').val(JSON.stringify(self.productList));

          });
        };

        reader.onerror = function(ex) {
          console.log(ex);
        };

        reader.readAsBinaryString(file);
      };
        };

    var excelToJson = new ExcelToJSON();

  });
</script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/city/bulkcityupload.blade.php ENDPATH**/ ?>