

<?php $__env->startSection('content'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/extra-libs/DataTables/datatables.min.js')); ?>"></script>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('admin/assets/extra-libs/multicheck/multicheck.css')); ?>">
    <link href="<?php echo e(asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css')); ?>" rel="stylesheet">

    <main id="main" class="main">
        <?php if( Session::get('permissions.user_type') == 'A' ): ?>
	        <div class="page-breadcrumb">
                <div class="row">
                    <div class="col-12 d-flex no-block align-items-center">
                        <h4 class="page-title">Category</h4>
                        <div class="ml-auto text-right">
                            <a href="" class="btn btn-info" title="Bulk Upload Category"><i class="fas fa-upload"></i></a>
                            <a href="" class="btn btn-secondary" title="Bulk Update Category"><i class="fas fa-edit"></i></a>
                            <a href="" class="btn btn-success">ADD Category</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(Session::has('alert-' . $msg)): ?>
                                        <h4 class="font-weight-light alert alert-<?php echo e($msg); ?>"><?php echo e(Session::get('alert-' . $msg)); ?></h4>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <h5 class="card-title">Category</h5>
                                <?php if(count($result) > 0): ?>
                                <div class="table-responsive">
                                    <table id="zero_config" class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 5%"><b>No.</b></th>
                                                <th style="width: 20%"><b>Name</b></th>
                                                <th style="width: 20%"><b>Slug</b></th>
                                                <th style="width: 25%"><b>Banner</b></th>
                                                <th style="width: 15%"><b>Created Date</b></th>
                                                <th style="width: 6%"><b>Status</b></th>
                                                <th style="width: 9%"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $i=1; ?>
                                            <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($i + $key); ?></td>
                                                <td><?php echo e($data->name); ?></td>
                                                <td><?php echo e($data->slug); ?></td>
                                                <td>
                                                    <?php if($data->image != null ): ?>
                                                        <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/banner_old/<?php echo e($data->image); ?>" style="width:300px; height: auto;"  >
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e(date('d-m-Y', strtotime($data->created_at))); ?></td>
                                                <td>
                                                    <label class="switch">
                                                        <input type="checkbox" class="blockstatus" name="stat" id="stat" data-id="<?php echo e(base64_encode($data->id)); ?>" <?php if($data->is_block == 'N'): ?> checked <?php endif; ?>>
                                                        <span class="slider roundsemi"></span>
                                                    </label>
                                                    <label id="status-info-<?php echo e($data->id); ?>" class="status-stat"></label>
                                                </td>
                                                <td >
                                                    <a href="">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a onclick="return confirm('Are you sure you want to delete the Category?')" href="">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </a>
                                                    <a href="" target="_blank">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tfoot>
                                    </table>
                                </div>
                                <?php else: ?>
                                <div class="card">No Data Found...</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>    
    </main><!-- End #main -->

    <script>
        /****************************************
         *       Basic Table                   *
         ****************************************/
        $('#zero_config').DataTable({
            "order": [[5, "desc"]] 
        });

        
        $(function(){
            setTimeout(function(){ $('.alert').hide(); }, 3000);
            var status, id;
            $('#zero_config').on('change', '.blockstatus', function() {
            //$('.blockstatus').change(function(){
                if(this.checked){
                    status = 'Y';
                }else{
                    status = 'N'
                }
                id = $(this).attr('data-id');
                var ajaxurl = ""; 
                $.ajax({
                    type : 'POST',
                    url : ajaxurl,
                    data : { 'id' : id, 'status' : status },
                    headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success : function(response){
                        response = JSON.parse(response);
                        if(response.status == 1){
                            $('#status-info-'+response.id).html(response.event).fadeIn(100).delay(1000).fadeOut();
                        }
                    },
                    error : function(){
                        $('.selected_records_data').html('<span class="error-msg text-danger">There was an unexpected error!! Please try again later.</span>');
                    }
                });
            });
        })

        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adminrighflorist/public_html/resources/views/admin/category/category.blade.php ENDPATH**/ ?>