<?php $__env->startSection('content'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <main id="main" class="main">

	        <div class="page-breadcrumb">

                <div class="row">

                    <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">

                        <h4 class="page-title">Agent Product List</h4>

                        <div class="ml-auto text-right">

                            <a href="<?php echo e(route('agentProductAdd')); ?>" class="btn btn-success">ADD Agent Product</a>

                        </div>

                    </div>

                </div>

            </div>

            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="card">
                            <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(Session::has('alert-' . $msg)): ?>
                                    <div class="alert alert-<?php echo e($msg); ?> alert-dismissible fade show" role="alert">
                                        <?php echo e(Session::get('alert-' . $msg)); ?>

                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div class="card-body">

                                <h5 class="card-title">Agent Products</h5>

                                <?php if(count($result) > 0): ?>

                                <div class="table-responsive">

                                    <table id="zero_config" class="table table-striped table-bordered">

                                        <thead>

                                            <tr>
                                                <th style="width: 1%"><b>No.</b></th>
                                                <th style="width: 5%"><b>Agent</b></th>
                                                <th style="width: 5%"><b>Title</b></th>
                                                <th style="width: 5%"><b>Slug</b></th>
                                                <th style="width: 2%"><b>Price</b></th>
                                                <th style="width: 2%"><b>Gst</b></th>
                                                <th style="width: 2%"><b>Without Gst</b></th>
                                                <th style="width: 5%"><b>Created Date</b></th>
                                                <th style="width: 2%">Action</th>
                                            </tr>

                                        </thead>

                                        <tbody>

                                            <?php $i=1; ?>

                                            <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <tr>
                                                <td><?php echo e($i + $key); ?></td>
                                                <td><?php echo e($data->name); ?></td>
                                                <td><?php echo e($data->item); ?></td>
                                                <td><?php echo e($data->slug); ?></td>
                                                <td><?php echo e($data->price); ?></td>
                                                <td><?php echo e($data->gst); ?></td>
                                                <td><?php echo e($data->price_without_gst); ?></td>
                                                <td><?php echo e(date('d-m-Y', strtotime($data->created_at))); ?></td>
                                                

                                                <td>

                                                    <a href="<?php echo e(url('/agent-product-edit')); ?>/<?php echo e($data->id); ?>">

                                                        <i class="fas fa-edit"></i>

                                                    </a>

                                                    

                                                </td>

                                            </tr>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </tfoot>

                                    </table>

                                </div>

                                <?php else: ?>

                                    <div class="card">No Data Found...</div>

                                <?php endif; ?>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

    </main><!-- End #main -->

    <script>

        /****************************************

         *       Basic Table                   *

         ****************************************/

        // $('#zero_config').DataTable({

        //     "order": [[5, "desc"]] 

        // });

        document.addEventListener("DOMContentLoaded", function () {
            const table = document.querySelector("#zero_config");
            const dataTable = new simpleDatatables.DataTable(table, {
                sortable: true,
                fixedHeight: true,
                columns: [
                    { select: 0, sort: "asc" } // Sort by the 6th column (index 5) descending
                ]
            });
        });


        // $(function(){
        //     setTimeout(function(){ $('.alert').hide(); }, 3000);
        //     var status, id;
        //     $('#zero_config').on('change', '.blockstatus', function() {
        //     //$('.blockstatus').change(function(){
        //         if(this.checked){
        //             status = 'Y';
        //         }else{
        //             status = 'N'
        //         }
        //         id = $(this).attr('data-id');
        //         var ajaxurl = "<?php echo e(route('admin.cms.status')); ?>"; 
        //         $.ajax({
        //             type : 'POST',
        //             url : ajaxurl,
        //             data : { 'id' : id, 'status' : status },
        //             headers: {
        //                     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        //             },
        //             success : function(response){
        //                 response = JSON.parse(response);
        //                 if(response.status == 1){
        //                     $('#status-info-'+response.id).html(response.event).fadeIn(100).delay(1000).fadeOut();
        //                 }
        //             },
        //             error : function(){
        //                 $('.selected_records_data').html('<span class="error-msg text-danger">There was an unexpected error!! Please try again later.</span>');
        //             }
        //         });
        //     });
        // })


    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/agent_product_list.blade.php ENDPATH**/ ?>