

<?php $__env->startSection('content'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>  <!-- CDN for xlsx library -->

<main id="main" class="main">
    <?php if(Session::get('permissions.user_type') == 'A'): ?>
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center">
                    <h4 class="page-title">PRODUCT</h4>
                    <div class="ml-auto text-right">
                        <a href="<?php echo e(route('admin.product')); ?>" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <br>
                            <h4>Import the Bulkproduct File</h4>
                            <?php if(session('message')): ?>
                                <h4><?php echo e(session('message')); ?></h4>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <form method="post" id="formid" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <label>Upload Excel File</label>
                                <input type="file" id="excel_file" name="excel_file" class="form-control" accept=".xlsx,.xls" required />
                                <br>
                                <button type="submit" id="btnValidar" class="btn btn-primary">BulkProduct Upload</button>
                            </form>
                        </div>
                        <div class="card-body">
                            <div>
                                <span class="badge bg-primary">The Following Field Values will be uploaded</span>
                            </div>
                            <table id="product_table" style="width:100%; text-align: center;" border="1">
                                <tr>
                                    <td><b>Title</b></td>
                                    <td><b>Description</b></td>
                                    <td><b>Content</b></td>
                                    <td><b>Price</b></td>
                                    <td><b>Mrp</b></td>
                                    <td><b>Delay Days</b></td>
                                    <td><b>Alt</b></td>
                                    <td><b>Meta Title</b></td>
                                    <td><b>Meta Description</b></td>
                                    <td><b>Agent Link</b></td>
                                    <td><b>IMG ID</b></td>
                                    <td><b>Category</b></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>    
</main>

<script type="text/javascript">
    $(document).ready(function(){
        $('#btnValidar').click(function(e) {
            e.preventDefault();

            var file = $('#excel_file')[0].files[0];  // Get the file input
            if (!file) {
                alert("Please select a file.");
                return;
            }

            var reader = new FileReader();
            reader.onload = function(event) {
                var data = event.target.result;
                var workbook = XLSX.read(data, {type: 'binary'});

                // Assuming the Excel file contains the data in the first sheet
                var firstSheet = workbook.Sheets[workbook.SheetNames[0]];
                var jsonData = XLSX.utils.sheet_to_json(firstSheet);

                // Preview parsed data (optional)
                console.log(jsonData);

                // Send the data to the backend
                $.ajax({
                    url: "<?php echo e(route('admin.bulkproductupload')); ?>",
                    method: 'POST',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",  // CSRF token for Laravel
                        products: JSON.stringify(jsonData)
                    },
                    success: function(response) {
                        console.log(response);
                        alert('Data uploaded successfully!');
                    },
                    error: function(error) {
                        console.log(error);
                        alert("An error occurred.");
                    }
                });
            };
            reader.readAsBinaryString(file);  // Read the file as a binary string
        });
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adminrighflorist/public_html/resources/views/admin/product/bulkproductupload.blade.php ENDPATH**/ ?>