<?php $__env->startSection('content'); ?>


<main id="main" class="main">

    <div class="pagetitle row">
        <div class="col-10">
            <h1>Orders</h1>
            <nav>
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/home')); ?>">Home</a></li>
                  <li class="breadcrumb-item active">Orders</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <section class="section">
        <div class="row">
            <div class="col-lg-12">
            
                <div class="card">
                    <div class="card-body">

                        <div class="row">
                            <div class="col-8">
                                <h5 class="card-title">Order List (<?php echo e($sitename); ?>)</h5>

                            </div>
                            <div class="col-4 ms-auto text-end" style="display:flex; align-items: center;">
                                <form method="GET" action="<?php echo e(route('admin.order.list')); ?>" style="width:100%" >
                                    <div class="input-group">
                                      <input type="text" name="search" id="search-field" class="form-control" placeholder="Search" autocomplete="off" required>
                                      <button type="submit" class="input-group-text"><i class="bx bx-search-alt"></i></button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(Session::has('alert-' . $msg)): ?>
                                <div class="alert alert-<?php echo e($msg); ?> alert-dismissible fade show" role="alert">
                                    <i class="bi bi-check-circle me-1"></i>
                                    <?php echo e(Session::get('alert-' . $msg)); ?>

                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if($request->search != null): ?>
                            <p style="font-size: 13px;">
                                Searched for: "<?php echo e($request->search); ?>" <a href="<?php echo e(route('admin.order.list')); ?>" style="font-size: 13px; padding-left: 10px;" class="badge border-danger border-1 text-danger">Clear Search</a>
                            </p>
                        <?php endif; ?>

                        <?php if(count($result) > 0): ?>

                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th scope="col" style="width:6%">#</th>
                                    <th scope="col" style="width:15%">Order ID</th>
                                    <th scope="col" style="width:12%"><?php echo CustomPaginator::sort('created_at', 'Order Date'); ?></th>
                                    <th scope="col" style="width:12%">Delivery Date</th>
                                    <th scope="col" style="width:12%">Customer Name</th>
                                    <th scope="col" style="width:20%">Agent Placed Status</th>
                                    <th scope="col" style="width:8%">Pay Mode</th>
                                    <th scope="col" style="width:11%"><?php echo CustomPaginator::sort('order_delivery_status', 'Order Status'); ?></th>
                                    <th scope="col" style="width:3%">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = ($result->currentPage() - 1) * $result->perPage() + 1; ?>
                                <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php 
                                    $orDtl = App\Http\Helper1::reportOrderDtl($order->id); 
                                    $agentAssingedDetails = $agent_assinged->where('OID',$order->id);
                                ?>
                                <tr>
                                    <td scope="row"><?php echo e($i + $key); ?></td>
                                    <td><?php echo e($order->unique_order_id); ?></td>
                                    <td>
                                        <?php if( $order->purchase_date != NULL): ?>
                                            <?php echo e(date("d/m/Y H:i" , strtotime($order->purchase_date))); ?>

                                        <?php else: ?>
                                            <?php echo 'NA'; ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $orDtl['deliveryDate']; ?></td>
                                    <td><?php echo $order->billing_user_name; ?></td>
                                    <td>
                                        <?php //dd($agentAssingedDetails); ?>
                                        <?php $__currentLoopData = $agentAssingedDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agents): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $agentDtl = App\Http\Helper1::getAgentDtl($agents->agent_id); 
                                            ?>

                                            <b><?php echo e(ucwords($agentDtl->name)); ?></b>
                                            <?php if($agents->status == 'P'): ?>
                                                <span class="badge bg-danger">PENDING</span>
                                            <?php elseif($agents->status == 'PC'): ?>
                                                <span class="badge bg-info">ACCEPTED</span>
                                            <?php elseif($agents->status == 'CL'): ?>
                                                <span class="badge bg-dark">CANCELED</span>
                                            <?php elseif($agents->status == 'H'): ?>
                                                <span class="badge bg-warning">HOLD</span>
                                            <?php elseif($agents->status == 'D'): ?>
                                                <span class="badge bg-success">DELIVERED</span>
                                            <?php elseif($agents->status == 'S'): ?>
                                                <span class="badge bg-primary">SHIPPED</span>
                                            <?php endif; ?>
                                            <?php if(!$loop->last): ?> <hr style="margin: 0.5rem 0; opacity: 0.15;"> <?php endif; ?>    
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <td>
                                        

                                        
                                        
                                        <?php if( $order->payment_status == 'C'): ?>
                                            <span class="badge bg-success">
                                                
                                                <span class="badge bg-white text-success">
                                                    <?php if($order->payment_method == 1): ?>
                                                        <i class="bi bi-check-circle me-1" title="COD"></i>
                                                    <?php elseif($order->payment_method == 2): ?>
                                                        <i class="ri-paypal-fill" title="Paypal"></i>
                                                    <?php elseif($order->payment_method == 3): ?>
                                                        <i class="bi bi-check-circle me-1" title="PayU"></i>
                                                    <?php elseif($order->payment_method == 4): ?>
                                                        <i class="bi bi-check-circle me-1" title="Bank Transfer"></i>
                                                    <?php elseif($order->payment_method == 5): ?>
                                                        <i class="bi bi-check-circle me-1" title="Razorpay"></i>
                                                    <?php endif; ?>
                                                </span>
                                                Success
                                            </span>
                                            
                                            
                                        <?php elseif($order->payment_status == 'P'): ?>
                                            <span class="badge rounded-pill bg-secondary">PENDING</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <h5>
                                            <?php if($order->order_delivery_status == 'P'): ?>
                                                <span class="badge bg-danger">Pending</span>
                                            <?php elseif($order->order_delivery_status == 'PC'): ?>
                                                <span class="badge bg-info">Processed</span>
                                            <?php elseif($order->order_delivery_status == 'H'): ?>
                                                <span class="badge bg-warning">Hold</span>
                                            <?php elseif($order->order_delivery_status == 'CL'): ?>
                                                <span class="badge bg-dark">Cancel</span>
                                            <?php elseif($order->order_delivery_status == 'D'): ?>
                                                <span class="badge bg-success">Delivered</span>
                                            <?php elseif($order->order_delivery_status == 'S'): ?>
                                                <span class="badge bg-primary">Shipped</span>
                                            <?php endif; ?>
                                        </h5>
                                    </td>
                                    
                                    <td>
                                        <div class="row">
                                            <div class="col">
                                                <a href="<?php echo e(route('admin.order.view', base64_encode($order->id))); ?>">
                                                    <i class="bx bx-edit adminedit"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <div>
                            <table  class="table">
                                <?php if($result->hasPages()): ?>
                                <tr>
                                    <td style="width:auto; text-align:center; border:none;" >
                                        <nav role="navigation" aria-label="Pagination Navigation" class="flex justify-between">
                                        <span>
                                            <?php if($result->onFirstPage()): ?>
                                                <span></span>
                                            <?php else: ?>
                                                <a href="<?php echo e($result->previousPageUrl()); ?>" class="btn btn-secondary btn-sm" rel="prev"><i class="bx bxs-chevron-left"></i></a>
                                            <?php endif; ?>
                                        </span>
                                            <?php $__currentLoopData = range(1, $result->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($i >= $result->currentPage() - 2 && $i <= $result->currentPage() + 2): ?>
                                                    <?php if($i == $result->currentPage()): ?>
                                                    <a href="" class="btn btn-secondary btn-sm" style="background: white;color: black;"><?php echo e($i); ?></a>
                                                    <?php else: ?>
                                                    <a href="<?php echo e($result->url($i)); ?>" class="btn btn-secondary btn-sm"><?php echo e($i); ?></a>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <span>
                                            <?php if($result->hasMorePages()): ?>
                                                 <a href="<?php echo e($result->nextPageUrl()); ?>" rel="next" class="btn btn-secondary btn-sm" ><i class="bx bxs-chevron-right"></i></a>
                                            <?php else: ?>
                                                <span></span>
                                            <?php endif; ?>
                                            </span>
                                        </nav>
                                    </td>
                                </tr>
                                <?php endif; ?>   
                            </table>
                        </div>

                        <?php else: ?>
                            <div class="card">No Data Found...</div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </section>

</main>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<script>


    
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/list.blade.php ENDPATH**/ ?>