<?php



namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\AgentProductList;



class RegisterController extends Controller

{

	public function allAgents(Request $request)

	{

		$agents = DB::connection('mysql')->table('agents')

		          ->get();

		// dd($agents);

		return view('all-agents',compact('agents'));          

	}



	public function register(Request $request, $id='')

	{

		if($id>0){

			$agents = DB::connection('mysql')->table('agents')

					  ->where('id',$id)	

		          	  ->first();

		    $result['id']=$agents->id;      	  

		    $result['name']=$agents->name;

		    $result['email']=$agents->email;

		    $result['password']='';

		    $result['cpassword']='';     	  

		}else{

			$result['id']=0;

			$result['name']='';

		    $result['email']='';

		    $result['password']='';

		    $result['cpassword']='';

		}

		return view('register',compact('result'));

	}



	public function doRegister(Request $request)

	{

		// dd($request->all());

		$id = $request['id'];

		$name = $request['name'];

		$email = $request['email'];

		$password = $request['password'];

		$cpassword = $request['cpassword'];



		$request->validate([

			'name' => 'required',

			'password' => 'min:6',

    		'cpassword' => 'required_with:password|same:password|min:6',

    		'email' => 'required|unique:agents,email,' . $request->post('id'),

		]);



		if($request['id']){

			DB::connection('mysql')->table('agents')

			->where('id',$id)

			->update([

				'name' => $name,

				'email' => $email,

				'password' => Hash::make($password),

				'updated_at' => now()

			]);

			

		}else{

			DB::connection('mysql')->table('agents')->insert([

				'name' => $name,

				'email' => $email,

				'password' => Hash::make($password),

				'created_at' => now(),

				'updated_at' => now()

			]);

		}

		return redirect()->route('all-agents');

		// dd($name);

	}

	public function agentProductList(Request $request){

		$result = DB::table('agent_product_list')->orderby('id','asc')
				  ->join('agents', 'agents.id','=','agent_product_list.agent_id')
				  ->get(['agents.name','agent_product_list.*']);
		return view('agent_product_list',compact('result'));

	}

	public function agentProductAdd(Request $request){

		$agents = DB::table('agents')->get();

		$obj = new AgentProductList;

        if($request->isMethod('POST')){

            $request->validate([
                'agent_id'=>'required',
                'item'=>'required',
                'price'=>'required',
                'gst'=>'required',
                'price_without_gst'=>'required',
                'is_personalized'=>'required'
                ]);

                if($blog = $obj->create([
                    
                    'agent_id' => $request->agent_id,
                    'item' => $request->item,
                    'slug' => $request->slug,
                    'price' => $request->price,
                    'gst' => $request->gst,
                    'price_without_gst' => $request->price_without_gst, 
                    'is_personalized' => $request->is_personalized,

                ]))
              
                {
                    $request->session()->flash('alert-success', 'Agent Product successfully added.');
                    return redirect()->route('agentProductList');
                }else{
                    $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                    return redirect()->back()->with($request->except(['_method', '_token']));
                }

        }
        return view('agent_product_add', ['agents' => $agents, 'request' => $request]);
	}

	public function agentProductEdit($id = null, Request $request)
    {
    	$apl_id = $id;
        $dataDetails  = DB::table('agent_product_list')->where('id',$apl_id)->first();
        $agent=DB::table('agents')->get();
        
        $obj = new AgentProductList;
         
        if($request->isMethod('POST')){
        	// dd('hello');
            
            $request->validate([

            	'agent_id'=>'required',
                'item'=>'required',
                'price'=>'required',
                'gst'=>'required',
                'without_gst'=>'required',
                'is_personalized'=>'required'
            ]);

            $formid = $request->formid;
            //dd($request->item);
            $update_arr['agent_id'] = $request->agent_id;
            $update_arr['item'] = $request->item;
            $update_arr['slug'] = $request->slug;
            $update_arr['price'] = $request->price;
            $update_arr['gst'] = $request->gst;
            $update_arr['price_without_gst'] = $request->without_gst;
            $update_arr['is_personalized'] = $request->is_personalized;
            $update_arr['updated_at'] = date('Y-m-d H:i:s');
            
            if(AgentProductList::where(['id' => $request->formid])->update($update_arr)){
                $request->session()->flash('alert-success', 'Agent product successfully updated.');
                return redirect()->route('agentProductList');
            }else{
                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }
        }
        return view('agent_product_edit', ['agent' => $agent, 'dataDetails' => $dataDetails, 'request' => $request]);
    }

}