@extends('layouts.admin.app')

@section('content')

    <main id="main" class="main">
        <div class="container">
            <form action="{{url('/admin/order/productAssign')}}" method="post">
                    @csrf
                    <table class="table" styla="margin-top:10%;">
                        <thead>
                            <tr>
                                <th>Select Search Type</th>
                                <th>From Date</th>
                                <th>To Date</th>
                                <th>Select the Status</th>
                                <th><th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <select name="search_type" id="search_type" class="form-control" required>
                                        <option value="" selected>Select Search Type</option>
                                        <option value="d_date">Delivery Date</option>
                                        <option value="a_date">Assign Date</option>
                                    </select>
                                </td>
                                <td><input type="date" name="fromDate" id="FromDate" class="form-control" required /></td>
                                <td><input type="date" name="toDate" id="toDate" class="form-control" required /></td>
                                <td>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="" selected>SELECT STATUS</option>
                                        <option value="A">All</option>
                                        <option value="P">PENDING</option>
                                        <option value="PC">PROCESSED</option>
                                        <option value="S">SHIPPED</option>
                                        <option value="D">DELIVERED</option>
                                        <option value="H">HOLD</option>
                                        <option value="CL">CANCELED</option>
                                    </select>
                                </td>
                                <td><button class="btn btn-primary" type="submit">Search</button></td>
                            </tr>
                        </tbody>
                    </table>
            </form>
            <table class="table">
                @if($agent_assigned->isEmpty())
                    No Data Found
                @else
                    <thead>
                        <tr>
                            <th scope="col">Sr No</th>
                            <th scope="col">Assign Order Id</th>
                            <th scope="col">Order id</th>
                            <th scope="col">Agent Name</th>
                            <th scope="col">Product Name</th>
                            <th scope="col">Delivery Date</th>
                            <th scope="col">Delivery Status</th>
                            {{--<th scope="col">Agent Status</th>--}}
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $i = 0; @endphp
                        @foreach($agent_assigned as $agent_assigneds)
                            @php $i++; @endphp
                            <tr>
                                <th scope="row">{{$i}}</th>
                                <td>{{$agent_assigneds->agent_order_id}}</td>
                                <td>
                                    @php
                                        $orderId = null;
                                    @endphp
                                    @foreach($assined as $assineds)
                                        @foreach($orders as $order)
                                            @if($assineds->OID == $order->id)
                                                {{$order->unique_order_id}}
                                                @php
                                                    $orderId = $order->id;
                                                    break 2;
                                                @endphp
                                            @endif
                                        @endforeach
                                    @endforeach
                                </td>
                                <td>
                                    @foreach($agents as $agent)
                                        @if($agent_assigneds->agent_id == $agent->id)
                                            {{ucwords($agent->name)}}
                                            @break
                                        @endif
                                    @endforeach
                                </td>
                                <td>
                                    @php
                                        $printedProducts = [];
                                    @endphp
                                    @foreach($product_maped as $product_mapeds)
                                        @if($product_mapeds->agent_assinged_id == $agent_assigneds->id)
                                            @foreach($agent_product_list as $product)
                                                @if($product->id == $product_mapeds->product_id && !in_array($product->id, $printedProducts))
                                                    {{ ucwords($product->item) }}<br>
                                                    @php
                                                        $printedProducts[] = $product->id; 
                                                    @endphp
                                                @endif
                                            @endforeach
                                        @endif
                                    @endforeach
                                </td>
                                <td>
                                    @php
                                        $founddetails = false;
                                    @endphp
                                    @foreach($order_details as $order_detail)
                                        @if($order_detail->order_id == $agent_assigneds->OID)
                                            {{$order_detail->delivery_date}}
                                            @php
                                                $founddetails = true;
                                                break;
                                            @endphp
                                        @endif
                                    @endforeach
                                </td>
                                <td>
                                    @if($agent_assigneds->status=='P')
                                        <h6><span class="badge bg-danger">PENDING</span></h6>
                                    @elseif($agent_assigneds->status=='PC')
                                        <h6><span class="badge bg-info">ACCEPTED</span></h6>
                                    @elseif($agent_assigneds->status=='CL')
                                        <h6><span class="badge bg-dark">CANCEL</span></h6>
                                    @elseif($agent_assigneds->status=='H')
                                        <h6><span class="badge bg-warning">HOLD</span></h6>
                                    @elseif($agent_assigneds->status=='D')
                                        <h6><span class="badge bg-success">DELIVERED</span></h6>
                                    @elseif($agent_assigneds->status=='S')
                                        <h6><span class="badge bg-primary">SHIPPED</span></h6>
                                    @endif
                                </td>
                                {{--<td>
                                    @if($agent_assigneds->status == "PC" ||$agent_assigneds->status == "CL" ||$agent_assigneds->status == "D" ||$agent_assigneds->status == "S")
                                    <div class="alert alert-primary" role="alert">
                                        Agent Assigned
                                    </div>
                                    @else
                                    <div class="alert alert-danger" role="alert">
                                        Agent Not Assigned Yet
                                    </div>
                                    @endif
                                </td>--}}
                                <td><a href="{{url('/admin/order/assign-order-view')}}/{{encrypt($agent_assigneds->agent_order_id)}}/{{encrypt($agent_assigneds->agent_id)}}" class="btn btn-info btn-sm"><i class="ri-file-edit-fill"></i></a></td>
                            </tr>
                        @endforeach
                    </tbody>
                @endif    
            </table>
            {{-- <a class="btn btn-danger" href="{{url('/admin/order/assign-order-list')}}">Back</a> --}}
        </div>
    </main>

@endsection