@extends('layouts.admin.app')
@section('content')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    {{--<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/datatable-checkbox-init.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/multicheck/jquery.multicheck.js') }}"></script>
    <script src="{{ asset('admin/assets/extra-libs/DataTables/datatables.min.js') }}"></script>



    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/extra-libs/multicheck/multicheck.css') }}">
    <link href="{{ asset('admin/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet">


    <script src="https://www.giftbasketworldwide.com/js/admin/misc.js"></script>
    <script src="https://www.giftbasketworldwide.com/js/admin/tinymce.min.js"></script>--}}



    <main id="main" class="main">

        @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA' || Session::get('permissions.user_type') == 'OP')

			<div class="page-breadcrumb">

			    <div class="row">

			        <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">

			            <h4 class="page-title">

			                {{--<a href="{{ route('admin.product.dbfldupdate') }}"><i class="fas fa-server fawsm"></i></a>--}}

			                 {{strtoupper($site_name)}} Product Sort Order

			            </h4>

			            <div class="ml-auto text-right">

			                <a href="{{ route('admin.product.list') }}" class="btn btn-outline-info">Back</a>

			            </div>

			        </div>

			    </div>

			</div>



			<div class="container-fluid">

			    <div class="row">

			        <div class="col-12">

			            <div class="card">

			                <div class="card-body">

			                    @foreach (['danger', 'warning', 'success', 'info'] as $msg)

			                        @if(Session::has('alert-' . $msg))

			                            <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>

			                        @endif

			                    @endforeach

			                    <!-- <h5 class="card-title">Product</h5> -->



			                    <div class="product-search">

			                        <div class="prod-search-title">

			                            <h5 class="card-title">

			                                Products

			                            </h5>

			                        </div>

			                        <div class="prod-search-body">

			                            <form action="" method="post" enctype="multipart/form-data">

			                                @csrf

			                                <select class="form-control" required data-actions-box="true" id="category_ids" name="category_id" onchange="this.form.submit()">

								

												<option value="">Choose Category</option>

											 	<?php foreach ($category_list as $key => $category) { ?>

											   		<option value="<?php echo $key; ?>" <?php if($request->category_id == $key){?> selected <?php } ?>><?php echo $category; ?></option>

											 	<?php } ?>

										   	</select>

			                                

			                                <button class="btn btn-primary" type="submit" ><i class="fa fa-search"></i></button>

			                            </form>                     

			                        </div>

			                    </div>

			                    

			                    

			                    <div class="table-responsive">

			                        <table id="zero_config" class="table table-striped table-bordered">

			                            <thead>

			                                <tr>

			                                    <th style="width: 5%"><b>No.</b></th>

			                                    <th style="width: 10%"><b>Image</b></th>

			                                    <th style="width: 20%"><b>SKU</b></th>

			                                    <th style="width: 25%"><b>Title</b></th>

			                                    <th style="width: 20%"><b>Price</b></th>

			                                    <th style="width: 20%"><b>{{strtoupper($site_name)}} Sort Order</b></th>

			                                </tr>

			                            </thead>

			                            <tbody>



			                            	<?php $i = ($products->currentPage() - 1) * $products->perPage() + 1; ?> 

			                            	

							            	@if($products->count() == 0)

												<tr>

													<td colspan="6">No records found!</td>

												</tr>

							            	@endif



			                                @foreach($products as $key => $product)

			                                	

												<tr>

													<td>{{ $i + $key }}</td>

													<td>

														@php 

				                                            $imagename = App\Http\Helper1::get_image($product->pid);

				                                        @endphp



				                                        @if(isset($imagename) && $imagename->name != null )

				                                            <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/{{$imagename->name}}" style="width:90px; height: auto;">  

				                                        @else

				                                            <img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/no_image.jpg" style="width:110px; height: auto;">

				                                        @endif

													</td>

													<td>{{ $product->pid }} / <strong style="color:#2962ff;">{{ $product->fnid }}</strong><br><!-- {{ $product->slug }} --></td>

													<td>{{ $product->product_name }}</td>

													<td>

														USD {!! $product->price !!}

													</td>

													<td class="sortcontainer-td">

														<div class="sortcontainer">

															<input type="number" id="sort{{ $product->pcid }}" value="{{ $product->{'sort_order_' . $site_name} }}" data-site="{{ $site_name }}" style="width: 90px;">

															<i class="fas fa-sync productSortbtn" data-id="{{ $product->pcid }}" data-site="{{ $site_name }}"></i>

														</div>

														<span class="updatemsg{{ $product->pcid }}"></span>

													</td>

												</tr>

											@endforeach

			                            </tbody>

			                        </table>

			                    </div>

			                    

			                    <div style="font-size: 15px; text-align: left; display: inline;">

						     		Showing {{ $products->firstItem() }} to {{ $products->lastItem() }} of {{ $products->total() }} entries

						     	</div>

						      	<div class="text-center-pagination pagination" style="float:right;">

									{!! $products->withQueryString()->links('pagination::bootstrap-4') !!}

								</div>

					



			                </div>

			            </div>

			        </div>

			    </div>

			</div>

		@endif    

    </main><!-- End #main -->





<script>

    



	/******auto refresh HTML only if there has been no activity on a page******/



	var inactivityTimeout;

	var inactivityDuration = 600000; // 10 minutes in milliseconds



	function resetInactivityTimer() {

	    clearTimeout(inactivityTimeout);

	    inactivityTimeout = setTimeout(refreshPage, inactivityDuration);

	}



	function refreshPage() {

	    location.reload();

	}



	// Event listeners to reset the inactivity timer

	document.addEventListener('mousemove', resetInactivityTimer);

	document.addEventListener('keydown', resetInactivityTimer);

	document.addEventListener('scroll', resetInactivityTimer);



	// Initial setup of the inactivity timer

	resetInactivityTimer();



	/*-------------auto refresh HTML only if there has been no activity on a page--------------*/	

	const baseSortUpdateUrl = "{{ url('admin/product/product_sortorder_update') }}";


	$('.productSortbtn').click(function(){

		var sortID = $(this).data("id")

		var sortNO = $('#sort'+sortID).val();
		var siteName = $(this).data('site');

		var finalUrl = baseSortUpdateUrl + '/' + (siteName);

		$('.updatemsg'+sortID).html('<div class="loader"></div>')

		//alert(sortNO)

		$.ajaxSetup({

	        headers: {

	            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

	        }

	    });

	    $.ajax({

	        url: finalUrl,

	        method: 'POST',

	        data: {

	            sortID: sortID,

	            sortNO: sortNO

	        },

	        success: function(response){

	            //console.log(data);

	            response = JSON.parse(response);

	            if(response.status == "success"){

	              	//window.location.reload();

	              	$('.updatemsg'+sortID).html('')

	              	$('.updatemsg'+sortID).html("Update Successfully..");

	              	setTimeout(function(){ $('.updatemsg'+sortID).html(""); }, 2000);

	            }else{

	            	// $('#warning-msg').html("Access code didn't match");

					// setTimeout(function(){ $('#warning-msg-plpr').html(""); }, 3000);

					// return false;

	            }

	        }

	    });       

	});



    

</script>



<style type="text/css">

	.product-search{display: flex;justify-content: space-between; align-items: center; margin-bottom: 20px;}

    .prod-search-title{width: 10%;}

    .prod-search-body{width: 80%;}

    .prod-search-body form{display: flex;justify-content: end;gap: 3px;}

    .prod-search-body form select, .prod-search-body form input{width: 32%;}

    .fawsm{color: #3e5569;}

	.sortcontainer-td{position: relative;}

	.sortcontainer{margin-bottom: 10px;}

	.sortcontainer input{width: 90px;padding: 8.2px;border: 2px solid #1f262d;border-top-left-radius: 4px;border-bottom-left-radius: 4px;}

	.sortcontainer i{border: 2px solid #1f262d;padding: 11.7px;margin-left: -4px;color: #fff;background-color: #1f262d;border-top-right-radius: 4px;border-bottom-right-radius: 4px;}



	/* HTML: <div class="loader"></div> */

	/*.loader {

	  width: 25px;

	  aspect-ratio: 4;

	  background: radial-gradient(circle closest-side,#eb5656 90%,#0000) 0/calc(100%/3) 100% space;

	  clip-path: inset(0 100% 0 0);

	  animation: l1 1s steps(4) infinite;

	}

	@keyframes l1 {to{clip-path: inset(0 -34% 0 0)}}*/



	/*  HTML: <div class="loader"></div> 

		https://css-loaders.com/

	*/

	.loader {

	  width: 85px;

	  height: 12px;

	  -webkit-mask:linear-gradient(90deg,#000 70%,#0000 0) 0/20%;

	  background:

	   linear-gradient(#1f262d 0 0) 0/0% no-repeat

	   #ddd;

	  animation: l4 2s infinite steps(6);

	}

	@keyframes l4 {

	    100% {background-size:120%}

	}



	

</style>









@endsection