<?php if($agents->agent_type == 'H'): ?>
    <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>COF-challan</title>
            <style>  
                @font-face {
                    font-family: 'noto_sans_devanagari';
                    src: url("<?php echo e(storage_path('fonts/NotoSansDevanagari-Regular.ttf')); ?>") format('truetype');
                }
                body {
                    font-family: 'noto_sans_devanagari', sans-serif;
                    /*font-size: 15px*/
                }        
                td{line-height: 14px;font-size: 12px;}
                input, label{margin: 0;padding: 0;}

            </style>
        </head>
        <body style="margin: 0;padding: 0;/*font-family: Arial, Helvetica, sans-serif;*/">
            <!--Header-->   
            <div style="padding: 25px 5px; color: #333;background: #fff9c35c;margin: 0 5px;">
                <table style="border-collapse: collapse;width: 100%;">
                    <tr>
                        <td style="font-size: 25px;"><strong>Right Shopping Pvt. Ltd.</strong></td>
                        <td style="text-align: right;font-size: 14px;">GST No. 19AACCC3182E1ZU</td>
                    </tr>
                </table>
            </div>
            <!--Order Details Table-->
            <div style="margin: 0 5px;">
                <table style="border-collapse: collapse;width: 100%;">
                    <tr>
                        <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Order Number:</td>
                        <td style="border: 1px solid #ccc;padding-left: 5px;">
                            
                            <?php echo e($agent_assinged->agent_order_id); ?>

                        </td>
                    </tr>
                    <tr>
                        <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Order Date:</td>
                        <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e(date('jS M, Y' , strtotime($orders->purchase_date))); ?></td>
                    </tr>
                    <tr>
                        <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Delivery Date:</td>
                        <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e(date('jS M, Y' , strtotime($agent_assinged->delivery_date))); ?></td>
                    </tr>
                    <tr>
                        <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Time:</td>
                        <td style="border: 1px solid #ccc; padding-left: 5px;"><?php echo e($agent_assinged->delivery_time); ?></td>
                    </tr>
                    <tr>
                        <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Items:</td>
                        <td style="border: 1px solid #ccc;padding-left: 5px;height: 100px;vertical-align: top;">
                            <?php $__currentLoopData = $agent_product_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($product->agent_id == $agentId || $product->agent_id == 1): ?>
                                    <?php echo e(ucwords($product->item)); ?> <span style="font-weight: 600;font-size: 12px;padding-left: 5px;">(Qty:<?php echo e($product->qty); ?>)</span>,
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Amount:</td>
                        <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e($agent_assinged->totalPrice); ?></td>
                    </tr>
                    <tr>
                        <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Location:</td>
                        <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo $orders->delivery_city; ?> - <?php echo $orders->delivery_pincode; ?></td>
                    </tr>
                    <tr>
                        <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Special Instructions:</td>
                        <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e($orders_Msg->sender_special_instruction); ?></td>
                    </tr>   
                    <?php
                        $orderPlacedInfo = App\Http\Helper1::get_orderPlacedInfo($agent_assinged->OID);
                    ?>         
                    <tr>
                        <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Placed By:</td>
                        <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e($orderPlacedInfo->name); ?></td>
                    </tr>
                </table>
            </div>
            <!--Divider-->    
            <table style="margin: 0;border-collapse: collapse;width: 100%;">
                <tr>
                    <td style="padding: 0;margin: 0;"><img style="width: 22px; height: 26px; padding-top: 0px;" src="<?php echo e(public_path('images_hand/scissor.jpg')); ?>" alt="scissor"></td>
                    <td style="width: 99%;padding: 0;margin: 0;"><hr style="border: 1px dashed #808080 !important;"></td>
                </tr>
            </table>
            <!--Challan-->
            <?php
            $bgChallan = public_path('images_hand/watermark-new.webp');
            ?>
            <div style="background-color: #ffffff !important;border: 1px solid #ccc;padding: 5px;margin: 0 5px;width: auto;background-image: url('file://<?php echo e($bgChallan); ?>');background-repeat: no-repeat;background-position: right;height: auto;background-size: 100% 100%;height: 320px;">
                <!-- <div>
                    <img src="./images/watermark.webp" alt="banner" style="width: 100%; height: 390px; object-fit: contain; object-position: top;">
                </div> -->
                <div>
                    <div style="margin: 0;text-align: left;">
                        <div style="font-weight: 600; font-size: 16px;margin: 0;padding: 5px 0;">Right Shopping Pvt. Ltd. - Delivery Challan</div>            
                    </div>
                    <table style="margin: 0;border-collapse: collapse;width: 100%;font-size: 12px;">
                        <tr>
                            <td style="font-weight: bold;white-space: nowrap;width: 22%;">Order No :</td>
                            <td>
                                <?php echo e($agent_assinged->agent_order_id); ?>

                                
                            </td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;white-space: nowrap;width: 22%;">Delivery at :</td>
                            <td><?php echo $orders->delivery_address; ?>, <?php echo $orders->delivery_city; ?> - <?php echo $orders->delivery_pincode; ?>  - <?php echo $orders->delivery_state; ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;white-space: nowrap;width: 22%;">Location Type :</td>
                            <td>Residence</td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;white-space: nowrap;width: 22%;font-size: 13px;">City :</td>
                            <td><?php echo $orders->delivery_city; ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;white-space: nowrap;width: 22%;font-size: 13px;">Pincode :</td>
                            <td><?php echo $orders->delivery_pincode; ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;white-space: nowrap;width: 22%;font-size: 13px;">Phone No. :</td>
                            <td>91-<?php echo $orders->delivery_mobile; ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;white-space: nowrap;width: 22%;font-size: 13px;">Items :</td>
                            <td>
                                <?php $__currentLoopData = $agent_product_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($product->agent_id == $agentId || $product->agent_id == 1): ?>
                                        <?php echo e(ucwords($product->item)); ?>-(<?php echo e($product->qty); ?>),
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                        </tr>
                        <tr style="line-height: 35px;">
                            <td style="font-size: 14px;font-weight: 600;">Your Remarks:</td>
                        </tr>
                        <tr>
                            <td style="white-space: nowrap; line-height: 1.5;">
                                <span style="display: inline-block; vertical-align: middle; margin-right: 20px;">
                                    <input type="checkbox" name="very-good" style="vertical-align: middle;">
                                    <label for="very-good" style="vertical-align: middle;">Very Good</label>
                                </span>

                                <span style="display: inline-block; vertical-align: middle; margin-right: 20px;">
                                    <input type="checkbox" name="good" style="vertical-align: middle;">
                                    <label for="good" style="vertical-align: middle;">Good</label>
                                </span>

                                <span style="display: inline-block; vertical-align: middle;">
                                    <input type="checkbox" name="poor" style="vertical-align: middle;">
                                    <label for="poor" style="vertical-align: middle;">Poor</label>
                                </span>
                            </td>
                        </tr>
                    </table>
                    <div style="font-size: 12px;padding: 10px 0 30px;">**This is a Prepaid Gift. Don't pay anything to delivery boy. Report us if asked for payment.</div>
                    <table style="width: 100%;">
                        <tr>
                            <td style="text-align: left;">
                                <div style="display: inline-block; border-top: 1px dashed #000; padding-top: 2px; font-size: 13px;"> Receiver's Name & Signature </div>
                            </td>
                            <td style="text-align: right;">
                                <div style="display: inline-block; border-top: 1px dashed #000; padding-top: 2px; font-size: 13px;">
                                    Date of Delivery & Time
                                </div>
                            </td>
                        </tr>
                    </table>    
                </div>
            </div>
            <!--Divider-->    
            <table style="margin: 0;border-collapse: collapse;width: 100%;">
                <tr>
                    <td style="padding: 0;margin: 0;"><img style="width: 22px; height: 26px; padding-top: 0px;" src="<?php echo e(public_path('images_hand/scissor.jpg')); ?>" alt="scissor"></td>
                    <td style="width: 99%;padding: 0;margin: 0;"><hr style="border: 1px dashed #808080 !important;"></td>
                </tr>
            </table>
            <!--Message Card-->
            <?php
            $bg = public_path('images_hand/gift-banner.webp');
            ?>
            <div style="width: 100%;background-image: url('file://<?php echo e($bg); ?>'); background-size: contain;background-position: left;height: 200px;background-repeat: no-repeat;">        
                <!-- <div style="height: 0;width: 100%;">
                    <img src="./images/gift-banner.webp" alt="gft-bnr" style="width: auto;height: auto;object-fit: contain;object-position: left;">
                </div> -->
                <table>
                    <tr>
                        <td style="width: 30%;padding-left: 8rem;"><img src="<?php echo e(public_path('images_hand/chennai_logo_new.png')); ?>" alt="logo" style="height: auto;width: 170px;object-fit: contain;"></td>
                        <td style="width: 70%;padding-left: 4rem;">
                            <div>
                                <div style="font-size: 15px;">
                                    <p style="line-height: 22px;font-weight: bold;">To <?php echo e($orders->delivery_user_name); ?>,</p>                    
                                </div>
                                <p style="font-size: 15px;"><?php echo nl2br(e($orders_Msg->sender_message ?? '')); ?>

                                    
                                </p>
                                <p style="font-weight: bold;text-align: right;font-size: 15px;line-height: 22px;">-<?php echo e($orders_Msg->sender_name); ?></p>
                            </div>
                        </td>
                    </tr>
                    
                    
                </table>
            </div>
            
        </body>
    </html>
<?php else: ?>
<!--COF Courier Challan-->

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>COF-CourierChallan</title>
        <style>      
            @font-face {
                font-family: 'noto_sans_devanagari';
                src: url("<?php echo e(storage_path('fonts/NotoSansDevanagari-Regular.ttf')); ?>") format('truetype');
            }
            body {
                font-family: 'noto_sans_devanagari', sans-serif;
                /*font-size: 15px*/
                }  
            td{line-height: 14px;font-size: 12px;}
            input, label{margin: 0;padding: 0;}
            .courier-challan { width: 100%; height: auto; border: 1px dashed #ccc; padding: 10px; font-family: sans-serif; font-size: 14px; }
            .part1, .part2 { width: 49%; display: inline-block; vertical-align: top; text-align: center; }
            .top-head { font-size: 15px; line-height: 22px; padding: 3px 0; font-weight: bold; text-align: center; }
            .subhead { font-size: 12px; padding-bottom: 12px; font-weight: bold; text-align: center; }
            .vertical-divider { display: inline-block; width: 2%; text-align: center; font-size: 12px; writing-mode: vertical-rl; padding: 0 5px; }
            .part1-details { text-align: left; padding: 0 5px; }
            .det-sec-1 { width: 100%; margin-bottom: 10px; }
            .det-sec-2 { font-size: 14px; padding-top: 5px; text-align: right; }
            .bar-code img { width: 100px; height: auto; }
            .courier-name { font-size: 15px; font-weight: bold; }
            .order-no { font-weight: bold; font-size: 15px; padding-bottom: 3px; }
            .sender-name-courier { font-size: 14px; font-weight: normal; padding-bottom: 3px; }
            .signature-part { text-align: right; padding-top: 10px; font-size: 13px; }
            .signature-part div { border-top: 1px dashed #333; width: auto; display: inline-block; padding-top: 5px; margin-top: 20px; }

        </style>
    </head>
    <body style="margin: 0;padding: 0;/*font-family: Arial, Helvetica, sans-serif;*/">
        <!--Header-->   
        <div style="padding: 25px 5px; color: #333;background: #fff9c35c;margin: 0 5px;">
            <table style="border-collapse: collapse;width: 100%;">
                <tr>
                    <td style="font-size: 25px;"><strong>Right Shopping Pvt. Ltd.</strong></td>
                    <td style="text-align: right;font-size: 14px;">GST No. 19AACCC3182E1ZU</td>
                </tr>
            </table>
        </div>
        <!--Order Details Table-->
        <div style="margin: 0 5px;">
            <table style="border-collapse: collapse;width: 100%;">
                <tr>
                    <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Order Number:</td>
                    <td style="border: 1px solid #ccc;padding-left: 5px;">
                        <?php echo e($agent_assinged->agent_order_id); ?>

                        
                    </td>
                </tr>
                <tr>
                    <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Order Date:</td>
                    <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e(date('jS M, Y' , strtotime($orders->purchase_date))); ?></td>
                </tr>
                <tr>
                    <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Delivery Date:</td>
                    <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e(date('jS M, Y' , strtotime($agent_assinged->delivery_date))); ?></td>
                </tr>
                <tr>
                    <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Time:</td>
                    <td style="border: 1px solid #ccc; padding-left: 5px;"><?php echo e($agent_assinged->delivery_time); ?></td>
                </tr>
                <tr>
                    <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Items:</td>
                    <td style="border: 1px solid #ccc;padding-left: 5px;height: 100px;vertical-align: top;">
                        <?php $__currentLoopData = $agent_product_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($product->agent_id == $agentId || $product->agent_id == 1): ?>
                                <?php echo e(ucwords($product->item)); ?> <span style="font-weight: 600;font-size: 12px;padding-left: 5px;">(Qty:<?php echo e($product->qty); ?>)</span>,
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
                <tr>
                    <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Amount:</td>
                    <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e($agent_assinged->totalPrice); ?></td>
                </tr>
                <tr>
                    <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Location:</td>
                    <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo $orders->delivery_city; ?> - <?php echo $orders->delivery_pincode; ?></td>
                </tr>
                <tr>
                    <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Special Instructions:</td>
                    <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e($orders_Msg->sender_special_instruction); ?></td>
                </tr>   
                <?php
                    $orderPlacedInfo = App\Http\Helper1::get_orderPlacedInfo($agent_assinged->OID);
                ?>             
                <tr>
                    <td style="font-weight: bold;white-space: nowrap;width: 22%;border: 1px solid #ccc;padding-left: 5px;">Placed By:</td>
                    <td style="border: 1px solid #ccc;padding-left: 5px;"><?php echo e($orderPlacedInfo->name); ?></td>
                </tr>
            </table>
        </div>
        <!--Divider-->    
        <table style="margin: 0;border-collapse: collapse;width: 100%;">
            <tr>
                <td style="padding: 0;margin: 0;"><img style="width: 22px; height: 26px; padding-top: 0px;" src="<?php echo e(public_path('images_hand/scissor.jpg')); ?>" alt="scissor"></td>
                <td style="width: 99%;padding: 0;margin: 0;"><hr style="border: 1px dashed #808080 !important;"></td>
            </tr>
        </table>
        <!--Courier Challan-->
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <!-- LEFT PART -->

                <td style="width: 49%; vertical-align: top; border: 1px dashed #aaa; padding: 10px;">            
                    <div class="top-head">Right Shopping Pvt. Ltd.</div>
                    <div class="subhead">Delivering Gifts Since 2001</div>                            
                    <div style="font-size: 13px; padding-bottom: 5px;font-weight: 500;">Ref No: <?php echo e($orders->unique_order_id); ?></div>
                    <div style="font-size: 13px; padding-bottom: 10px;font-weight: 500;">Couriered By: Right Shopping Pvt. Ltd.</div>
                    <div style="font-size: 12px;line-height: 14px;">
                        <div><span style="font-weight: 500; font-size: 13px;">Sender:</span> <?php echo e($orders_Msg->sender_name); ?></div>
                        <div style="font-weight: 600;">To:</div>
                        <div>Recipient's Name - <?php echo e($orders->delivery_user_name); ?></div>
                        <div>Address - <?php echo $orders->delivery_address; ?>-<?php echo $orders->delivery_pincode; ?>, <?php echo $orders->delivery_state; ?></div>
                        <div>Location Type - Residence</div>
                        <div>City & Pincode - <?php echo $orders->delivery_city; ?>-<?php echo $orders->delivery_pincode; ?></div>
                        <div>Phone No. - 91-9256434619</div>
                    </div>
                    <?php
                    $barcode = "https://barcode.tec-it.com/barcode.ashx?data={{ $orders->unique_order_id }}&code=Code128&translate-esc=true";
                    ?>
                    <table style="border-collapse:collapse;width: 100%;">
                        <tr>
                            <td>
                                <div style="text-align: left; padding-top: 10px;">
                                     <img src="data:image/png;base64,<?php echo e(DNS1D::getBarcodePNG($orders->unique_order_id, 'C39',1,33)); ?>" alt="Barcode" style="width: 100px;height: 30px;">
                                    <div style="font-size: 14px;"><?php echo e($orders->unique_order_id); ?></div>
                                </div>
                            </td>
                            <td>
                                <div style="text-align: right; padding-bottom: 10px;"> <img src="data:image/png;base64,<?php echo e(DNS1D::getBarcodePNG($orders->unique_order_id, 'C39',1,33)); ?>" alt="barcode" style="width: 100px;height: 30px;"> </div>
                            </td>
                        </tr>
                    </table>
                    
                </td>

                <!-- RIGHT PART -->        

                <td style="width: 49%; vertical-align: top; border: 1px dashed #aaa; padding: 10px;">
                    <div class="top-head">Right Shopping Pvt. Ltd.</div>
                    <div style="font-size: 12px; font-weight: bold; padding-bottom: 15px;text-align: center;">
                        Order No: <?php echo e($agent_assinged->agent_order_id); ?>

                        
                    </div>

                    <div style="line-height: 14px;">
                        <div style="font-weight: bold; padding-bottom: 5px;font-size: 13px;">
                            <div>To</div>
                            <div>Dear Sir / Madam,</div>
                        </div>

                        <div style="padding-bottom: 10px;font-size: 12px;">
                            This gift pack is to be delivered at <?php echo $orders->delivery_city; ?>-<?php echo $orders->delivery_pincode; ?>. It contains gift items  for personal use of <?php echo e($orders->delivery_user_name); ?>.
                        </div>

                        <div style="text-align: center; font-size: 12px; padding: 15px 0;">
                            <div style="font-weight: bold;">"THIS IS GIFT ITEM FOR PERSONAL USE ONLY & IS NOT FOR SALE"</div>
                            <div style="text-decoration: underline; text-underline-offset: 2px; padding-top: 15px;font-size: 12px;">
                                This is a Prepaid Gift. Don't pay anything to delivery boy. Report us if asked for payment.
                            </div>
                        </div>

                        <div style="font-weight: bold; text-align: right; padding-top: 20px;font-size: 13px;">
                            <div>Thanking You,</div>
                            <div>Right Shopping Pvt. Ltd.</div>
                        </div>
                    </div>
                </td>
            </tr>
        </table>

        <!--Divider-->    
        <table style="margin: 0;border-collapse: collapse;width: 100%;">
            <tr>
                <td style="padding: 0;margin: 0;"><img style="width: 22px; height: 26px; padding-top: 0px;" src="<?php echo e(public_path('images_hand/scissor.jpg')); ?>" alt="scissor"></td>
                <td style="width: 99%;padding: 0;margin: 0;"><hr style="border: 1px dashed #808080 !important;"></td>
            </tr>
        </table>

        <!--Message Card-->
        <?php
        $bg = public_path('images_courier/gift-banner.webp');
        ?>
        <div style="width: 100%;background-image: url('file://<?php echo e($bg); ?>'); background-size: contain;background-position: left;height: 200px;background-repeat: no-repeat;">        
            <!-- <div style="height: 0;width: 100%;">
                <img src="./images/gift-banner.webp" alt="gft-bnr" style="width: auto;height: auto;object-fit: contain;object-position: left;">
            </div> -->
            <table>
                <tr>
                    <td style="width: 30%;padding-left: 8rem;"><img src="<?php echo e(public_path('images_courier/chennai_logo_new.png')); ?>" alt="logo" style="height: auto;width: 170px;object-fit: contain;"></td>
                    <td style="width: 70%;padding-left: 4rem;">
                        <div>
                            <div style="font-size: 15px;">
                                <p style="line-height: 22px;font-weight: bold;">To <?php echo e($orders->delivery_user_name); ?>,</p>                    
                            </div>
                            <p style="font-size: 15px;"><?php echo nl2br(e($orders_Msg->sender_message ?? '')); ?>

                                
                            </p>
                            <p style="font-weight: bold;text-align: right;font-size: 15px;line-height: 22px;">-<?php echo e($orders_Msg->sender_name); ?></p>
                        </div>
                    </td>
                </tr>
                
                
            </table>
        </div>
        
    </body>
</html>

<?php endif; ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/order/invoice.blade.php ENDPATH**/ ?>