@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if($agent)
        {{-- <div style="text-align: center; margin-top: -13px;">
            <h2>Agent {{$agent->name}}</h2>
        </div>   --}}  
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <div class="card-body">

                            {{-- <h4 class="card-title">Select an Agent</h4> --}}

                            <div class="row mb-3">
                              <label class="col-sm-2 col-form-label"><b>Choose Agent</b></label>
                              <div class="col-sm-10">
                                <select id="agent_id" name="agent_id" type="text" class="form-control"
                                    aria-required="true" aria-invalid="false" required>
                                    <option value="">Select Agent</option>
                                    @foreach ($agents as $list)
                                        @if($agent_id == $list->id)
                                            <option selected value="{{ encrypt($list->id) }}">
                                        @else
                                            <option value="{{ encrypt($list->id) }}">
                                        @endif        
                                            {{ $list->name }}</option>    
                                    @endforeach
                                </select>
                              </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Agent :: {{ucwords($agent->name)}}</h4>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            @foreach (['danger', 'warning', 'success', 'info'] as $msg)
                                @if(Session::has('alert-' . $msg))
                                    <div class="alert alert-{{ $msg }} alert-dismissible fade show" role="alert">
                                        {{ Session::get('alert-' . $msg) }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @endif
                            @endforeach
                                {{--<h5 class="card-title">{{$agent->name}} Agent</h5>--}}
                            <div class="col-12 d-flex no-block align-items-center justify-content-between mb-2">
                                <h5>Agent Delivery Charges</h5>
                            </div>
                            
                            @if(count($agent_delivery_charge)>0)
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Standard Delivery Charge</th>
                                                <th>Midnight Delivery Charge</th>
                                                <th>Express Delivery Charge</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($agent_delivery_charge as $index => $data)
                                            <tr>
                                                <td>Rs. {{ $data->s_delivery }}</td>
                                                <td>Rs. {{ $data->m_delivery }}</td>
                                                <td>Rs. {{ $data->e_delivery }}</td>
                                                <td>
                                                    <a href ="{{url('admin/agent/delivery-charge-edit')}}/{{encrypt($data->id)}}"><i class="fas fa-edit"></i></a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="card p-3">No Agent's Delivery Charges Found...</div>
                            @endif

                            
                            @if(count($result) > 0)

                            <div class="col-12 d-flex no-block align-items-center justify-content-between mb-2">
                                <h5 class="page-title">
                                    Agent Product List
                                </h5>
                                <div class="ml-auto text-right">
                                    <button id="btn_exportExcel" class="btn btn-primary">Import in Excel</button>
                                    <a href="{{url('/admin/agent/agent-product-add')}}/{{encrypt($agent_id)}}" class="btn btn-success">Add Product</a>
                                </div>
                            </div>

                                <div class="table-responsive">
                                    <table id="zero_config" class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>No.</th>
                                                <th>Title</th>
                                                <th>Price</th>
                                                <th>Gst</th>
                                                <th>Without Gst</th>
                                                <th>Personalized</th>
                                                <th>Created Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($result as $index => $data)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{{ $data->item }}</td>
                                                <td>{{ $data->price }}</td>
                                                <td>{{ $data->gst }}</td>
                                                <td>{{ $data->price_without_gst }}</td>
                                                <td>{{ $data->is_personalized }}</td>
                                                <td>{{ date('d-m-Y', strtotime($data->created_at)) }}</td>
                                                <td>
                                                    <a href="{{url('admin/agent/agent-product-edit')}}/{{encrypt($data->id)}}"><i class="fas fa-edit"></i></a>
                                                    {{-- <a onclick="return confirm('Are you sure you want to delete the Product?')" href="{{ route('admin.agent.agentProductDelete', base64_encode($data->id)) }}"><i class="fas fa-trash-alt"></i>    
                                                    </a> --}}
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="card p-3">No Data Found...</div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        No Data Found...
    @endif    
            
</main><!-- End #main -->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <script>

        document.addEventListener("DOMContentLoaded", function () {
            const table = document.querySelector("#zero_config");
            const dataTable = new simpleDatatables.DataTable(table, {
                sortable: true,
                fixedHeight: true,
                columns: [
                    { select: 6, type: "date", sort: "desc" } // Sort by the 6th column (index 5) descending
                ]
            });
        });


        $(document).ready(function () {
            $('#agent_id').on('change', function () {
                var agentId = $(this).val();
                if (agentId) {
                    // Replace with your desired base URL
                    let url = "{{ url('/admin/agent/agent-product-list') }}/" + agentId;
                    window.location.href = url; // Redirect to the link
                } else {
                    alert("No agent found");
                }
            });

            $('#btn_exportExcel').click(function() {
                var agent_id = $('#agent_id').val(); 
                if (agent_id) {
                    // Replace with your desired base URL
                    let url = "{{ url('/admin/agent/agent-product-list/import-excel') }}/" + agent_id;
                    window.location.href = url; // Redirect to the link
                } else {
                    alert("No agent found");
                }
            });

        });

    </script>

@endsection

