@extends('layouts.admin.app')
@section('content')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/css/bootstrap-select.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.18/js/bootstrap-select.min.js"></script>

<main id="main" class="main">
    @if( Session::get('permissions.user_type') == 'A' || Session::get('permissions.user_type') == 'SA')
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-12 d-flex no-block align-items-center justify-content-between px-4 mb-2">
                    <h4 class="page-title">Edit Coupon</h4>
                    <div class="ml-auto text-right">
                        <a href="{{url('admin/coupon/list/')}}/{{$siteId}}" class="btn btn-outline-info">Back</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
		    <div class="row">
		        <div class="col-12">
		            <div class="card">
		                @foreach (['danger', 'warning', 'success', 'info'] as $msg)
		                    @if(Session::has('alert-' . $msg))
		                        <h4 class="font-weight-light alert alert-{{ $msg }}">{{ Session::get('alert-' . $msg) }}</h4>
		                    @endif
		                @endforeach
		                <form action="{{route('admin.coupon.edit', base64_encode($dataDetails->id))}}" method="POST" class="form-horizontal" id="formadd">
		                    @csrf
		                    <input type="hidden" name="formid" value="<?php echo $dataDetails->id; ?>">
		                    <input type="hidden" name="site_id" value="<?php echo $dataDetails->site_id; ?>">
		                    <div class="card-body">
		                        <h4 class="card-title">Coupon Edit</h4>

		                        <div class="form-group m-t-20">
		                            <label>Coupon Code<span style="color:red;">*</span></label>
		                            <input type="text" class="form-control" id="coupon_code" name="coupon_code" placeholder="Enter Coupon Code" value="{{$dataDetails->coupon_code}}" required>
		                        </div>
		                        
		                        <div class="form-group m-t-20">
		                            <label>Discount Type<span style="color:red;">*</span></label><br>
		                            <span><input type="radio" name="discount_type" class="discount_type" value="F" @if($dataDetails->type=="F") checked @endif>Flat</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		                            <span><input type="radio" name="discount_type" class="discount_type" value="P" @if($dataDetails->type=="P") checked @endif>Percent</span>
		                        </div>

		                        <div class="form-group m-t-20">
		                            <label>Related To<span style="color:red;">*</span></label><br>
		                            <span><input type="radio" name="related_to" class="related_to" value="C" @if($dataDetails->related_to=="C") checked @endif>Cart</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		                            <span><input type="radio" name="related_to" class="related_to" value="U" @if($dataDetails->related_to=="U") checked @endif>User</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		                            <span><input type="radio" name="related_to" class="related_to" value="O" @if($dataDetails->related_to=="O") checked @endif>Occasion</span>
		                        </div>

		                        <div class="form-group m-t-20">
		                            <label>Amount<span style="color:red;">*</span></label>
		                            <input type="text" class="form-control" id="amount" name="amount" placeholder="Amount" value="{{$dataDetails->amount}}" required>
		                        </div>
		                       
		                        @php
		                            $str = $dataDetails->start_date;
		                            $arr = explode(" ",$str);
		                            $str1 = $dataDetails->end_date;
		                            $arr1 = explode(" ",$str1);
		                        @endphp
		                        <div class="form-group m-t-20">
		                            <label>Start Date<span style="color:red;">*</span></label>
		                            <input type="datetime-local" class="form-control" id="start_date" name="start_date" placeholder="Start Date" value="{{$arr[0]}} {{$arr[1]}}" required>
		                        </div>
		                        
		                        <div class="form-group m-t-20">
		                            <label>End Date<span style="color:red;">*</span></label>
		                            <input type="datetime-local" class="form-control" id="end_date" name="end_date" placeholder="End Date" value="{{$arr1[0]}} {{$arr1[1]}}" required>
		                        </div>
		                        
		                        <div class="form-group m-t-20">
		                            <label>Minimum Cart Amount<span style="color:red;">*</span></label>
		                            <input type="text" class="form-control" id="minimum_cart_amount" name="minimum_cart_amount" placeholder="End Date" value="{{$dataDetails->minimum_cart_amount}}" required>
		                        </div>
		                        
		                    </div>
		                    <div class="border-top">
		                        <div class="card-body">
		                            <input class="btn btn-primary" type="submit" value="UPDATE">
		                        </div>
		                    </div>
		                </form>
		            </div>
		        </div>
		    </div>
		</div>
    @endif
</main>    

<script type="text/javascript">
    $.validator.setDefaults({
	    submitHandler: function(form) {
	        form.submit();
	    }
    });

    $(function() {
        // validate the comment form when it is submitted
        $("#formadd").validate({
            ignore: [],
            errorPlacement: function(label, element) {
                label.addClass('mt-2 text-danger');
                label.insertAfter(element);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass('has-danger')
                $(element).addClass('form-control-danger')
            }
          });
    });

</script>     

@endsection