@extends('layouts.admin.app')
@section('content')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <main id="main" class="main">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="product-search">
                                    <div class="prod-search-title">
                                        <h5 class="card-title">
                                            Product Images
                                        </h5>
                                        <div class="ml-auto text-right">
                                            <a href="{{route('admin.images')}}" class="btn btn-success">Back</a>
                                        </div>
                                    </div>
                                    <div class="prod-search-body">
                                        <form action="{{route('admin.images')}}" id="search-form" method="GET">
                                            <input class="form-control" id="search-field" name="search" value="{{$search}}" placeholder="Search By FNID/SKU">
                                            <button class="btn btn-primary" type="submit" ><i class="fa fa-search"></i></button>
                                        </form>                     
                                    </div>
                                </div>
                                <div class="table-responsive" style="font-size: 13px;">
                                    <table id="zero_config" class="table table-striped table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 1%"><b>No.</b></th>
                                                <th style="width: 2%"><b>FNID</b></th>
                                                <th style="width: 2%"><b>OLD ID</b></th>
                                                <th style="width: 8%"><b>Image</b></th>
                                                <th style="width: 8%"><b>Mob Image</b></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i=1; @endphp
                                            @foreach($result as $key => $images)
                                                <tr>
                                                    <td>{{ $i + $key }}</td>
                                                    <td>{{$images->fnid}}</td> 
                                                    <td>{{$images->sku}}</td>
                                                    <td><img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/{{$images->name}}" style="width:90px; height: auto;"></td>
                                                    <td><img src="https://giftbasketsbrazil.rightflorist.org/uploaded/product/thumb/{{$images->thumb}}" style="width:90px; height: auto;"></td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <div style="font-size: 15px; text-align: left; display: inline;">
                                        Showing {{ $result->firstItem() }} to {{ $result->lastItem() }} of {{ $result->total() }} entries
                                    </div>
                                    <div class="text-center-pagination pagination" style="float:right;">
                                        {!! $result->withQueryString()->links('pagination::bootstrap-4') !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        
    </main><!-- End #main -->

    <style>
        .prod-search-body {
            display: flex;
            justify-content: flex-end; /* Align to right */
            margin: 20px 0;
        }

        #search-form {
            display: flex;
            flex-wrap: nowrap;
            align-items: center;
            gap: 10px;
            max-width: 100%;
        }

        #search-field {
            padding: 10px 12px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 6px;
            box-shadow: inset 0 1px 2px rgba(0,0,0,0.1);
        }

        #search-form .btn {
            padding: 10px 16px;
            font-size: 16px;
            border-radius: 6px;
        }

        @media (max-width: 576px) {
            #search-form {
                flex-direction: column;
                align-items: flex-end;
                gap: 8px;
            }

            #search-form .btn,
            #search-field {
                width: 100%;
            }
        }
    </style>
    
    <script>
        // document.addEventListener("DOMContentLoaded", function () {
        //     const table = document.querySelector("#zero_config");
        //     const dataTable = new simpleDatatables.DataTable(table, {
        //         sortable: true,
        //         fixedHeight: true,
        //         columns: [
        //             { select: 4, sort: "desc" } // Sort by the 6th column (index 5) descending
        //         ]
        //     });
        // });
        
    </script> 

@endsection
