@extends('layouts.agent.app')

@section('content')

<main id="main" class="main">
    <div class="container" style="margin-top:5%;">
        <h3>PROFILE REPORT ({{$start_date}} to {{$end_date}})</h3>
            <table class="table">
            	@if(empty($tableItem))
            		No Data Found
    			@else
	                <thead>
	                    <tr>
	                        <th scope="col">Sr no</th>
	                        <th scope="col">Order Id</th>
	                        <th scope="col">Delivery Date</th>
	                        <th scope="col">City</th>
	                        <th scope="col">Amount</th>
	                        <th scope="col">Placement Price</th>
	                        <th scope="col">Profit</th>
	                        <th scope="col">Agent</th>
	                        <th scope="col">Status</th>
	                    </tr>
	                </thead>
	                <tbody>
	                    @php $i=0; $placementTotal=0; @endphp
	                    @foreach($tableItem as $item)
	                    	@php $i++; @endphp
	                    	<tr>
	                            <td>{{$i}}</td>
	                            <td>{{ $item['uniqueId'] }}</td>
	                            <td>{{ $item['delivery_date'] }}</td>
	                            <td>{{ $item['delivery_city_name'] }}</td>
	                            <td>{{ $item['totalOrderPrice'] }}</td>
	                            <td>
	                                {{ $item['placementTotal'] }}
	                                @php $placementTotal +=$item['placementTotal']; @endphp
	                            </td>
	                            <td>{{ round($item['profit'],1) }}%</td>
	                            <td>
	                                @foreach($item['agent_name'] as $city)
	                                    {{ $city }}<br>
	                                @endforeach
	                            </td>
	                            <td>{{$item['status']}}</td>
	                        </tr>
	                    @endforeach    
	                        {{--@foreach ($profitReportData as $item)
	                            @foreach ($item['totalOrderPrice'] as $index => $orderPrice)
	                                @php $i++; @endphp
	                                @if($item['unique_order_id'][$index][0]!='')
		                                <tr>
		                                    <td>{{$i}}</td>
		                                    <td>{{ $item['unique_order_id'][$index][0] }}</td>
		                                    <td>{{ $item['delivery_date'][$index][0] }}</td>
		                                    <td>{{ $item['delivery_city_name'][$index][0] }}</td>
		                                    <td>{{ $orderPrice[0] }}</td>
		                                    <td>
			                                    {{ $item['placementTotal'][$index][0] }}
			                                    @php $placementTotal +=$item['placementTotal'][$index][0]; @endphp
			                                </td>
		                                    <td>{{ round($item['profit'][$index][0],1) }}%</td>
		                                    <td>{{$agent->name}}</td>
		                                    <td>{{$item['status']}}</td>
		                                </tr>
		                            @else
							        	<div>No Data Found</div>
							        @endif	
	                            @endforeach   
	                    	@endforeach--}}
	                    <table class="table">
			                <thead>
			                    <th>
			                        <th>Total Amount to be paid by Client : {{$placementTotal}}</th>
			                    </th>
			                </thead>
			            </table>
	                </tbody>
	            @endif    
            </table>
        <a class="btn btn-danger" href="{{url('/agent/assignorder/generateReport')}}">Back</a>
    </div>
</main>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

@endsection