<?php



namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;

use Maatwebsite\Excel\Facades\Excel;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Validator;

use App\Models\Product;

use App\Models\Category;

use App\Models\ProductCategory;

use App\Models\ProductAttribute;

use App\Models\ProductImage;

use App\Models\ProductLiveStatus;

use App\Models\ProductRating;
use App\Models\ProductPersonalize;

use App\Imports\BulkProductUploadImport;

// use Excel;



class ProductController extends Controller

{

	public function list(Request $request)

	{

        $where = $orWhere = [];

        //$result = Product::select('id', 'product_name','price', 'actual_price', 'fnid', 'is_block', 'has_attribute', 'created_at')->orderBy('id', 'DESC')->get();



        $orWhere = array();



        $where = ['addon' => 'N'];
        $where = ['product_type' => 'M'];


        // search conditions

        if($request->search != null){

            $orWhere[] = ['product_name', 'LIKE', '%'.$request->search.'%'];

            $orWhere[] = ['fnid', '=', $request->search];
            $orWhere[] = ['id', '=', $request->search];
            $orWhere[] = ['sku', '=', $request->search];

        }



        $product_related_category_product_id = '';

        if($request->category_id != null){

            $product_related_category_product_id = ProductCategory::where(['category_id'=>$request->category_id])->pluck('product_id');

        }





        $result = Product::select('id', 'sku', 'product_name','price', 'actual_price', 'fnid', 'is_block', 'has_attribute', 'delivery_delay_days', 'delivery_type', 'specification', 'segregation', 'vendor_name', 'created_at')->where($where)

                        ->where(function($query) use ($orWhere,$product_related_category_product_id){



                            if($product_related_category_product_id !=''){

                                $query->WhereIn('id',$product_related_category_product_id);

                            }

                            foreach($orWhere as $key => $where){

                                if($key == 0){

                                    $query->where([$where]);



                                }else{

                                    $query->orWhere([$where]);

                                }

                            }

                        })

                        ->when($request->sort && $request->direction, function($query) use ($request){

                            $query->orderBy($request->sort, $request->direction);

                        }, function($query){

                            $query->orderBy('id', 'asc');

                        })

                        ->paginate(50);



        $lastInsertData = Product::latest('fnid')->first();



        $category_data = Category::where(['is_block' => 'N', 'menu_head_only' => 'N'])->where('cat_section', '<>', 'P')->orderBy('name', 'asc')->pluck('name', 'id');

		// $product = Product::all();

		// echo "<pre>";

		// print_r($product);

		// die;

		return view('admin.product.list',['result' => $result, 'category_data' => $category_data, 'request' => $request, 'lastInsertData' => $lastInsertData]);

	}



	// public function status(Request $request, $id ='')

	// {

    //     $id = decrypt($id); 

	// 	if ($id > 0) {

    //         $arr = ProductLiveStatus::where(['product_id' => $id])->get();

            

	//             $result['aof'] = $arr['0']->aof_is_block;

	//             $result['bof'] = $arr['0']->bof_is_block;

	//             $result['cof'] = $arr['0']->cof_is_block;

	//             $result['dof'] = $arr['0']->dof_is_block;

	//             $result['hof'] = $arr['0']->hof_is_block;

	//             $result['kof'] = $arr['0']->kof_is_block;

	//             $result['mof'] = $arr['0']->mof_is_block;

	//             $result['pof'] = $arr['0']->pof_is_block;



	//             $result['id'] = $arr['0']->id;



    //         //$result['category'] = DB::table('categories')->where(['status' => 1])->where(['id', '!=', $id])->get();

    //     } else {

    //         $result['aof'] = '';

    //         $result['bof'] = '';

    //         $result['cof'] = '';

    //         $result['dof'] = '';

    //         $result['hof'] = '';

    //         $result['kof'] = '';

    //         $result['mof'] = '';

    //         $result['pof'] = '';



    //         $result['id'] = 0;

    //     }

	// 		return view('admin.product.status',$result);

		

	// }



    public function status(Request $request, $id = '')

    {

        $id = decrypt($id); 

        if ($id > 0) {

            $arr = ProductLiveStatus::where(['product_id' => $id])->get();



            if ($arr->isNotEmpty()) {

                $result['aof'] = $arr[0]->aof_is_block;

                $result['bof'] = $arr[0]->bof_is_block;

                $result['cof'] = $arr[0]->cof_is_block;

                $result['dof'] = $arr[0]->dof_is_block;

                $result['hof'] = $arr[0]->hof_is_block;

                $result['kof'] = $arr[0]->kof_is_block;

                $result['mof'] = $arr[0]->mof_is_block;

                $result['pof'] = $arr[0]->pof_is_block;



                $result['id'] = $arr[0]->id;

            } else {

                $result['aof'] = '';

                $result['bof'] = '';

                $result['cof'] = '';

                $result['dof'] = '';

                $result['hof'] = '';

                $result['kof'] = '';

                $result['mof'] = '';

                $result['pof'] = '';



                $result['id'] = 0;

            }

        } else {

            $result['aof'] = '';

            $result['bof'] = '';

            $result['cof'] = '';

            $result['dof'] = '';

            $result['hof'] = '';

            $result['kof'] = '';

            $result['mof'] = '';

            $result['pof'] = '';



            $result['id'] = 0;

        }

        return view('admin.product.status', $result);

    }





	public function statusUpdate(Request $request)

	{

		// $model = new ProductLiveStatus();

		$status_id=0;

		if ($request->post('id')) {

			$status_id=$request->post('id');

            $model = ProductLiveStatus::find($status_id);

        }

        $model->aof_is_block = $request->post('aof');

        $model->bof_is_block = $request->post('bof');

        $model->cof_is_block = $request->post('cof');

        $model->dof_is_block = $request->post('dof');

        $model->hof_is_block = $request->post('hof');

        $model->kof_is_block = $request->post('kof');

        $model->mof_is_block = $request->post('mof');

        $model->pof_is_block = $request->post('pof');

        $model->save();

        return redirect()->back();

	}



	public function productAdd(Request $request)

	{

		$obj = new Product();

        if($request->isMethod('POST')){

        	// dd($request);

            $request->validate([

                'product_title'=>'required',

                'categories_id'=>'required',

                'product_description'=>'required',

                'has_attribute'=>'required',

                'delivery_delay_days'=>'required',

                'alt_keyword'=>'required',

                'meta_title'=>'required',

                'meta_description'=>'required',

                'fnid'=>'required',

                'sku'=>'required',
                'vendor_name'=>'required' 
                // 'extra_field'=>'required',

            ]);


            if($request->has_attribute == 'N'){

                $price = $request->product_price;

            }else{

                $price = 0;

            }

            if($request->sku){
                $product = Product::where('sku', $request->sku)->first();
                if($product){
                    $product_sku = $product->sku;

                    if($product_sku){
                        $request->session()->flash('alert-danger', 'SKU is Already used.');
                        return redirect()->route('admin.product.product-add');
                    }
                }
            }


            $product_data = $obj->create([

                    'product_name' => $request->product_title,

                    'description' => $request->product_description,

                    'content' => $request->content,

                    'delivery_info' => $request->shipping,

                    'has_attribute' => $request->has_attribute,

                    'price' => $price,

                    'actual_price' => $request->product_actual_price,

                    'delivery_delay_days' => $request->delivery_delay_days,

                    'alt_key' => $request->alt_keyword,

                    'meta_title' => $request->meta_title,

                    'meta_description' => $request->meta_description,

                    'slug'=> Product::getUniqueSlug($request->product_title),

                    'search_tag' => $request->search_tag,

                    'fnid' => $request->fnid,

                    'extra_field' => $request->extra_field,
                    'sku' => $request->sku,
                    'specification' => $request->specification,
                    'segregation' => $request->segregation,
                    'vendor_name' => $request->vendor_name,

            ]);



            if($product_data){

            	// dd('hello');

                // $sku_generate_array = array();

                // $sku_generate_array['product_type'] = 'A';

                // $sku_generate_array['delivery_by']  = 'C';

                // $sku_generate_array['product_id']   = $product_data->id;

                // $sku_generate_array['country_id']   = 99;

                // $sku = @$this->generate_sku($sku_generate_array);

                // /* Update product sku */

                // Product::where('id',$product_data->id)->update(['sku'=>$sku]);



                if(isset($request->has_attribute) && $request->has_attribute == 'Y'){

                    if((isset($request->attr_cont) && count($request->attr_cont)>0) && (isset($request->attr_price) && count($request->attr_price)>0) && (isset($request->attr_actual_price) && count($request->attr_actual_price)>0)){

                        foreach ($request->attr_cont as $attr_key => $attribute_cont) {

                            $product_attribute = [];

                            $product_attribute['product_id'] = $product_data->id;
                            $product_attribute['product_fnid'] = $product_data->fnid;
                            $product_attribute['sku_old'] = $product_data->sku;
                            // $product_attribute['title']      = $attribute_title;

                            // $product_attribute['description']      = $request->attr_desc[$attr_key];
                            $product_attribute['content'] = $attribute_cont;

                            $product_attribute['price'] = $request->attr_price[$attr_key];
                            $product_attribute['actual_price'] = $request->attr_actual_price[$attr_key];

                            $product_attribute['sl_no'] = $attr_key;



                            ProductAttribute::create($product_attribute);



                            if( $attr_key == 0 ){

                                Product::where('id',$product_data->id)->update(['price' => $request->attr_price[$attr_key]]);

                            }

                        }

                    }

                }



                if((isset($request->categories_id) && count($request->categories_id)>0) && $product_data){

                    foreach( $request->categories_id as $cat_id ) {

                        $categories_data['product_id'] = $product_data->id;

                        $categories_data['category_id']  = $cat_id;

                        ProductCategory::create($categories_data);

                    }

                }



                $product_image['product_id'] = $product_data->id;

                $product_image['name']  = $request->fnid.'.webp';

                $product_image['thumb']  = $request->fnid.'_mob.webp';

                $product_image['default_image']  = 'Y';

                $product_image['created_at'] = date('Y-m-d H:i:s');

                $product_image['updated_at'] = date('Y-m-d H:i:s');

                ProductImage::create($product_image);



                $product_live_status['product_id'] = $product_data->id;

                $product_live_status['aof_is_block'] = 'N';

                $product_live_status['bof_is_block'] = 'N';

                $product_live_status['cof_is_block'] = 'N';

                $product_live_status['dof_is_block'] = 'N';

                $product_live_status['hof_is_block'] = 'N';

                $product_live_status['kof_is_block'] = 'N';

                $product_live_status['mof_is_block'] = 'N';

                $product_live_status['pof_is_block'] = 'N';

                ProductLiveStatus::create($product_live_status);



                $request->session()->flash('alert-success', 'Product successfully added.');

                return redirect()->route('admin.product.list');

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

                return redirect()->back()->with($request->except(['_method', '_token']));

            }



        }

		$catdata = Category::where('is_block','N')->get();
        $vendor_details = DB::table('vendor_details')->get();

		return view('admin.product.add',['catdata' => $catdata, 'vendor_details' => $vendor_details]);

	}



	// public function generate_sku($request){

 //        $formated_number = '';

 //        $total_digit_number = '00000';

 //        $product_id = $request['product_id'];

 //        $product_id_length = strlen((string)$product_id);

 //        $concate_digit_and_pid = $total_digit_number.$product_id;

 //        $formated_product_number = substr($concate_digit_and_pid, $product_id_length);





 //        $country_sort_code = "ABC";

 //        $webside_code = 1;

 //        $formated_number = $request['product_type'].$request['delivery_by'].$formated_product_number.$country_sort_code;

 //        return $formated_number;

 //    }



	// public function productEdit(Request $request, $id = null)

    // {

    // 	// dd($id);

    //     $id = decrypt($id);

    //     // dd($id);

    //     $productdetails  = Product::where('id', $id)->first();
    //     $vendor_details = DB::table('vendor_details')->get();
    //     $productPersonalize = ProductPersonalize::where('product_id', $id)->first();

    //     if($productPersonalize){
    //         $no_of_image = $productPersonalize->no_of_image;
    //         $productPersonalizeId = $productPersonalize->id;
    //         // dd($no_of_image);
    //     }else{
    //         $no_of_image = 0;
    //         $productPersonalizeId = 0;
    //     }
        
    //     $product_fnid = $productdetails->fnid;
    //     $sku_old = $productdetails->sku;

    //     //$categorydetails = GBGProductCategory::where('product_id', $id)->get();



    //     $category_selected = ProductCategory::where(['product_id' => $id])->pluck('category_id');

    //     $category_selected = $category_selected->toarray();

    //     // dd($category_selected);



    //     $attributedetails = ProductAttribute::where('product_id', $id)->get();

    //     $imagedetails = ProductImage::where('product_id', $id)->first();

    //     $catdata = Category::all();



    //     if($request->isMethod('POST')){

    //         // dd($request->delivery_type);

    //         $request->validate([

    //             'product_title'=>'required',

    //             'categories_id'=>'required',

    //             'product_description'=>'required',

    //             'has_attribute'=>'required',

    //             'delivery_delay_days'=>'required',

    //             'alt_keyword'=>'required',

    //             'meta_title'=>'required',

    //             'meta_description'=>'required',

    //             'fnid'=>'required',

    //             'sku'=>'required',

    //             // 'extra_field'=>'required',

    //         ]);



    //         $formid=$request->formid;


    //         if($request->has_attribute == 'N'){

    //             $price = $request->product_price;

    //         }else{

    //             $price = 0;

    //         }



    //         $update_arr['product_name'] = $request->product_title;

    //         $update_arr['description'] = $request->product_description;

    //         $update_arr['content'] = $request->content;

    //         $update_arr['delivery_info'] = $request->shipping;

    //         $update_arr['has_attribute'] = $request->has_attribute;

    //         $update_arr['price'] = $price;

    //         $update_arr['actual_price'] = $request->product_actual_price;

    //         $update_arr['delivery_delay_days'] = $request->delivery_delay_days;

    //         $update_arr['alt_key'] = $request->alt_keyword;

    //         $update_arr['meta_title'] = $request->meta_title;

    //         $update_arr['meta_description'] = $request->meta_description;

    //         //$update_arr['slug'] =  GBGProduct::getUniqueSlug($request->product_title);

    //         $update_arr['search_tag'] = $request->search_tag;

    //         $update_arr['fnid'] = $request->fnid;
    //         $update_arr['sku'] = $request->sku;

    //         $update_arr['extra_field'] = $request->extra_field;
    //         $update_arr['specification'] = $request->specification;
    //         $update_arr['segregation'] = $request->segregation;
    //         $update_arr['vendor_name'] = $request->vendor_name;
    //         $update_arr['delivery_type'] = $request->delivery_type;

    //         // dd($update_arr);


    //         $productcategory= ProductCategory::where(['product_id' => $formid])->delete();



    //         if(isset($request->has_attribute) && $request->has_attribute == 'N'){

    //             $obj = Product::where(['id' => $formid])->first();

    //             if($obj->has_attribute == 'Y'){

    //                 $productattribute = ProductAttribute::where(["product_id" => $formid])->delete();

    //             }

    //         }



    //         if(isset($request->has_attribute) && $request->has_attribute == 'Y'){

    //             $productattribute= ProductAttribute::where(['product_id' => $formid])->delete();

    //             if((isset($request->attr_cont) && count($request->attr_cont)>0) && (isset($request->attr_price) && count($request->attr_price)>0) && (isset($request->attr_actual_price) && count($request->attr_actual_price)>0)){

    //                 foreach ($request->attr_cont as $attr_key => $attribute_cont) {

    //                     $product_attribute = [];

    //                     $product_attribute['product_id'] = $formid;

    //                     $product_attribute['product_fnid'] = $product_fnid;
    //                     $product_attribute['sku_old'] = $sku_old;

    //                     // $product_attribute['title']      = $attribute_title;

    //                     // $product_attribute['description']      = $request->attr_desc[$attr_key];
    //                     // $product_attribute['content']      = $request->attr_cont[$attr_key];
    //                     $product_attribute['content']      = $attribute_cont;

    //                     $product_attribute['price']      = $request->attr_price[$attr_key];
    //                     $product_attribute['actual_price'] = $request->attr_actual_price[$attr_key];

    //                     $product_attribute['sl_no']      = $attr_key;



    //                     ProductAttribute::create($product_attribute);


    //                     if( $attr_key == 0 ){

    //                         Product::where('id',$formid)->update(['price' => $request->attr_price[$attr_key]]);

    //                     }

    //                 }

    //             }

    //         }



    //         if((isset($request->categories_id) && count($request->categories_id)>0)){

    //             foreach( $request->categories_id as $cat_id ) {

    //                 $categories_data['product_id'] = $formid;

    //                 $categories_data['category_id']  = $cat_id;

    //                 ProductCategory::create($categories_data);

    //             }

    //         }



    //         $product_image['name']  = $request->fnid.'.webp';

    //         $product_image['thumb']  = $request->fnid.'_mob.webp';

    //         $product_image['default_image']  = 'Y';

    //         $product_image['created_at'] = date('Y-m-d H:i:s');

    //         $product_image['updated_at'] = date('Y-m-d H:i:s');

    //         ProductImage::where(['product_id' => $formid])->update($product_image);

    //         if($productPersonalizeId !=0){
    //             $product_personalize['no_of_image']  = $request->personalize_images;
    //             ProductPersonalize::where(['id' => $productPersonalizeId])->update($product_personalize);
    //         }


    //         if(Product::where(['id' => $formid])->update($update_arr)){



    //             $request->session()->flash('alert-success', 'Product successfully updated.');

    //             return redirect()->route('admin.product.list');

    //         }else{

    //             $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

    //             return redirect()->back()->with($request->except(['_method', '_token']));

    //         }

    //     }



    //     return view('admin.product.edit', ['catdata' => $catdata, 'productdetails' => $productdetails, 'category_selected' => $category_selected, 'attributedetails' => $attributedetails, 'imagedetails' => $imagedetails, 'vendor_details' => $vendor_details, 'no_of_image' => $no_of_image, 'request' => $request]);

    // }


    public function productEdit(Request $request, $id = null)
    {
        // dd($id);
        $id = decrypt($id);
        // dd($id);

        $productdetails  = Product::where('id', $id)->first();
        $vendor_details = DB::table('vendor_details')->get();
        $productPersonalize = ProductPersonalize::where('product_id', $id)->first();

        // if($productPersonalize){
        //     $no_of_image = $productPersonalize->no_of_image;
        //     $text = $productPersonalize->text_msg;
        //     $productPersonalizeId = $productPersonalize->id;
        //     // dd($no_of_image);
        // }else{
        //     $no_of_image = 0;
        //     $text ='';
        //     $productPersonalizeId = 0;
        // }
        
        $product_fnid = $productdetails->fnid;
        $sku_old = $productdetails->sku;

        //$categorydetails = GBGProductCategory::where('product_id', $id)->get();

        $category_selected = ProductCategory::where(['product_id' => $id])->pluck('category_id');
        $category_selected = $category_selected->toarray();

        // dd($category_selected);

        $attributedetails = ProductAttribute::where('product_id', $id)->get();
        $imagedetails = ProductImage::where('product_id', $id)->first();
        $catdata = Category::all();

        if($request->isMethod('POST')){

            // dd($request->delivery_type);

            $request->validate([
                'product_title'=>'required',
                'categories_id'=>'required',
                'product_description'=>'required',
                'has_attribute'=>'required',
                'delivery_delay_days'=>'required',
                'alt_keyword'=>'required',
                'meta_title'=>'required',
                'meta_description'=>'required',
                'fnid'=>'required',
                //'sku'=>'required',
                // 'extra_field'=>'required',
            ]);

            $formid=$request->formid;

            // if($request->has_attribute == 'N'){
            //     $price = $request->product_price;
            // }else{
            //     $price = 0;
            // }

            $update_arr['product_name'] = $request->product_title;
            $update_arr['description'] = $request->product_description;
            $update_arr['content'] = $request->content;
            $update_arr['delivery_info'] = $request->shipping;
            $update_arr['has_attribute'] = $request->has_attribute;

            if(isset($request->has_attribute) && $request->has_attribute == 'N'){
                $product_request['price']           = $request->price;

                // if($products->has_attribute == 'Y') {
                //     ProductAttribute::where(["product_id" => $formid])->delete();
                // }
            }
            
            if($request->actual_price == ''){
                $product_request['actual_price'] = 0;
            }else{
                $product_request['actual_price'] = $request->actual_price;
            }


            //$update_arr['price'] = $price;
            //$update_arr['actual_price'] = $request->product_actual_price;
            $update_arr['delivery_delay_days'] = $request->delivery_delay_days;
            $update_arr['alt_key'] = $request->alt_keyword;
            $update_arr['meta_title'] = $request->meta_title;
            $update_arr['meta_description'] = $request->meta_description;
            //$update_arr['slug'] =  GBGProduct::getUniqueSlug($request->product_title);
            $update_arr['search_tag'] = $request->search_tag;

            $update_arr['fnid'] = $request->fnid;
            $update_arr['sku'] = $request->sku;

            $update_arr['extra_field'] = $request->extra_field;
            $update_arr['specification'] = $request->specification;
            $update_arr['segregation'] = $request->segregation;
            $update_arr['vendor_name'] = $request->vendor_name;
            $update_arr['delivery_type'] = $request->delivery_type;

            // dd($update_arr);

            if(Product::where(['id' => $formid])->update($update_arr)){

                if(isset($request->has_attribute) && $request->has_attribute == 'Y'){

                    if((isset($request->attr_cont) && count($request->attr_cont)>0) && (isset($request->attr_price) && count($request->attr_price)>0)){
                        $g=1;

                        foreach ($request->attr_cont as $attr_key => $attribute_cont) {
                            if($request->attr_id[$attr_key] >0){
                                $product_attribute = [];
                                if( $attribute_cont != '' ){
                                    $product_attribute['content']      = $attribute_cont;
                                    $product_attribute['price']      = $request->attr_price[$attr_key];
                                    $product_attribute['actual_price'] = $request->attr_actual_price[$attr_key];
                                    $product_attribute['sl_no']      = $attr_key;
                                    
                                    $product_attribute['updated_at'] = date('Y-m-d H:i:s');
                                    ProductAttribute::where('id', $request->attr_id[$attr_key])->update($product_attribute);
                                    if( $g == 1 ){
                                        Product::where('id',$formid)->update(['price' => $request->attr_price[$attr_key], 'actual_price' => $request->attr_actual_price[$attr_key]]);
                                    }
                                }
                            }elseif($request->attr_id[$attr_key] ==''){
                                $product_attribute = [];

                                if($attribute_cont != '') {
                                    $product_attribute['product_id'] = $formid;
                                    $product_attribute['content']      = $attribute_cont;
                                    $product_attribute['price']      = $request->attr_price[$attr_key];
                                    $product_attribute['actual_price'] = $request->attr_actual_price[$attr_key];
                                    $product_attribute['sl_no']      = $attr_key;
                                    
                                    //$product_attribute['created_by'] = Auth::guard('admin')->user()->id;
                                    ProductAttribute::create($product_attribute);
                                    if( $g == 1 ){
                                        Product::where('id',$formid)->update(['price' => $request->attr_price[$attr_key], 'actual_price' => $request->attr_actual_price[$attr_key]]);
                                    }
                                }
                            }
                            $g++;
                        }
                    }
                } 

                $productcategory= ProductCategory::where(['product_id' => $formid])->delete();

                if((isset($request->categories_id) && count($request->categories_id)>0)){
                    foreach( $request->categories_id as $cat_id ) {
                        $categories_data['product_id'] = $formid;
                        $categories_data['category_id']  = $cat_id;
                        ProductCategory::create($categories_data);
                    }
                }

                if($productPersonalize){
                    $product_personalize['no_of_image']  = $request->personalize_images;
                    $product_personalize['text_msg']  = $request->personalize_text;
                    ProductPersonalize::where(['id' => $productPersonalize->id])->update($product_personalize);
                }

                $product_image['name']  = $request->fnid.'.webp';
                $product_image['thumb']  = $request->fnid.'_mob.webp';
                $product_image['default_image']  = 'Y';
                $product_image['created_at'] = date('Y-m-d H:i:s');
                $product_image['updated_at'] = date('Y-m-d H:i:s');
                ProductImage::where(['product_id' => $formid])->update($product_image);

                $request->session()->flash('alert-success', 'Product successfully updated.');
                return redirect()->route('admin.product.list');

            }else{

                $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');
                return redirect()->back()->with($request->except(['_method', '_token']));
            }





            // $productcategory= ProductCategory::where(['product_id' => $formid])->delete();



            // if(isset($request->has_attribute) && $request->has_attribute == 'N'){

            //     $obj = Product::where(['id' => $formid])->first();

            //     if($obj->has_attribute == 'Y'){

            //         $productattribute = ProductAttribute::where(["product_id" => $formid])->delete();

            //     }

            // }



            // if(isset($request->has_attribute) && $request->has_attribute == 'Y'){

            //     $productattribute= ProductAttribute::where(['product_id' => $formid])->delete();

            //     if((isset($request->attr_cont) && count($request->attr_cont)>0) && (isset($request->attr_price) && count($request->attr_price)>0) && (isset($request->attr_actual_price) && count($request->attr_actual_price)>0)){

            //         foreach ($request->attr_cont as $attr_key => $attribute_cont) {

            //             $product_attribute = [];

            //             $product_attribute['product_id'] = $formid;

            //             $product_attribute['product_fnid'] = $product_fnid;
            //             $product_attribute['sku_old'] = $sku_old;

            //             // $product_attribute['title']      = $attribute_title;

            //             // $product_attribute['description']      = $request->attr_desc[$attr_key];
            //             // $product_attribute['content']      = $request->attr_cont[$attr_key];
            //             $product_attribute['content']      = $attribute_cont;

            //             $product_attribute['price']      = $request->attr_price[$attr_key];
            //             $product_attribute['actual_price'] = $request->attr_actual_price[$attr_key];

            //             $product_attribute['sl_no']      = $attr_key;



            //             ProductAttribute::create($product_attribute);


            //             if( $attr_key == 0 ){

            //                 Product::where('id',$formid)->update(['price' => $request->attr_price[$attr_key]]);

            //             }

            //         }

            //     }

            // }



            // if((isset($request->categories_id) && count($request->categories_id)>0)){

            //     foreach( $request->categories_id as $cat_id ) {

            //         $categories_data['product_id'] = $formid;

            //         $categories_data['category_id']  = $cat_id;

            //         ProductCategory::create($categories_data);

            //     }

            // }



            // $product_image['name']  = $request->fnid.'.webp';

            // $product_image['thumb']  = $request->fnid.'_mob.webp';

            // $product_image['default_image']  = 'Y';

            // $product_image['created_at'] = date('Y-m-d H:i:s');

            // $product_image['updated_at'] = date('Y-m-d H:i:s');

            // ProductImage::where(['product_id' => $formid])->update($product_image);

            // if($productPersonalizeId !=0){
            //     $product_personalize['no_of_image']  = $request->personalize_images;
            //     ProductPersonalize::where(['id' => $productPersonalizeId])->update($product_personalize);
            // }


            // if(Product::where(['id' => $formid])->update($update_arr)){



            //     $request->session()->flash('alert-success', 'Product successfully updated.');

            //     return redirect()->route('admin.product.list');

            // }else{

            //     $request->session()->flash('alert-danger', 'Sorry! There was an unexpected error. Try again!');

            //     return redirect()->back()->with($request->except(['_method', '_token']));

            // }

        }



        return view('admin.product.edit', ['catdata' => $catdata, 'productdetails' => $productdetails, 'category_selected' => $category_selected, 'attributedetails' => $attributedetails, 'imagedetails' => $imagedetails, 'vendor_details' => $vendor_details, 'productPersonalize' => $productPersonalize, 'request' => $request]);

    }



    public function getcategory(Request $request){

        if($request->id){

            $category_data = Category::where(['is_block' => 'N', 'menu_head_only' => 'N'])->where('cat_section', '<>', 'P')->get();

            $html = '';

            foreach($category_data as $key => $category){

                $html .= '<option value="'.$category->id.'">'.$category->name.'</option>';

            }



            return json_encode(['type' => 'json', 'status' => 'success', 'data' => $html]);

        }else{

            return json_encode(['type' => 'json', 'status' => 'error']);

        }

    }



    public function bulkproductedit(Request $request){



        $category_list = Category::where(['is_block' => 'N', 'menu_head_only' => 'N'])->where('cat_section', '<>', 'P')->orderBy('name', 'asc')->pluck('name', 'id');





        if($request->isMethod('POST')){

            $val = $request->bulk_product_edit;

            if($val == "bulk_hide"){

                $arr = explode("\r\n",$request->field_values);

                for($i=0; $i<count($arr); $i++){

                    $pid = Product::where( ["fnid" => trim($arr[$i])] )->first();

                    if($pid){

                        // Product::where(["id" => $pid->id])->update(["is_block" => "Y"]);

                        ProductLiveStatus::where(['product_id' => $pid->id])

                        ->update(['aof_is_block' => 'Y','bof_is_block' => 'Y', 'cof_is_block' => 'Y', 'dof_is_block' => 'Y', 'hof_is_block' => 'Y', 'kof_is_block' => 'Y', 'mof_is_block' => 'Y', 'pof_is_block' => 'Y' ]);

                    }

                }

            }



            if($val == "bulk_show"){

                $arr = explode("\r\n",$request->field_values);

                for($i=0; $i<count($arr); $i++){

                    $pid = Product::where( ["fnid" => trim($arr[$i])] )->first();

                    if($pid){

                        // Product::where(["id" => $pid->id])->update(["is_block" => "N"]);

                        ProductLiveStatus::where(['product_id' => $pid->id])

                        ->update(['aof_is_block' => 'N','bof_is_block' => 'N', 'cof_is_block' => 'N', 'dof_is_block' => 'N', 'hof_is_block' => 'N', 'kof_is_block' => 'N', 'mof_is_block' => 'N', 'pof_is_block' => 'N' ]);

                    }



                }

            }



            if($val == "bulk_status_update"){

                $arr = explode("\r\n",$request->field_values);

                // dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrstatus = explode("\t",$arr[$i]);

                    // dd($arrstatus);

                    $pid = Product::where( ["fnid" => trim($arrstatus[0])] )->first();

                    if($pid){

                        // Product::where(["id" => $pid->id])->update(["is_block" => "N"]);

                        ProductLiveStatus::where(['product_id' => $pid->id])

                        ->update([

                            'aof_is_block' => $arrstatus[1],

                            'bof_is_block' => $arrstatus[2], 

                            'cof_is_block' => $arrstatus[3], 

                            'dof_is_block' => $arrstatus[4], 

                            'hof_is_block' => $arrstatus[5], 

                            'kof_is_block' => $arrstatus[6], 

                            'mof_is_block' => $arrstatus[7],

                            'pof_is_block' => $arrstatus[8], 

                        ]);

                    }



                }

            }



            if($val == "bulk_price_update"){

                $arr = explode("\r\n",$request->field_values);

                //dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrprice = explode("\t",$arr[$i]);

                    //dd($arrprice);

                    $pid = Product::where( ["sku" => trim($arrprice[0])] )->first();

                    if($pid){

                        Product::where(["id" => $pid->id])->update(["price" => $arrprice[1]]);

                    }

                }

            }



            if($val == "bulk_mrp_update"){

                $arr = explode("\r\n",$request->field_values);

                //dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrmrp = explode("\t",$arr[$i]);

                    //dd($arrprice);

                    $pid = Product::where( ["sku" => trim($arrmrp[0])] )->first();

                    if($pid){

                        Product::where(["id" => $pid->id])->update(["actual_price" => $arrmrp[1]]);

                    }

                }

            }



            if($val == "bulk_description_change"){

                $arr = explode("\r\n",$request->field_values);

                for($i=0; $i<count($arr); $i++){

                    $arrContentChng = explode("\t",$arr[$i]);

                    //dd($arrdescription);

                    $pid = Product::where( ["fnid" => trim($arrContentChng[0])] )->first();

                    if($pid){

                        $uparr = [];



                        if(!empty($arrContentChng[1])){

                            $uparr['product_name'] = $arrContentChng[1];

                            $uparr['alt_key'] = $arrContentChng[1];

                        }



                        if(!empty($arrContentChng[2])){ $uparr['description'] = $arrContentChng[2]; }



                        if(!empty($arrContentChng[3])){ $uparr['content'] = $arrContentChng[3]; }



                        if(!empty($arrContentChng[4])){ $uparr['delivery_delay_days'] = $arrContentChng[4]; }



                        if(!empty($arrContentChng[5])){ $uparr['meta_title'] = $arrContentChng[5]; }



                        if(!empty($arrContentChng[6])){ $uparr['meta_description'] = $arrContentChng[6]; }



                        // if(!empty($arrContentChng[7])){ $uparr['extra_field'] = $arrContentChng[7]; }



                        if(!empty($arrContentChng[7])){ $uparr['slug'] = $arrContentChng[7]; }



                        if(!empty($arrContentChng[8])){ $uparr['search_tag'] = $arrContentChng[8]; }



                        //dd($uparr);



                        //DB::enableQueryLog();



                        Product::where(["id" => $pid->id])->update($uparr);



                        //dd($prod);

                        //dd(DB::getQueryLog());

                    }

                }

            }



            if($val == "bulk_product_upload"){

                $arr = explode("\r\n",$request->field_values);

                // dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrproduct = explode("\t",$arr[$i]);
                    $category = [];
                    //dd($arrproduct);
                    if(!empty($arrproduct[20])){
                        $category = explode("|",$arrproduct[20]);

                        //dd($category);
                        
                    }
                    
                    if($arrproduct[16]<>null){
                       $product = Product::where('fnid', $arrproduct[16])->first();
                       if($product<>null){
                            $product_fnid = $product->fnid;
                            if($product_fnid<>null){
                                $request->session()->flash('alert-danger', 'FNID is Already used.');
                                return redirect()->route('admin.product.bulkproductedit');
                            }
                        }
                    }
                    
                    if($arrproduct[17]<>null){
                       $product = Product::where('sku', $arrproduct[17])->first();
                       if($product<>null){
                    		$product_sku = $product->sku;
                        	if($product_sku<>null){
                            	$request->session()->flash('alert-danger', 'SKU is Already used.');
                            	return redirect()->route('admin.product.bulkproductedit');
                        	}
                    	}
                    }
                    

                    $obj = new Product();

                    $product_data = $obj->create([

                        'product_name' => $arrproduct[0],
                        'description' =>$arrproduct[1],
                        'content' => $arrproduct[2],
                        'price' => $arrproduct[3],
                        'actual_price' => $arrproduct[4],
                        'delivery_delay_days' => $arrproduct[5],
                        'alt_key' => $arrproduct[6],
                        'meta_title' => $arrproduct[7],
                        'meta_description' => $arrproduct[8],
                        'slug'=> Product::getUniqueSlug($arrproduct[0]),
                        'delivery_type' => $arrproduct[9],
                        'specification' => $arrproduct[10],
                        'segregation' => $arrproduct[11],
                        'vendor_name' => $arrproduct[12],
                        'fnid' => $arrproduct[16],
                        'sku' => $arrproduct[17],
                        'has_attribute' => $arrproduct[18],
                        'extra_field' => $arrproduct[19],
                    ]);

                    ProductImage::create([
                        'product_id' => $product_data->id,
                        'name' => $arrproduct[16].".webp",
                        'thumb' => $arrproduct[16]."_mob.webp",
                        'default_image' => 'Y',
                    ]);

                    if($arrproduct[13]=='Y'){
                        ProductPersonalize::create([
                        'product_id' => $product_data->id,
                        'no_of_image' => $arrproduct[14],
                        'text_msg' => $arrproduct[15],
                        ]);
                    }

                    ProductLiveStatus::create([

                        'product_id' => $product_data->id,

                        'aof_is_block' => "N", //$arrproduct[12],

                        'bof_is_block' => "N", //$arrproduct[13],

                        'cof_is_block' => "N", //$arrproduct[14],

                        'dof_is_block' => "N", //$arrproduct[15],

                        'hof_is_block' => "N", //$arrproduct[16],

                        'kof_is_block' => "N", //$arrproduct[17],

                        'mof_is_block' => "N", //$arrproduct[18],

                        'pof_is_block' => "N", //$arrproduct[19],

                    ]);

                    if($product_data){
                        if(count($category) > 0){
                            for($j=0; $j<count($category); $j++){

                                $product_category = [];
                                $product_category['product_id'] = $product_data->id;
                                $product_category['category_id']  = $category[$j];
                                ProductCategory::create($product_category);
                            }
                        }

                        // $sku_generate_array = array();
                        // $sku_generate_array['product_type'] = 'A';
                        // $sku_generate_array['delivery_by']  = 'C';
                        // $sku_generate_array['product_id']   = $product_data->id;
                        // $sku_generate_array['country_id']   = 99;
                        // $sku = @$this->generate_sku($sku_generate_array);
                        // Product::where('id',$product_data->id)->update(['sku'=>$sku]);

                    }

                }

            }

            if($val == "bulk_product_attribute_upload"){

                $arr = explode("\r\n",$request->field_values);

                // dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrProductAttr = explode("\t",$arr[$i]);

                    //dd($arrproduct);

                    // $category = explode("|",$arrproduct[16]);

                    //dd($category);
                    $product = Product::where('fnid', $arrProductAttr[0])->first();
                    $product_id = $product->id;

                    $obj = new ProductAttribute();

                    $product_attr_data = $obj->create([

                        'product_id' => $product_id,
                        'product_fnid' => $arrProductAttr[0],
                        'sku_old' => $arrProductAttr[1],
                        'content' => $arrProductAttr[2],
                        'price' => $arrProductAttr[3],
                        'actual_price' => $arrProductAttr[4],
                        'sl_no' => $arrProductAttr[5],
                    ]);
                }

            }

            if($val == "bulk_product_addon_upload"){

                $arr = explode("\r\n",$request->field_values);

                // dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrProductAddon = explode("\t",$arr[$i]);

                    $obj = new Product();

                    $product_addon_data = $obj->create([

                        'fnid' => $arrProductAddon[0],
                        'sku' => $arrProductAddon[1],
                        'product_name' => $arrProductAddon[2],
                        'price' => $arrProductAddon[3],
                        // 'actual_price' => $arrProductAddon[4],
                        'delivery_type' => $arrProductAddon[4],
                        'product_type' => 'A',
                        'addon' => 'Y',
                        
                        // 'description' =>$arrproduct[1],
                        // 'content' => $arrproduct[2],
                        // 'delivery_delay_days' => $arrproduct[5],
                        // 'alt_key' => $arrproduct[6],
                        // 'meta_title' => $arrproduct[7],
                        // 'meta_description' => $arrproduct[8],
                        // 'slug'=> Product::getUniqueSlug($arrproduct[0]),
                        // 'specification' => $arrproduct[10],
                        // 'segregation' => $arrproduct[11],
                        // 'vendor_name' => $arrproduct[12],
                        // 'has_attribute' => $arrproduct[17],
                        // 'extra_field' => $arrproduct[18],
                    ]);

                    ProductImage::create([
                        'product_id' => $product_addon_data->id,
                        'name' => $arrProductAddon[0].".webp",
                        'thumb' => $arrProductAddon[0]."_mob.webp",
                        'default_image' => 'Y',
                    ]);

                    ProductLiveStatus::create([

                        'product_id' => $product_addon_data->id,

                        'aof_is_block' => "N", //$arrproduct[12],
                        'bof_is_block' => "N", //$arrproduct[13],
                        'cof_is_block' => "N", //$arrproduct[14],
                        'dof_is_block' => "N", //$arrproduct[15],
                        'hof_is_block' => "N", //$arrproduct[16],
                        'kof_is_block' => "N", //$arrproduct[17],
                        'mof_is_block' => "N", //$arrproduct[18],
                        'pof_is_block' => "N", //$arrproduct[19],

                    ]);
                }

            }


            if($val == "bulk_rating_upload"){

                $arr = explode("\r\n",$request->field_values);

                //dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrdescription = explode("\t",$arr[$i]);

                   // dd($arrdescription);

                    $pid = Product::where( ["fnid" => trim($arrdescription[0])] )->first();

                    //dd($pid);

                    if($pid){

                        $obj = new ProductRating();

                        $obj->create([

                           'product_id' => $pid->id,

                           'rating' =>  $arrdescription[1],

                           'review' => $arrdescription[2],

                           'user_name' => $arrdescription[3],

                           'delivery_place' => $arrdescription[4],

                           'sender_place' => $arrdescription[5],

                           'created_at' => $arrdescription[6],

                        ]);

                    }

                }

            }



            if($val == "bulk_category_add_remove"){

                if($request->alldata == 1){

                    //dd("hello");

                    if($request->select_option == 'remove')

                    {

                        ProductCategory::where(['category_id'=>$request->category_id])->delete();

                    }

                }else{

                    $arr = explode("\r\n",$request->field_values);

                    //dd($arr);

                    for($i=0; $i<count($arr); $i++){

                        $pid = Product::where( ["fnid" => trim($arr[$i])] )->first();



                        if($pid){



                            if($request->select_option == 'remove')

                            {

                                ProductCategory::where(['product_id'=>$pid->id, 'category_id'=>$request->category_id])->delete();

                            }

                            elseif($request->select_option == 'add')

                            {

                                if(ProductCategory::where(['product_id'=>$pid->id, 'category_id'=>$request->category_id])->count() == 0){

                                    ProductCategory::create(["product_id"=>$pid->id, 'category_id'=>$request->category_id ]);

                                }

                            }

                        }

                    }

                }

            }



            if($val == "multiple_img_upload"){

                $arr = explode("\r\n",$request->field_values);

                //dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrprice = explode("\t",$arr[$i]);

                    //dd($arrprice);

                    $pid = Product::where( ["fnid" => trim($arrprice[0])] )->first();

                    if($pid){

                        $product_image = [];

                        $product_image['product_id'] = $pid->id;

                        $product_image['name']  = $arrprice[1].".webp";

                        $product_image['thumb']  = $arrprice[1]."_mob.webp";

                        $product_image['default_image']  = 'N';

                        ProductImage::create($product_image);

                    }

                }

            }



            if($val == "bulk_product_sort"){

                $arr = explode("\r\n",$request->field_values);

                //dd($arr);

                for($i=0; $i<count($arr); $i++){

                    $arrprice = explode("\t",$arr[$i]);

                    //dd($arrprice);

                    $pid = Product::where( ["fnid" => trim($arrprice[0])] )->first();

                    if($pid){



                        ProductCategory::where(['product_id' => $pid->id, 'category_id' => $request->sort_category_id])

                                            ->update(['sort_order' => $arrprice[1]]);

                    }

                }

            }



            return redirect()->route('admin.product.bulkproductedit')->with('message', 'Product Update Successfully!');

        }

        return view('admin.product.bulkproductedit', ['request' => $request, 'category_list' => $category_list]);

    }



    public function upgrade_sort_order(Request $request)

    {



        $connectionName = 'mysql';



        //DB::enableQueryLog();



        $sqlSortField = "UPDATE product_categories SET sort_order = sort_order + 200 WHERE id IN (SELECT id FROM ( SELECT id FROM product_categories where category_id = " . $request->categoryId . " ORDER BY sort_order ASC LIMIT 50 ) as temp )";





        DB::connection($connectionName)->select($sqlSortField);



        return json_encode(['type' => 'json', 'status' => 'success', 'msg' => 'Update Successfully..']);

    }



    public function product_categorywise_sortorder(Request $request)

    {



        $connectionName = 'mysql';



        $sql = "SELECT products.id AS pid, products.product_name, products.slug, products.price, products.actual_price, products.delivery_delay_days, products.fnid, products.has_attribute, product_categories.sort_order, product_categories.id AS pcid FROM products INNER JOIN product_categories ON products.id = product_categories.product_id where product_categories.category_id = ".$request->category_id." order by product_categories.sort_order ASC";





        //DB::enableQueryLog();



        $products = DB::table('products')

                        ->distinct('products.id')

                        ->where(['products.is_block'=>'N', 'product_type'=>'M']);





        if(isset($request->category_id) && $request->category_id != null){



            $queryBuilder = DB::connection($connectionName)->table(DB::raw("($sql) as result"));

            $prod = $queryBuilder->paginate(30000)->withQueryString();

            // dd($prod);



        }else{

            $prod = Product::select('id', 'product_name','price', 'actual_price', 'fnid', 'is_block', 'has_attribute', 'created_at')->where(['product_type' => 'M', 'products.price'=>0])->orderBy('id', 'DESC')->paginate(50000);

        }



        $category_list = Category::where(['is_block' => 'N', 'menu_head_only' => 'N'])->where('cat_section', '<>', 'P')->orderBy('name', 'asc')->pluck('name', 'id');



        //dd(DB::getQueryLog());

        //dd($prod);

        //dd($categories);



        return view('admin.product.productcategorywisesortorder', ['request' => $request, 'category_list' => $category_list, 'products' => $prod]);

    }



    public function product_sortorder_update(Request $request)

    {

        ProductCategory::where(['id' => $request->sortID])->update(['sort_order' => $request->sortNO]);

        return json_encode(['type' => 'json', 'status' => 'success', 'msg' => 'Update Successfully..']);

    }



    public function dbfldupdate(Request $request){



        $connectionName = 'mysql';



        //DB::enableQueryLog();



        $sqlSortField = "update product_categories set sort = FLOOR( 1 + RAND() *100000 )";

        $sqlSortOrderField = "update product_categories set sort_order = id * 10000 WHERE sort_order = 0";

        $sqlMetaDescriptionField = "update products set meta_description = REPLACE(meta_description, '\"', '''')";

        $sqlProductNameField = "update products set  product_name = REPLACE(REPLACE(product_name, CHAR(13), ''), CHAR(10), '')";



        DB::connection($connectionName)->select($sqlSortField);

        DB::connection($connectionName)->select($sqlSortOrderField);

        DB::connection($connectionName)->select($sqlMetaDescriptionField);

        DB::connection($connectionName)->select($sqlProductNameField);



        //dd($prod);

        //dd(DB::getQueryLog());



        $request->session()->flash('alert-success', 'Product Table Settings Completed');

        return redirect()->back();

    }



    public function productexceldownload(){

        // return Excel::download(new GBSGProductExport,"product-excel.xlsx");

        $product = Product::where(['product_type' => 'M'])->get();

        return view('admin.product.excel',compact('product'));

    }



    public function bulkproductupload(Request $request)

    {

        if($request->hasFile('excel_file')){



            $products = json_decode($request->products, true);  // Decode the JSON data



            foreach ($products as $row) {

                // Insert each product into the database

                Product::create([

                    'product_name' => $row[0],

                    'slug' => 'abc',

                    'description' => $row[1],

                    'content' => $row[2],

                    'price' =>$row[3],

                    'actual_price' =>$row[4],

                    'delivery_delay_days' =>$row[5],

                    'alt_key' =>$row[6],

                    'meta_title' =>$row[7],

                    'meta_description' =>$row[8],

                    'extra_field' =>$row[9],

                    'fnid' =>$row[10],

                ]);

            }



            return response()->json(['message' => 'Products uploaded successfully']);

        }

        return view('admin.product.bulkproductupload', ['request' => $request]);

    }

    public function product_attr_delete(Request $request, $id = null)
    {
        $productAttribute = ProductAttribute::find($id);
        
        if (!$productAttribute) {
            return response()->json(['success' => false, 'message' => 'Attribute not found.'], 404);
        }

        $productAttribute->delete();

        return response()->json(['success' => true, 'message' => 'Attribute deleted successfully.']);
    }

    public function product_export(){
        $product = DB::table('products')->get();
        $delivery_type = $product->pluck('delivery_type')->unique();
        $specification = $product->pluck('specification')->unique();
        $segregation = $product->pluck('segregation')->unique();
        $vendor_name = $product->pluck('vendor_name')->unique();

        return view('admin.product.export_product',compact('delivery_type','specification','segregation','vendor_name'));
    }
    public function get_data(Request $request){
        $delivery_type = $request["delivery_type"];
        $specification = $request["specification"];
        $segregation = $request["segregation"];
        $vendor_name = $request["vendor_name"];
        
        $query = DB::table('products');
        
        if (!is_null($delivery_type)) {
            $query->where('delivery_type', $delivery_type);
        }
        
        if (!is_null($specification)) {
            $query->where('specification', $specification);
        }
        
        if (!is_null($segregation)) {
            $query->where('segregation', $segregation);
        }
        
        if (!is_null($vendor_name)) {
            $query->where('vendor_name', $vendor_name);
        }
        
        $products = $query->get();
        $Itemtable = [];
        
        foreach ($products as $product) {
            $product_attr = DB::table('product_attributes')->where('product_id', $product->id)->get();
            
            $item = [
                'id' => $product->id,
                'sku' => $product->sku,
                'fnid' => $product->fnid,
                'product_name' => $product->product_name,
                'desc' => $product->description,
                'content' => $product->content,
                'price' => $product->price,
                'delivery_type' => $product->delivery_type,
                'specification' => $product->specification,
                'segregation' => $product->segregation,
                'vendor_name' => $product->vendor_name,
                'product_attr' => [],
            ];
        
            foreach ($product_attr as $attr) {
                $item['product_attr'][] = [
                    'id' => $attr->id,
                    'skuold' => $attr->sku_old,
                    'product_fnid' => $attr->product_fnid,
                    'desc' => $attr->content,
                    'price' => $attr->price,
                ];
            }
        
            $Itemtable[] = $item;
        }
        
        return $Itemtable;
        
    }

}