<?php

// use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\RegisterController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\CmsController;
use App\Http\Controllers\Admin\AddonController;
use App\Http\Controllers\Admin\FalseurlController;
use App\Http\Controllers\Admin\HomeFeatureManagementController;
use App\Http\Controllers\Admin\CityController;
use App\Http\Controllers\Admin\TestimonialController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\ExcelController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\AgentController as AdminAgentController;
use App\Http\Controllers\CSD\CSDController;
use App\Http\Controllers\Agent\AgentController;

use Illuminate\Support\Facades\DB;
use App\Http\Helper;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

// Auth::routes();

Route::prefix('admin')->name('admin.')->group(function () {

    Route::get('/',[AdminController::class,'AdminLogin']);
    
    Route::middleware(['guest:AdminLogin'])->group(function () {
        Route::get('/login',[AdminController::class,'AdminLogin'])->name('login');
        Route::post('/dologin',[AdminController::class,'AdminLogedIn'])->name('dologin');
    });

    Route::middleware(['auth:AdminLogin'])->group(function () {
        Route::any('/home',[AdminController::class,'home'])->name('home');

        Route::get('/images',[AdminController::class,'images'])->name('images');

        Route::group(['prefix' => 'order', 'as' => 'order.'], function () {
            Route::get('/',[OrderController::class,'list'])->name('list');
            Route::get('/sitelist/{sitename}',[OrderController::class,'SiteNamewiseList'])->name('SiteNamewiseList');
            // Route::get('/orders/view/{orderId}',[OrdersController::class,'viewProduct'])->name('viewProduct');
            Route::get('/view/{id}', [OrderController::class, 'view'])->name('view');
            // Route::post('/orders/view/{orderId}',[OrdersController::class,'saveProduct'])->name('saveProduct');
            Route::post('/view/{id}', [OrderController::class, 'saveProduct'])->name('saveProduct');
            Route::get('/view/edit/{id}', [OrderController::class, 'EditAgentAssigned'])->name('EditAgentAssigned');
            Route::post('/view/edit/{id}', [OrderController::class, 'UpdateAgentAssigned'])->name('UpdateAgentAssigned');
            Route::get('/view/delete/{id}/{asssignId}', [OrderController::class, 'DeleteAgentAssigned'])->name('DeleteAgentAssigned');
            Route::get('/view/delete/{id}', [OrderController::class, 'DeleteOrderProduct'])->name('DeleteOrderProduct');
            Route::get('/ProductByAgent',[OrderController::class,'ProductByAgent']);
            Route::get('/GetPriceByProduct',[OrderController::class,'GetPriceByProduct']);
            Route::get('/GetDeliveryType',[OrderController::class,'GetDeliveryType']);
            Route::get('/getOrderID',[OrderController::class,'getOrderID']);
            Route::post('/ReAssignProduct',[OrderController::class,'ReAssignProduct']);
            Route::get('/getReAssignPrice',[OrderController::class,'getReAssignPrice']);
            Route::get('/getAgentId',[OrderController::class,'getAgentId']);

            Route::get('/Reassign',[OrderController::class,'Reassign']);
            Route::get('/mailStatus',[OrderController::class,'mailStatus']);

            Route::get('/assign-order-list', [OrderController::class, 'assignOrderList'])->name('assign-order-list');
            Route::post('/productAssign', [OrderController::class, 'search'])->name('search');
            Route::get('/assign-order-view/{id}/{agentId}',[OrderController::class,'assignOrderView'])->name('assignOrderView');
            Route::post('/assign-order-view/{id}/{agentId}',[OrderController::class,'updateAssignOrderStatus'])->name('updateAssignOrderStatus');

            route::get('/assign-order-view/invoice/{orderid}/{AgentAssignedId}',[OrderController::class,'OrderInvoice'])->name('OrderInvoice');

            Route::get('/report', [OrderController::class, 'report'])->name('report');
            Route::post('/report', [OrderController::class, 'reportTable'])->name('reportTable');

            Route::get('/ProfitReport', [OrderController::class, 'ProfitReport'])->name('ProfitReport');
            Route::post('/ProfitReport', [OrderController::class, 'ProfitReportSearch'])->name('ProfitReportSearch');

            Route::any('/updateDeliveryAddress', [OrderController::class, 'updateDeliveryAddress'])->name('updateDeliveryAddress');
            Route::any('/updateMessages', [OrderController::class, 'updateMessages'])->name('updateMessages');

            

            
        });

        Route::group(['prefix' => 'product', 'as' => 'product.'], function () {
            Route::any('/', [ProductController::class, 'list'])->name('list');
            Route::any('/product-add', [ProductController::class, 'productAdd'])->name('product-add');
            Route::any('/product-edit/{id}', [ProductController::class, 'productEdit'])->name('product-edit');
            Route::any('/bulkproductedit', [ProductController::class, 'bulkproductedit'])->name('bulkproductedit');
            Route::any('/bulkproductupload', [ProductController::class, 'bulkproductupload'])->name('bulkproductupload');
            Route::any('/upgrade_sort_order', [ProductController::class, 'upgrade_sort_order'])->name('upgrade_sort_order');

            // Route::any('/product_categorywise_sortorder', [ProductController::class, 'product_categorywise_sortorder'])->name('product_categorywise_sortorder');
            Route::any('/product_categorywise_sortorder/{site}', [ProductController::class, 'product_categorywise_sortorder'])->name('product_categorywise_sortorder');

            // Route::any('/product_sortorder_update', [ProductController::class, 'product_sortorder_update'])->name('product_sortorder_update');
            Route::any('/product_sortorder_update/{site}', [ProductController::class, 'product_sortorder_update'])->name('product_sortorder_update');

            Route::any('/dbfldupdate', [ProductController::class, 'dbfldupdate'])->name('dbfldupdate');
            Route::any('/productexceldownload', [ProductController::class, 'productexceldownload'])->name('productexceldownload');
            Route::post('/getcategory', [ProductController::class, 'getcategory'])->name('getcategory');
            Route::get('/status/{id}', [ProductController::class, 'status'])->name('status');
            Route::any('/status-update', [ProductController::class, 'statusUpdate'])->name('status-update');

            Route::any('/rating', [ProductController::class, 'productrating'])->name('productrating');
            Route::post('/productrating_status', [ProductController::class, 'productrating_status'])->name('productrating_status');

            Route::get('/product_attr_delete/{id}', [ProductController::class, 'product_attr_delete'])->name('product_attr_delete');


            Route::any('/product_export', [ProductController::class, 'product_export'])->name('product_export');
            Route::any('/get_data', [ProductController::class, 'get_data'])->name('get_data');

            Route::any('/product-search', [ProductController::class, 'productsearch'])->name('product-search');
            Route::any('/product-view/{id}', [ProductController::class, 'productview'])->name('product-view');
            //Route::any('/search', [ProductController::class, 'productSearch'])->name('productSearch');
        });    

        Route::group(['prefix' => 'category', 'as' => 'category.'], function () {
            Route::any('/', [CategoryController::class, 'list'])->name('list');
            Route::post('/status', [CategoryController::class, 'status'])->name('status');
            Route::any('/add', [CategoryController::class, 'add'])->name('add');
            Route::any('/edit/{id}', [CategoryController::class, 'edit'])->name('edit');
            Route::get('/delete/{id}', [CategoryController::class, 'delete'])->name('delete');
            Route::get('/list_banners/{id}', [CategoryController::class, 'list_banners'])->name('list_banners');
            Route::any('/list_banners_edit/{id}', [CategoryController::class, 'list_banners_edit'])->name('list_banners_edit');
            Route::any('/list_banners_add/{id}', [CategoryController::class, 'list_banners_add'])->name('list_banners_add');
            Route::post('/catbanstatus', [CategoryController::class, 'catbanstatus'])->name('catbanstatus');
            Route::any('/bulkcategoryupload', [CategoryController::class, 'bulkcategoryupload'])->name('bulkcategoryupload');
        });

        Route::group(['prefix' => 'cms', 'as' => 'cms.'], function() {
            Route::any('/', [CmsController::class, 'list'])->name('list');
            Route::any('/add', [CmsController::class, 'add'])->name('add');
            Route::any('/edit/{id}', [CmsController::class, 'edit'])->name('edit');
            Route::post('/status', [CmsController::class, 'status'])->name('status');
            Route::get('/list_cms/{id}', [CmsController::class, 'list_cms'])->name('list_cms');
            Route::any('/list_cms_add/{id}', [CmsController::class, 'list_cms_add'])->name('list_cms_add');
            Route::any('/list_cms_edit/{id}', [CmsController::class, 'list_cms_edit'])->name('list_cms_edit');
            Route::post('/site_cms_status', [CmsController::class, 'site_cms_status'])->name('site_cms_status');
        });

        Route::group(['prefix' => 'addon', 'as' => 'addon.'], function() {
            Route::any('/addon_group', [AddonController::class, 'addon_group'])->name('addon_group');
            Route::any('/addon_group_add', [AddonController::class, 'addon_group_add'])->name('addon_group_add');
            Route::any('/addon_group_edit/{id}', [AddonController::class, 'addon_group_edit'])->name('addon_group_edit');
            // Route::get('/addon_sub/{id}', [AddonController::class, 'addon_sub'])->name('addon_sub');
            // Route::any('/addon_sub1_edit/{id}', [AddonController::class, 'addon_sub1_edit'])->name('addon_sub1_edit');
            Route::post('/addon_group_status', [AddonController::class, 'addon_group_status'])->name('addon_group_status');
            Route::any('/addon_group_product_edit/{id}', [AddonController::class, 'addon_group_product_edit'])->name('addon_group_product_edit');


            Route::any('/addon_sub_group', [AddonController::class, 'addon_sub_group'])->name('addon_sub_group');
            Route::any('/addon_sub_group_add', [AddonController::class, 'addon_sub_group_add'])->name('addon_sub_group_add');
            Route::any('/addon_sub_group_edit/{id}', [AddonController::class, 'addon_sub_group_edit'])->name('addon_sub_group_edit');
            Route::any('/addon_sub_group_product_edit/{id}', [AddonController::class, 'addon_sub_group_product_edit'])->name('addon_sub_group_product_edit');
            Route::any('/getaddon', [AddonController::class, 'getaddon'])->name('getaddon');

            Route::any('/addon_mapping', [AddonController::class, 'addon_mapping'])->name('addon_mapping');
            Route::any('/addon_mapping_add', [AddonController::class, 'addon_mapping_add'])->name('addon_mapping_add');
            Route::any('/addon_mapping_edit/{id}', [AddonController::class, 'addon_mapping_edit'])->name('addon_mapping_edit');

            Route::any('/list', [AddonController::class, 'addon'])->name('addon');
            Route::any('/addon_add', [AddonController::class, 'addon_add'])->name('addon_add');
            Route::any('/addon_edit/{id}', [AddonController::class, 'addon_edit'])->name('addon_edit');

            Route::any('/dragproduct', [AddonController::class, 'dragproduct'])->name('dragproduct');
            Route::any('/sorthomepageproduct', [AddonController::class, 'sorthomepageproduct'])->name('sorthomepageproduct');
        });

        Route::group(['prefix' => 'falseurl', 'as' => 'falseurl.'], function() {
            // Route::group(['prefix' => 'aof', 'as' => 'aof.'], function () {
                Route::any('/list/{id}', [FalseurlController::class, 'list'])->name('list');
                Route::any('/add/{id}', [FalseurlController::class, 'add'])->name('add');
                Route::any('/edit/{id}', [FalseurlController::class, 'edit'])->name('edit');
                Route::any('/status', [FalseurlController::class, 'status'])->name('status');
            // });
        });

        Route::group(['prefix' => 'homefeaturemanagement', 'as' => 'homefeaturemanagement.'], function() {

            Route::any('/list/{id}', [HomeFeatureManagementController::class, 'list'])->name('list');
            Route::any('/add/{id}', [HomeFeatureManagementController::class, 'add'])->name('add');
            Route::any('/edit/{id}', [HomeFeatureManagementController::class, 'edit'])->name('edit');
            Route::any('/categoryproduct', [HomeFeatureManagementController::class, 'categoryproduct'])->name('categoryproduct');
            Route::post('/status', [HomeFeatureManagementController::class, 'status'])->name('status');
            Route::any('/dragproduct', [HomeFeatureManagementController::class, 'dragproduct'])->name('dragproduct');
            Route::any('/sorthomepageproduct', [HomeFeatureManagementController::class, 'sorthomepageproduct'])->name('sorthomepageproduct');

        });

        Route::group(['prefix' => 'city', 'as' => 'city.'], function() {
            Route::any('/list/{id}', [CityController::class, 'list'])->name('list');
            Route::any('/add/{id}', [CityController::class, 'add'])->name('add');
            Route::any('/edit/{id}', [CityController::class, 'edit'])->name('edit');
            Route::post('/status', [CityController::class, 'status'])->name('status');
            Route::any('/bulkcityupload', [CityController::class, 'bulkcityupload'])->name('bulkcityupload');
            Route::any('/bulkcityupdate', [CityController::class, 'bulkcityupdate'])->name('bulkcityupdate');
        });

        Route::group(['prefix' => 'testimonial', 'as' => 'testimonial.'], function() {
            Route::any('/list/{id}', [TestimonialController::class, 'list'])->name('list');
            Route::any('/add/{id}', [TestimonialController::class, 'add'])->name('add');
            Route::any('/edit/{id}', [TestimonialController::class, 'edit'])->name('edit');
            Route::post('/status', [TestimonialController::class, 'status'])->name('status');
            Route::any('/delete/{id}', [TestimonialController::class, 'delete'])->name('delete');
        });

        Route::group(['prefix' => 'coupon', 'as' => 'coupon.'], function () {
            Route::any('/list/{id}', [CouponController::class, 'list'])->name('list');
            Route::any('/add/{id}', [CouponController::class, 'add'])->name('add');
            Route::any('/edit/{id}', [CouponController::class, 'edit'])->name('edit');
            Route::get('/delete/{id}', [CouponController::class, 'delete'])->name('delete');
            Route::post('/status', [CouponController::class, 'status'])->name('status');
        });

        Route::group(['prefix' => 'blog', 'as' => 'blog.'], function () {
            Route::any('/list/{id}', [BlogController::class, 'list'])->name('list');
            Route::any('/add/{id}', [BlogController::class, 'add'])->name('add');
            Route::any('/edit/{id}', [BlogController::class, 'edit'])->name('edit');
            Route::any('/delete/{id}', [BlogController::class, 'delete'])->name('delete');
            Route::any('/status', [BlogController::class, 'status'])->name('status');
        });

        Route::group(['prefix' => 'user', 'as' => 'user.'], function () {
            Route::any('/list', [UserController::class, 'list'])->name('list');
        });

        Route::group(['prefix' => 'agent', 'as' => 'agent.'], function () {

            Route::any('/all-agents', [AdminAgentController::class, 'allAgents'])->name('allAgents');
            Route::any('/add',[AdminAgentController::class,'add'])->name('add');
            Route::any('/edit/{id}',[AdminAgentController::class,'edit'])->name('edit');

            Route::any('/agent-details', [AdminAgentController::class, 'agentDetails'])->name('agentDetails');
            Route::any('/agent-product-list/{id}', [AdminAgentController::class, 'agentProductList'])->name('agentProductList');
            Route::any('/agent-product-list/import-excel/{id}', [AdminAgentController::class, 'importexcel'])->name('importexcel');
            Route::any('/agent-product-add/{id}',[AdminAgentController::class,'agentProductAdd'])->name('agentProductAdd');
            Route::any('/agent-product-edit/{id}',[AdminAgentController::class,'agentProductEdit'])->name('agentProductEdit');
            Route::any('/agent-product-delete/{id}', [AdminAgentController::class, 'agentProductDelete'])->name('agentProductDelete');

            Route::any('/delivery-charge-edit/{id}',[AdminAgentController::class,'deliveryChargeEdit'])->name('deliveryChargeEdit');
            // Route::any('/status', [BlogController::class, 'status'])->name('status');
        });

        Route::any('/logout', [AdminController::class, 'logout'])->name('logout');
    });
});

Route::prefix('agent')->name('agent.')->group(function () {

    Route::get('/',[AgentController::class,'AgentLogin']);
    
    Route::middleware(['guest:AgentLogin'])->group(function () {
        Route::get('/login',[AgentController::class,'AgentLogin'])->name('login');
        Route::post('/dologin',[AgentController::class,'AgentLogedIn'])->name('dologin');
    });

    Route::middleware(['auth:AgentLogin'])->group(function () {

        // Route::get('/dashboard',[AgentController::class,'dashboard'])->name('dashboard');
        // Route::post('/dashboard/search/{agentid}',[AgentController::class,'dashSearch'])->name('dashSearch');
        // Route::get('/generateReport',[AgentController::class,'generateReport'])->name('generateReport');
        // Route::post('/generateReport',[AgentController::class,'GetReport'])->name('GetReport');

        // Route::get('/dashboard/{id}/{agentId}',[AgentController::class,'orderDetails'])->name('orderDetails');
        // Route::post('/dashboard/{id}/{agentId}',[AgentController::class,'UpdateProductStatus'])->name('UpdateProductStatus');  

        // Route::get('/updateStatus',[AgentController::class,'updateStatus'])->name('updateStatus');

        Route::group(['prefix' => 'assignorder', 'as' => 'assignorder.'], function () {
            Route::get('/dashboard',[AgentController::class,'dashboard'])->name('dashboard');
            Route::get('/list',[AgentController::class,'list'])->name('list');
            Route::post('/list/search/{agentid}',[AgentController::class,'listSearch'])->name('listSearch');
            Route::get('/generateReport',[AgentController::class,'generateReport'])->name('generateReport');
            Route::post('/generateReport',[AgentController::class,'GetReport'])->name('GetReport');
            Route::get('/assign-order-view/{id}/{agentId}',[AgentController::class,'assignOrderView'])->name('assignOrderView');
            Route::post('/assign-order-view/{id}/{agentId}',[AgentController::class,'updateAssignOrderStatus'])->name('updateAssignOrderStatus'); 
            Route::get('/updateStatus',[AgentController::class,'updateStatus'])->name('updateStatus');
            route::any('/agent-month-payment',[AgentController::class,'AgentMonthPayment'])->name('AgentMonthPayment');
        });

        Route::any('/logout', [AgentController::class, 'logout'])->name('logout');
    });
});

Route::prefix('csd')->name('csd.')->group(function(){
    Route::middleware(['guest:csd'])->group(function(){
        Route::view('/login', 'csd.login')->name('login');
        Route::any('/dologin',[CSDController::class, 'dologin'])->name('dologin');
    });
    Route::middleware(['auth:csd'])->group(function(){
        // //Route::view('/home', 'csd.home')->name('home');
        Route::get('/home',[CSDController::class,'home'])->name('home');
        Route::get('/inbox',[CSDController::class,'inbox'])->name('inbox');
        Route::post('/inbox',[CSDController::class,'inboxsearch'])->name('inboxsearch');
        Route::get('/sitelabels/{query}/{sitename}',[CSDController::class,'sitelabels'])->name('sitelabels');
        Route::post('/sitelabels/{query}/{sitename}',[CSDController::class,'Searchsitelabels'])->name('Searchsitelabels');
        route::get('/trash',[CSDController::class,'trash'])->name('trash');
        route::post('/trash',[CSDController::class,'Searchtrash'])->name('Searchtrash');
        route::get('/view/delete/{sitename}/{id}',[CSDController::class,'delete_spam'])->name('delete_spam');
        route::get('/spam',[CSDController::class,'spam'])->name('spam');
        // // Route::get('/home/QueryView/{sitename}/{id}',[CSDController::class,'view'])->name('view');
        // // Route::post('/home/QueryView/{sitename}/{id}',[CSDController::class,'view_save'])->name('view_save');
        Route::get('/view/{sitename}/{id}/{siteurl}',[CSDController::class,'view'])->name('view');
        Route::post('/view/{sitename}/{id}',[CSDController::class,'view_save'])->name('view_save');
        Route::get('/markunread/{sitename}/{id}',[CSDController::class,'markunread'])->name('markunread');
        Route::get('/movetoinbox/{sitename}/{id}',[CSDController::class,'movetoinbox'])->name('movetoinbox');
        Route::get('/updatestatus',[CSDController::class,'update_status'])->name('update_status');
        Route::post('/search',[CSDController::class,'search'])->name('search');
        // //route::get('/mail',[CSDController::class,'d_mail'])->name('d_mail');
        // //route::post('/mail',[CSDController::class,'d_mail_send'])->name('d_mail_send');
        Route::any('/sendmail',[CSDController::class,'sendmail'])->name('sendmail');
        // //bulk
        // route::get('/bulk/bulk-inbox',[BulkController::class,'bulk_inbox'])->name('bulk_inbox');
        // route::post('/bulk/bulk-inbox',[BulkController::class,'Searchbulk_inbox'])->name('Searchbulk_inbox');
        // Route::get('/bulk/view/{sitename}/{id}/{siteurl}',[BulkController::class,'view'])->name('view');
        // Route::get('/bulk/markunread/{sitename}/{id}',[BulkController::class,'markunread'])->name('markunread');
        // Route::get('/bulkupdatestatus',[BulkController::class,'update_bulkstatus'])->name('update_bulkstatus');
        // Route::post('/bulk/view/{sitename}/{id}',[BulkController::class,'view_save'])->name('view_save');
        // route::get('/bulkspam',[BulkController::class,'bulkspam'])->name('bulkspam');
        // route::get('/bulk/trash',[BulkController::class,'bulktrash'])->name('bulktrash');
        // route::post('/bulk/trash',[BulkController::class,'Searchbulktrash'])->name('Searchbulktrash');
        // Route::get('/bulk/movetoinbox/{sitename}/{id}',[BulkController::class,'movetoinbox'])->name('movetoinbox');
        // route::get('/bulk/view/delete/{sitename}/{id}',[BulkController::class,'delete_spam'])->name('delete_spam');
        // Route::get('/bulk/sitelabels/{sitename}',[BulkController::class,'sitelabels'])->name('sitelabels');
        // Route::post('/bulk/sitelabels/{sitename}',[BulkController::class,'BulkSearchsitelabels'])->name('BulkSearchsitelabels');
        
        // route::get('/getTime',[CSDController::class,'getTime'])->name('getTime');
        // route::get('/MailCheck',[CSDController::class,'MailCheck'])->name('MailCheck');
        // Route::get('/changepassword',[CSDController::class,'changepassword'])->name('changepassword');
        // Route::post('/logout', [CSDController::class, 'logout'])->name('logout');
        Route::any('/logout', [CSDController::class, 'logout'])->name('logout');
    });
});


// Route::get('/all-agents',[RegisterController::class,'allAgents'])->name('all-agents');
Route::get('/edit/{id}',[RegisterController::class,'register'])->name('edit');
Route::get('/register',[RegisterController::class,'register'])->name('register');
Route::post('/register',[RegisterController::class,'doRegister'])->name('doregister');

//Agent product list and delivery charges

Route::get('/agent-product-list',[RegisterController::class,'agentProductList'])->name('agentProductList');
Route::any('/agent-product-add',[RegisterController::class,'agentProductAdd'])->name('agentProductAdd');
Route::any('/agent-product-edit/{id}',[RegisterController::class,'agentProductEdit'])->name('agentProductEdit');

Route::any('/excel',[ExcelController::class,'excel'])->name('excel');



