<?php $__env->startSection('content'); ?>

    <main id="main" class="main">



        <div class="container">

            <div class="info-box card" style="padding: 10px 12px;">
                <h5>Filters 
                    <?php if($request->agents != null || $request->date_type != null || $request->fromDate != null || $request->toDate != null || $request->delstatus != null): ?>
                        <a href="<?php echo e(route('admin.order.assign-order-list')); ?>" style="font-size: 16px; padding-left: 10px;" ><span class="badge bg-danger"><i class="bi bi-node-minus"></i> Clear Filter</span></a>
                    <?php endif; ?>
                </h5>
                <form action="<?php echo e(route('admin.order.assign-order-list')); ?>" method="get" onsubmit="return validateForm();">
                    <div class="row">
                        <div class="col-2">
                            <label>Agents</label>
                            <select name="agents" id="agents" class="form-control">
                                <option value="" selected>Select Agent</option>
                                <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($agent->id); ?>" <?php if($request->agents == $agent->id): ?> selected <?php endif; ?>><?php echo e(ucwords($agent->name)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-2">
                            <label>Date Type</label>
                            <select name="date_type" id="date_type" class="form-control">
                                <option value="" selected>Select Date Type</option>
                                <option value="d_date" <?php if($request->date_type == 'd_date'): ?> selected <?php endif; ?>>Delivery Date</option>
                                <option value="a_date" <?php if($request->date_type == 'a_date'): ?> selected <?php endif; ?>>Assign Date</option>
                            </select>
                        </div>
                        <div class="col-2">
                            <label>Date From</label>
                            <input type="date" name="fromDate" id="FromDate" class="form-control" value="<?php echo e($request->fromDate); ?>" />
                        </div>
                        <div class="col-2">
                            <label>Date To</label>
                            <input type="date" name="toDate" id="toDate" class="form-control" value="<?php echo e($request->toDate); ?>" />
                        </div>
                        <div class="col-2">
                            <label>Delivery Status</label>
                            <select name="delstatus" id="delstatus" class="form-control">
                                <option value="" selected>SELECT STATUS</option>
                                <option value="P" <?php if($request->delstatus =='P'): ?> selected <?php endif; ?>>PENDING</option>
                                <option value="PC" <?php if($request->delstatus =='PC'): ?> selected <?php endif; ?>>ACCEPTED</option>
                                <option value="S" <?php if($request->delstatus =='S'): ?> selected <?php endif; ?>>SHIPPED</option>
                                <option value="D" <?php if($request->delstatus =='D'): ?> selected <?php endif; ?>>DELIVERED</option>
                                <option value="H" <?php if($request->delstatus =='H'): ?> selected <?php endif; ?>>HOLD</option>
                                <option value="CL" <?php if($request->delstatus =='CL'): ?> selected <?php endif; ?>>CANCELED</option>
                            </select>
                        </div>
                        <div class="col-2" style="padding-top:20px">
                            <button class="btn btn-primary filtersearch" type="submit">Search</button>
                            
                        </div>
                    </div>
                </form>
            </div>

            <div class="row">
                <div class="col-8">
                    <h5 class="card-title">Assign Order List</h5>

                </div>
                <div class="col-4 ms-auto text-end" style="display:flex; align-items: center;">
                    <form method="GET" action="<?php echo e(route('admin.order.assign-order-list')); ?>" style="width:100%" >
                        <div class="input-group">
                          <input type="text" name="search" id="search-field" class="form-control" placeholder="Search by Order ID" autocomplete="off" required>
                          <button type="submit" class="input-group-text"><i class="bx bx-search-alt"></i></button>
                        </div>
                    </form>
                </div>
            </div>

            <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(Session::has('alert-' . $msg)): ?>
                    <div class="alert alert-<?php echo e($msg); ?> alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-1"></i>
                        <?php echo e(Session::get('alert-' . $msg)); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($request->search != null): ?>
                <p style="font-size: 13px;">
                    Searched for: "<?php echo e($request->search); ?>" <a href="<?php echo e(route('admin.order.assign-order-list')); ?>" style="font-size: 13px; padding-left: 10px;" class="badge border-danger border-1 text-danger">Clear Search</a>
                </p>
            <?php endif; ?>


            <?php if(count($result) > 0): ?>

                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th scope="col" style="width:5%">#</th>
                            <th scope="col" style="width:14%">Assign Order Id</th>
                            <th scope="col" style="width:15%"><?php echo CustomPaginator::sort('agent_id', 'Agent Name'); ?></th>
                            <th scope="col" style="width:22%">Products</th>
                            <th scope="col" style="width:11%"><?php echo CustomPaginator::sort('delivery_date', 'Delivery Date'); ?></th>
                            <th scope="col" style="width:12%"><?php echo CustomPaginator::sort('status', 'Delivery Status'); ?></th>
                            <th scope="col" style="width:14%"><?php echo CustomPaginator::sort('created_at', 'Agent Placed Date'); ?></th>
                            <th scope="col" style="width:4%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = ($result->currentPage() - 1) * $result->perPage() + 1; ?>
                        <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <tr>
                            <td scope="row"><?php echo e($i + $key); ?></td>
                            <td>
                                <?php echo e($order->agent_order_id); ?><br>
                                <?php
                                    $orderDtl = App\Http\Helper1::getorderDtl($order->OID); 
                                ?>
                                <span class="badge rounded-pill bg-light text-primary"><?php echo e($orderDtl->unique_order_id); ?></span>
                            </td>
                            <td>
                                <?php
                                    $agentDtl = App\Http\Helper1::getAgentDtl($order->agent_id); 
                                ?>
                                <?php echo e(ucwords($agentDtl->name)); ?>

                            </td>
                            <td>
                                <?php
                                    $agentProductDtl = App\Http\Helper1::getAgentPlaceProductDtl($order->id); 
                                ?>
                                <?php $__currentLoopData = $agentProductDtl; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e(ucwords($product->item)); ?><span style="color:grey">(<?php echo e($product->qty); ?>)</span> 
                                    <?php if(!$loop->last): ?>, <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td><?php echo e(date("d/m/Y" , strtotime($order->delivery_date))); ?></td>
                            <td>
                                <h5>
                                    <?php if($order->status == 'P'): ?>
                                        <span class="badge bg-danger">Pending</span>
                                    <?php elseif($order->status == 'PC'): ?>
                                        <span class="badge bg-info">Accepted</span>
                                    <?php elseif($order->status == 'H'): ?>
                                        <span class="badge bg-warning">Hold</span>
                                    <?php elseif($order->status == 'CL'): ?>
                                        <span class="badge bg-dark">Cancel</span>
                                    <?php elseif($order->status == 'D'): ?>
                                        <span class="badge bg-success">Delivered</span>
                                    <?php elseif($order->status == 'S'): ?>
                                        <span class="badge bg-primary">Shipped</span>
                                    <?php endif; ?>
                                </h5>
                            </td>
                            <td><?php echo e(date("d/m/Y H:m" , strtotime($order->created_at))); ?></td>
                            <td>
                                <div class="row">
                                    <div class="col">
                                        <a href="<?php echo e(url('/admin/order/assign-order-view')); ?>/<?php echo e(encrypt($order->agent_order_id)); ?>/<?php echo e(encrypt($order->agent_id)); ?>"><i class="ri-file-edit-fill adminedit"></i></a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div>
                    <table  class="table">
                        <?php if($result->hasPages()): ?>
                        <tr>
                            <td style="width:auto; text-align:center; border:none;" >
                                <nav role="navigation" aria-label="Pagination Navigation" class="flex justify-between">
                                <span>
                                    <?php if($result->onFirstPage()): ?>
                                        <span></span>
                                    <?php else: ?>
                                        <a href="<?php echo e($result->previousPageUrl()); ?>" class="btn btn-secondary btn-sm" rel="prev"><i class="bx bxs-chevron-left"></i></a>
                                    <?php endif; ?>
                                </span>
                                    <?php $__currentLoopData = range(1, $result->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($i >= $result->currentPage() - 2 && $i <= $result->currentPage() + 2): ?>
                                            <?php if($i == $result->currentPage()): ?>
                                            <a href="" class="btn btn-secondary btn-sm" style="background: white;color: black;"><?php echo e($i); ?></a>
                                            <?php else: ?>
                                            <a href="<?php echo e($result->url($i)); ?>" class="btn btn-secondary btn-sm"><?php echo e($i); ?></a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <span>
                                    <?php if($result->hasMorePages()): ?>
                                         <a href="<?php echo e($result->nextPageUrl()); ?>" rel="next" class="btn btn-secondary btn-sm" ><i class="bx bxs-chevron-right"></i></a>
                                    <?php else: ?>
                                        <span></span>
                                    <?php endif; ?>
                                    </span>
                                </nav>
                            </td>
                        </tr>
                        <?php endif; ?>   
                    </table>
                </div>

            <?php else: ?>
                <div class="card" style="padding: 10px 12px;">No Data Found...</div>
            <?php endif; ?>

            
            
        </div>
    </main>

<script>

function validateForm() {
    var agents = $('#agents').val();
    var dateType = $('#date_type').val();
    var fromDate = $('#FromDate').val();
    var toDate = $('#toDate').val();
    var delstatus = $('#delstatus').val();

    if (agents === "" && dateType === "" && fromDate === "" && toDate === "" && delstatus === "") {
        return false;
    }

    // Rule 1: If date_type is selected, both fromDate and toDate are required
    if (dateType !== "") {
        if (fromDate === "") {
            //alert("Please select From Date.");
            $('#FromDate').focus();
            return false;
        }

        if (toDate === "") {
            //alert("Please select To Date.");
            $('#toDate').focus();
            return false;
        }
    }

    // Rule 2: If one date is filled, the other must be filled too
    if (fromDate !== "" && toDate === "") {
        //alert("Please select To Date.");
        $('#toDate').focus();
        return false;
    }

    if (toDate !== "" && fromDate === "") {
        //alert("Please select From Date.");
        $('#FromDate').focus();
        return false;
    }

    return true; // All validation passed
}
    
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rightflorist/public_html/ofadmin.rightflorist.org/resources/views/admin/order/assign_order_list.blade.php ENDPATH**/ ?>